/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.geode.admin.AdminXmlException;
import org.apache.geode.admin.CacheServerConfig;
import org.apache.geode.admin.CacheVmConfig;
import org.apache.geode.admin.DistributedSystemConfig;
import org.apache.geode.admin.DistributionLocator;
import org.apache.geode.admin.DistributionLocatorConfig;
import org.apache.geode.admin.internal.AdminDistributedSystemImpl;
import org.apache.geode.admin.internal.CacheServerConfigImpl;
import org.apache.geode.admin.internal.DistributionLocatorConfigImpl;
import org.apache.geode.admin.internal.InetAddressUtil;
import org.apache.geode.admin.internal.ManagedEntityConfigXmlParser;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.DistributionConfigImpl;
import org.apache.geode.internal.logging.InternalLogWriter;
import org.apache.geode.internal.logging.LogConfig;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LogWriterImpl;
import org.apache.geode.internal.logging.log4j.LogLevel;
import org.apache.geode.internal.statistics.StatisticsConfig;
import org.apache.logging.log4j.Logger;

public class DistributedSystemConfigImpl
implements DistributedSystemConfig {
    private static final Logger logger = LogService.getLogger();
    private String entityConfigXMLFile = "distributed-system.xml";
    private String systemId = "Default System";
    private String mcastAddress = DEFAULT_MCAST_ADDRESS;
    private int mcastPort = 0;
    private int ackWaitThreshold = 15;
    private int ackSevereAlertThreshold = 0;
    private String locators = "";
    private String bindAddress = "";
    private String serverBindAddress = "";
    private String remoteCommand = "rsh -n {HOST} {CMD}";
    private boolean disableTcp = false;
    private boolean disableJmx = false;
    private boolean enableNetworkPartitionDetection = true;
    private boolean disableAutoReconnect = false;
    private int memberTimeout = 5000;
    private String membershipPortRange = DistributedSystemConfigImpl.getMembershipPortRangeString(DEFAULT_MEMBERSHIP_PORT_RANGE);
    private int tcpPort = 0;
    private String logFile = "";
    private String logLevel = "config";
    private int logDiskSpaceLimit = 0;
    private int logFileSizeLimit = 0;
    private int refreshInterval = 15;
    private Properties gfSecurityProperties = new Properties();
    private Set listeners = new HashSet();
    private Set cacheServerConfigs = new HashSet();
    private Set locatorConfigs = new HashSet();
    private String systemName = "";
    private AdminDistributedSystemImpl system;
    private InternalLogWriter logWriter;
    private static final boolean ALLOW_ALL_REMOTE_COMMANDS = Boolean.getBoolean("gemfire.admin.ALLOW_ALL_REMOTE_COMMANDS");
    private static final String[] LEGAL_REMOTE_COMMANDS = new String[]{"rsh", "ssh"};
    private static final String ILLEGAL_REMOTE_COMMAND_RSH_OR_SSH = "Allowed remote commands include \"rsh {HOST} {CMD}\" or \"ssh {HOST} {CMD}\" with valid rsh or ssh switches. Invalid: ";
    private boolean sslEnabled = false;
    private String sslProtocols = "any";
    private String sslCiphers = "any";
    private boolean sslAuthenticationRequired = true;
    private Properties sslProperties = new Properties();

    private static Properties filterOutAdminProperties(Properties props) {
        Properties props2 = new Properties();
        Enumeration<?> names = props.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if ("entity-config-xml-file".equals(name) || "refresh-interval".equals(name) || "remote-command".equals(name)) continue;
            String value = props.getProperty(name);
            if (name == null || value == null) continue;
            props2.setProperty(name, value);
        }
        return props2;
    }

    public DistributedSystemConfigImpl(DistributionConfig distConfig, String remoteCommand) {
        if (distConfig == null) {
            throw new IllegalArgumentException("DistributionConfig must not be null.");
        }
        this.mcastAddress = InetAddressUtil.toString(distConfig.getMcastAddress());
        this.mcastPort = distConfig.getMcastPort();
        this.locators = distConfig.getLocators();
        this.membershipPortRange = DistributedSystemConfigImpl.getMembershipPortRangeString(distConfig.getMembershipPortRange());
        this.systemName = distConfig.getName();
        this.sslEnabled = distConfig.getClusterSSLEnabled();
        this.sslCiphers = distConfig.getClusterSSLCiphers();
        this.sslProtocols = distConfig.getClusterSSLProtocols();
        this.sslAuthenticationRequired = distConfig.getClusterSSLRequireAuthentication();
        this.logFile = distConfig.getLogFile().getPath();
        this.logLevel = LogWriterImpl.levelToString(distConfig.getLogLevel());
        this.logDiskSpaceLimit = distConfig.getLogDiskSpaceLimit();
        this.logFileSizeLimit = distConfig.getLogFileSizeLimit();
        this.basicSetBindAddress(distConfig.getBindAddress());
        this.tcpPort = distConfig.getTcpPort();
        this.disableTcp = distConfig.getDisableTcp();
        this.remoteCommand = remoteCommand;
        this.serverBindAddress = distConfig.getServerBindAddress();
        this.enableNetworkPartitionDetection = distConfig.getEnableNetworkPartitionDetection();
        this.memberTimeout = distConfig.getMemberTimeout();
        this.refreshInterval = 15;
        this.gfSecurityProperties = (Properties)distConfig.getSSLProperties().clone();
    }

    protected DistributedSystemConfigImpl() {
    }

    protected DistributedSystemConfigImpl(Properties props) {
        this(props, false);
    }

    protected DistributedSystemConfigImpl(Properties props, boolean ignoreGemFirePropsFile) {
        this(new DistributionConfigImpl(DistributedSystemConfigImpl.filterOutAdminProperties(props), ignoreGemFirePropsFile), "rsh -n {HOST} {CMD}");
        String refreshInterval;
        String entityConfigXMLFile;
        String remoteCommand = props.getProperty("remote-command");
        if (remoteCommand != null) {
            this.remoteCommand = remoteCommand;
        }
        if ((entityConfigXMLFile = props.getProperty("entity-config-xml-file")) != null) {
            this.entityConfigXMLFile = entityConfigXMLFile;
        }
        if ((refreshInterval = props.getProperty("refresh-interval")) != null) {
            try {
                this.refreshInterval = Integer.parseInt(refreshInterval);
            }
            catch (NumberFormatException nfEx) {
                throw new IllegalArgumentException(String.format("%s is not a valid integer for %s", refreshInterval, "refresh-interval"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalLogWriter getInternalLogWriter() {
        DistributedSystemConfigImpl distributedSystemConfigImpl = this;
        synchronized (distributedSystemConfigImpl) {
            return this.logWriter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInternalLogWriter(InternalLogWriter logWriter) {
        DistributedSystemConfigImpl distributedSystemConfigImpl = this;
        synchronized (distributedSystemConfigImpl) {
            this.logWriter = logWriter;
        }
    }

    public LogConfig createLogConfig() {
        return new LogConfig(){

            @Override
            public int getLogLevel() {
                return LogLevel.getLogWriterLevel(DistributedSystemConfigImpl.this.getLogLevel());
            }

            @Override
            public File getLogFile() {
                return new File(DistributedSystemConfigImpl.this.getLogFile());
            }

            @Override
            public File getSecurityLogFile() {
                return null;
            }

            @Override
            public int getSecurityLogLevel() {
                return LogLevel.getLogWriterLevel(DistributedSystemConfigImpl.this.getLogLevel());
            }

            @Override
            public int getLogFileSizeLimit() {
                return DistributedSystemConfigImpl.this.getLogFileSizeLimit();
            }

            @Override
            public int getLogDiskSpaceLimit() {
                return DistributedSystemConfigImpl.this.getLogDiskSpaceLimit();
            }

            @Override
            public String getName() {
                return DistributedSystemConfigImpl.this.getSystemName();
            }

            @Override
            public String toLoggerString() {
                return DistributedSystemConfigImpl.this.toString();
            }

            @Override
            public boolean isLoner() {
                return false;
            }
        };
    }

    public StatisticsConfig createStatisticsConfig() {
        return new StatisticsConfig(){

            @Override
            public File getStatisticArchiveFile() {
                return null;
            }

            @Override
            public int getArchiveFileSizeLimit() {
                return 0;
            }

            @Override
            public int getArchiveDiskSpaceLimit() {
                return 0;
            }

            @Override
            public int getStatisticSampleRate() {
                return 0;
            }

            @Override
            public boolean getStatisticSamplingEnabled() {
                return false;
            }
        };
    }

    void setDistributedSystem(AdminDistributedSystemImpl system) {
        this.system = system;
    }

    protected void checkReadOnly() {
        if (this.system != null) {
            throw new IllegalStateException("A DistributedSystemConfig object cannot be modified after it has been used to create an AdminDistributedSystem.");
        }
    }

    @Override
    public String getEntityConfigXMLFile() {
        return this.entityConfigXMLFile;
    }

    @Override
    public void setEntityConfigXMLFile(String xmlFile) {
        this.checkReadOnly();
        this.entityConfigXMLFile = xmlFile;
        this.configChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseEntityConfigXMLFile() {
        String fileName = this.entityConfigXMLFile;
        File xmlFile = new File(fileName);
        if (!xmlFile.exists()) {
            if ("distributed-system.xml".equals(fileName)) {
                return;
            }
            throw new AdminXmlException(String.format("Entity configuration XML file %s does not exist", fileName));
        }
        try (FileInputStream is = new FileInputStream(xmlFile);){
            ManagedEntityConfigXmlParser.parse(is, this);
        }
        catch (IOException ex) {
            throw new AdminXmlException(String.format("While parsing %s", fileName), ex);
        }
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public void setSystemId(String systemId) {
        this.checkReadOnly();
        this.systemId = systemId;
        this.configChanged();
    }

    @Override
    public String getMcastAddress() {
        return this.mcastAddress;
    }

    @Override
    public void setMcastAddress(String mcastAddress) {
        this.checkReadOnly();
        this.mcastAddress = mcastAddress;
        this.configChanged();
    }

    @Override
    public int getMcastPort() {
        return this.mcastPort;
    }

    @Override
    public void setMcastPort(int mcastPort) {
        this.checkReadOnly();
        this.mcastPort = mcastPort;
        this.configChanged();
    }

    @Override
    public int getAckWaitThreshold() {
        return this.ackWaitThreshold;
    }

    @Override
    public void setAckWaitThreshold(int seconds) {
        this.checkReadOnly();
        this.ackWaitThreshold = seconds;
        this.configChanged();
    }

    @Override
    public int getAckSevereAlertThreshold() {
        return this.ackSevereAlertThreshold;
    }

    @Override
    public void setAckSevereAlertThreshold(int seconds) {
        this.checkReadOnly();
        this.ackSevereAlertThreshold = seconds;
        this.configChanged();
    }

    @Override
    public String getLocators() {
        return this.locators;
    }

    @Override
    public void setLocators(String locators) {
        this.checkReadOnly();
        this.locators = locators == null ? "" : locators;
        this.configChanged();
    }

    @Override
    public String getMembershipPortRange() {
        return this.membershipPortRange;
    }

    @Override
    public void setMembershipPortRange(String membershipPortRangeStr) {
        block5: {
            this.checkReadOnly();
            if (membershipPortRangeStr == null) {
                this.membershipPortRange = DistributedSystemConfigImpl.getMembershipPortRangeString(DEFAULT_MEMBERSHIP_PORT_RANGE);
            } else {
                try {
                    if (!this.validateMembershipRange(membershipPortRangeStr)) {
                        throw new IllegalArgumentException(String.format("The value specified %s is invalid for the property : %s. This range should be specified as min-max.", membershipPortRangeStr, "membership-port-range"));
                    }
                    this.membershipPortRange = membershipPortRangeStr;
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block5;
                    logger.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public void setTcpPort(int port) {
        this.checkReadOnly();
        this.tcpPort = port;
        this.configChanged();
    }

    @Override
    public int getTcpPort() {
        return this.tcpPort;
    }

    private boolean validateMembershipRange(String membershipPortRange) {
        String[] splitted;
        int[] range = null;
        if (membershipPortRange != null && membershipPortRange.trim().length() > 0 && ((range = new int[]{Integer.parseInt((splitted = membershipPortRange.split("-"))[0].trim()), Integer.parseInt(splitted[1].trim())})[0] < 0 || range[0] >= range[1] || range[1] < 0 || range[1] > 65535)) {
            range = null;
        }
        return range != null;
    }

    private static String getMembershipPortRangeString(int[] membershipPortRange) {
        String membershipPortRangeString = "";
        if (membershipPortRange != null && membershipPortRange.length == 2) {
            membershipPortRangeString = membershipPortRange[0] + "-" + membershipPortRange[1];
        }
        return membershipPortRangeString;
    }

    @Override
    public String getBindAddress() {
        return this.bindAddress;
    }

    @Override
    public void setBindAddress(String bindAddress) {
        this.checkReadOnly();
        this.basicSetBindAddress(bindAddress);
        this.configChanged();
    }

    @Override
    public String getServerBindAddress() {
        return this.serverBindAddress;
    }

    @Override
    public void setServerBindAddress(String bindAddress) {
        this.checkReadOnly();
        this.basicSetServerBindAddress(bindAddress);
        this.configChanged();
    }

    @Override
    public boolean getDisableTcp() {
        return this.disableTcp;
    }

    @Override
    public void setDisableTcp(boolean flag) {
        this.checkReadOnly();
        this.disableTcp = flag;
        this.configChanged();
    }

    @Override
    public boolean getDisableJmx() {
        return this.disableJmx;
    }

    @Override
    public void setDisableJmx(boolean flag) {
        this.checkReadOnly();
        this.disableJmx = flag;
        this.configChanged();
    }

    @Override
    public void setEnableNetworkPartitionDetection(boolean newValue) {
        this.checkReadOnly();
        this.enableNetworkPartitionDetection = newValue;
        this.configChanged();
    }

    @Override
    public boolean getEnableNetworkPartitionDetection() {
        return this.enableNetworkPartitionDetection;
    }

    @Override
    public void setDisableAutoReconnect(boolean newValue) {
        this.checkReadOnly();
        this.disableAutoReconnect = newValue;
        this.configChanged();
    }

    @Override
    public boolean getDisableAutoReconnect() {
        return this.disableAutoReconnect;
    }

    @Override
    public int getMemberTimeout() {
        return this.memberTimeout;
    }

    @Override
    public void setMemberTimeout(int value) {
        this.checkReadOnly();
        this.memberTimeout = value;
        this.configChanged();
    }

    private void basicSetBindAddress(String bindAddress) {
        if (!DistributedSystemConfigImpl.validateBindAddress(bindAddress)) {
            throw new IllegalArgumentException(String.format("Invalid bind address: %s", bindAddress));
        }
        this.bindAddress = bindAddress;
    }

    private void basicSetServerBindAddress(String bindAddress) {
        if (!DistributedSystemConfigImpl.validateBindAddress(bindAddress)) {
            throw new IllegalArgumentException(String.format("Invalid bind address: %s", bindAddress));
        }
        this.serverBindAddress = bindAddress;
    }

    @Override
    public String getRemoteCommand() {
        return this.remoteCommand;
    }

    @Override
    public void setRemoteCommand(String remoteCommand) {
        if (!ALLOW_ALL_REMOTE_COMMANDS) {
            this.checkRemoteCommand(remoteCommand);
        }
        this.remoteCommand = remoteCommand;
        this.configChanged();
    }

    private void checkRemoteCommand(String remoteCommand) {
        if (remoteCommand == null || remoteCommand.isEmpty()) {
            return;
        }
        String command = remoteCommand.toLowerCase().trim();
        if (!command.contains("{host}") || !command.contains("{cmd}")) {
            throw new IllegalArgumentException(ILLEGAL_REMOTE_COMMAND_RSH_OR_SSH + remoteCommand);
        }
        StringTokenizer tokenizer = new StringTokenizer(command, " ");
        ArrayList<String> array = new ArrayList<String>();
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String string = tokenizer.nextToken();
            if (i == 0) {
                boolean found = false;
                for (int j = 0; j < LEGAL_REMOTE_COMMANDS.length; ++j) {
                    if (!string.contains(LEGAL_REMOTE_COMMANDS[j])) continue;
                    if (!string.endsWith(LEGAL_REMOTE_COMMANDS[j]) && !string.endsWith(LEGAL_REMOTE_COMMANDS[j] + ".exe")) {
                        throw new IllegalArgumentException(ILLEGAL_REMOTE_COMMAND_RSH_OR_SSH + remoteCommand);
                    }
                    found = true;
                }
                if (!found) {
                    throw new IllegalArgumentException(ILLEGAL_REMOTE_COMMAND_RSH_OR_SSH + remoteCommand);
                }
            } else {
                boolean isHostOrCmd;
                boolean isSwitch = string.startsWith("-");
                boolean bl = isHostOrCmd = string.equals("{host}") || string.equals("{cmd}");
                if (!isSwitch && !isHostOrCmd) {
                    boolean isHostWithUser;
                    String previous = array.isEmpty() ? null : (String)array.get(array.size() - 1);
                    boolean isValueForSwitch = previous != null && previous.startsWith("-");
                    boolean bl2 = isHostWithUser = string.contains("@") && string.endsWith("{host}");
                    if (!isValueForSwitch && !isHostWithUser) {
                        throw new IllegalArgumentException(ILLEGAL_REMOTE_COMMAND_RSH_OR_SSH + remoteCommand);
                    }
                }
            }
            array.add(string);
            ++i;
        }
    }

    @Override
    public String getSystemName() {
        return this.systemName;
    }

    @Override
    public void setSystemName(String systemName) {
        this.checkReadOnly();
        this.systemName = systemName;
        this.configChanged();
    }

    @Override
    public CacheServerConfig[] getCacheServerConfigs() {
        return this.cacheServerConfigs.toArray(new CacheServerConfig[this.cacheServerConfigs.size()]);
    }

    @Override
    public CacheVmConfig[] getCacheVmConfigs() {
        return this.cacheServerConfigs.toArray(new CacheVmConfig[this.cacheServerConfigs.size()]);
    }

    @Override
    public CacheServerConfig createCacheServerConfig() {
        CacheServerConfigImpl config = new CacheServerConfigImpl();
        this.addCacheServerConfig(config);
        return config;
    }

    @Override
    public CacheVmConfig createCacheVmConfig() {
        return this.createCacheServerConfig();
    }

    private void addCacheServerConfig(CacheServerConfig managerConfig) {
        this.checkReadOnly();
        if (managerConfig == null) {
            return;
        }
        for (CacheServerConfigImpl impl : this.cacheServerConfigs) {
            if (!impl.equals(managerConfig)) continue;
            return;
        }
        this.cacheServerConfigs.add(managerConfig);
        this.configChanged();
    }

    @Override
    public void removeCacheServerConfig(CacheServerConfig managerConfig) {
        this.removeCacheVmConfig(managerConfig);
    }

    @Override
    public void removeCacheVmConfig(CacheVmConfig managerConfig) {
        this.checkReadOnly();
        this.cacheServerConfigs.remove(managerConfig);
        this.configChanged();
    }

    @Override
    public DistributionLocatorConfig[] getDistributionLocatorConfigs() {
        if (this.system != null) {
            DistributionLocator[] locators = this.system.getDistributionLocators();
            DistributionLocatorConfig[] configs = new DistributionLocatorConfig[locators.length];
            for (int i = 0; i < locators.length; ++i) {
                configs[i] = locators[i].getConfig();
            }
            return configs;
        }
        DistributionLocatorConfig[] array = new DistributionLocatorConfig[this.locatorConfigs.size()];
        return this.locatorConfigs.toArray(array);
    }

    @Override
    public DistributionLocatorConfig createDistributionLocatorConfig() {
        this.checkReadOnly();
        DistributionLocatorConfigImpl config = new DistributionLocatorConfigImpl();
        this.addDistributionLocatorConfig(config);
        return config;
    }

    private void addDistributionLocatorConfig(DistributionLocatorConfig config) {
        this.checkReadOnly();
        this.locatorConfigs.add(config);
        this.configChanged();
    }

    @Override
    public void removeDistributionLocatorConfig(DistributionLocatorConfig config) {
        this.checkReadOnly();
        this.locatorConfigs.remove(config);
        this.configChanged();
    }

    public static boolean validateBindAddress(String bindAddress) {
        if (bindAddress == null || bindAddress.length() == 0) {
            return true;
        }
        return InetAddressUtil.validateHost(bindAddress) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void configChanged() {
        DistributedSystemConfig.ConfigListener[] clients = null;
        Set set = this.listeners;
        synchronized (set) {
            clients = this.listeners.toArray(new DistributedSystemConfig.ConfigListener[this.listeners.size()]);
        }
        for (int i = 0; i < clients.length; ++i) {
            try {
                clients[i].configChanged(this);
                continue;
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(DistributedSystemConfig.ConfigListener listener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(DistributedSystemConfig.ConfigListener listener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public boolean isSSLEnabled() {
        return this.sslEnabled;
    }

    @Override
    public void setSSLEnabled(boolean enabled) {
        this.checkReadOnly();
        this.sslEnabled = enabled;
        this.configChanged();
    }

    @Override
    public String getSSLProtocols() {
        return this.sslProtocols;
    }

    @Override
    public void setSSLProtocols(String protocols) {
        this.checkReadOnly();
        this.sslProtocols = protocols;
        this.configChanged();
    }

    @Override
    public String getSSLCiphers() {
        return this.sslCiphers;
    }

    @Override
    public void setSSLCiphers(String ciphers) {
        this.checkReadOnly();
        this.sslCiphers = ciphers;
        this.configChanged();
    }

    @Override
    public boolean isSSLAuthenticationRequired() {
        return this.sslAuthenticationRequired;
    }

    @Override
    public void setSSLAuthenticationRequired(boolean authRequired) {
        this.checkReadOnly();
        this.sslAuthenticationRequired = authRequired;
        this.configChanged();
    }

    @Override
    public Properties getSSLProperties() {
        return this.sslProperties;
    }

    @Override
    public void setSSLProperties(Properties sslProperties) {
        this.checkReadOnly();
        this.sslProperties = sslProperties;
        if (this.sslProperties == null) {
            this.sslProperties = new Properties();
        }
        this.configChanged();
    }

    @Override
    public void addSSLProperty(String key, String value) {
        this.checkReadOnly();
        this.sslProperties.put(key, value);
        this.configChanged();
    }

    @Override
    public void removeSSLProperty(String key) {
        this.checkReadOnly();
        this.sslProperties.remove(key);
        this.configChanged();
    }

    public Properties getGfSecurityProperties() {
        return this.gfSecurityProperties;
    }

    @Override
    public String getLogFile() {
        return this.logFile;
    }

    @Override
    public void setLogFile(String logFile) {
        this.checkReadOnly();
        this.logFile = logFile;
        this.configChanged();
    }

    @Override
    public String getLogLevel() {
        return this.logLevel;
    }

    @Override
    public void setLogLevel(String logLevel) {
        this.checkReadOnly();
        this.logLevel = logLevel;
        this.configChanged();
    }

    @Override
    public int getLogDiskSpaceLimit() {
        return this.logDiskSpaceLimit;
    }

    @Override
    public void setLogDiskSpaceLimit(int limit) {
        this.checkReadOnly();
        this.logDiskSpaceLimit = limit;
        this.configChanged();
    }

    @Override
    public int getLogFileSizeLimit() {
        return this.logFileSizeLimit;
    }

    @Override
    public void setLogFileSizeLimit(int limit) {
        this.checkReadOnly();
        this.logFileSizeLimit = limit;
        this.configChanged();
    }

    @Override
    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    @Override
    public void setRefreshInterval(int timeInSecs) {
        this.checkReadOnly();
        this.refreshInterval = timeInSecs;
        this.configChanged();
    }

    @Override
    public void validate() {
        if (this.getMcastPort() < 0 || this.getMcastPort() > 65535) {
            throw new IllegalArgumentException(String.format("mcastPort must be an integer inclusively between %s and %s", 0, 65535));
        }
        LogLevel.getLogWriterLevel(this.logLevel);
        if (this.logFileSizeLimit < 0 || this.logFileSizeLimit > 1000000) {
            throw new IllegalArgumentException(String.format("LogFileSizeLimit must be an integer between %s and %s", 0, 1000000));
        }
        if (this.logDiskSpaceLimit < 0 || this.logDiskSpaceLimit > 1000000) {
            throw new IllegalArgumentException(String.format("LogDiskSpaceLimit must be an integer between %s and %s", 0, 1000000));
        }
        this.parseEntityConfigXMLFile();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DistributedSystemConfigImpl other = (DistributedSystemConfigImpl)super.clone();
        other.system = null;
        other.cacheServerConfigs = new HashSet();
        other.locatorConfigs = new HashSet();
        DistributionLocatorConfig[] myLocators = this.getDistributionLocatorConfigs();
        for (int i = 0; i < myLocators.length; ++i) {
            DistributionLocatorConfig locator = myLocators[i];
            other.addDistributionLocatorConfig((DistributionLocatorConfig)locator.clone());
        }
        CacheServerConfig[] myCacheServers = this.getCacheServerConfigs();
        for (int i = 0; i < myCacheServers.length; ++i) {
            CacheServerConfig locator = myCacheServers[i];
            other.addCacheServerConfig((CacheServerConfig)locator.clone());
        }
        return other;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(1000);
        String lf = System.getProperty("line.separator");
        if (lf == null) {
            lf = ",";
        }
        buf.append("DistributedSystemConfig(");
        buf.append(lf);
        buf.append("  system-name=");
        buf.append(String.valueOf(this.systemName));
        buf.append(lf);
        buf.append("  mcast-address=");
        buf.append(String.valueOf(this.mcastAddress));
        buf.append(lf);
        buf.append("  mcast-port=");
        buf.append(String.valueOf(this.mcastPort));
        buf.append(lf);
        buf.append("  locators=");
        buf.append(String.valueOf(this.locators));
        buf.append(lf);
        buf.append("  membership-port-range=");
        buf.append(this.getMembershipPortRange());
        buf.append(lf);
        buf.append("  bind-address=");
        buf.append(String.valueOf(this.bindAddress));
        buf.append(lf);
        buf.append("  tcp-port=" + this.tcpPort);
        buf.append(lf);
        buf.append("  disable-tcp=");
        buf.append(String.valueOf(this.disableTcp));
        buf.append(lf);
        buf.append("  disable-jmx=");
        buf.append(this.disableJmx);
        buf.append(lf);
        buf.append("  disable-auto-reconnect=");
        buf.append(String.valueOf(this.disableAutoReconnect));
        buf.append(lf);
        buf.append("  remote-command=");
        buf.append(String.valueOf(this.remoteCommand));
        buf.append(lf);
        buf.append("  cluster-ssl-enabled=");
        buf.append(String.valueOf(this.sslEnabled));
        buf.append(lf);
        buf.append("  cluster-ssl-ciphers=");
        buf.append(String.valueOf(this.sslCiphers));
        buf.append(lf);
        buf.append("  cluster-ssl-protocols=");
        buf.append(String.valueOf(this.sslProtocols));
        buf.append(lf);
        buf.append("  cluster-ssl-require-authentication=");
        buf.append(String.valueOf(this.sslAuthenticationRequired));
        buf.append(lf);
        buf.append("  log-file=");
        buf.append(String.valueOf(this.logFile));
        buf.append(lf);
        buf.append("  log-level=");
        buf.append(String.valueOf(this.logLevel));
        buf.append(lf);
        buf.append("  log-disk-space-limit=");
        buf.append(String.valueOf(this.logDiskSpaceLimit));
        buf.append(lf);
        buf.append("  log-file-size-limit=");
        buf.append(String.valueOf(this.logFileSizeLimit));
        buf.append(lf);
        buf.append("  refresh-interval=");
        buf.append(String.valueOf(this.refreshInterval));
        buf.append(")");
        return buf.toString();
    }
}

