/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.sortedset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.DoubleWrapper;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.SortedSetQuery;
import org.apache.geode.redis.internal.executor.sortedset.SortedSetExecutor;

public class ZRemRangeByLexExecutor
extends SortedSetExecutor {
    private final int ERROR_NOT_EXISTS = 0;
    private final String ERROR_ILLEGAL_SYNTAX = "The min and max strings must either start with a (, [ or be - or +";

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        Collection<ByteArrayWrapper> removeList;
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 4) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the ZREMRANGEBYLEX command is \"ZREMRANGEBYLEX key min max\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        this.checkDataType(key, RedisDataType.REDIS_SORTEDSET, context);
        Region<ByteArrayWrapper, DoubleWrapper> keyRegion = this.getRegion(context, key);
        if (keyRegion == null) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
            return;
        }
        boolean minInclusive = false;
        boolean maxInclusive = false;
        byte[] minArray = commandElems.get(2);
        byte[] maxArray = commandElems.get(3);
        String startString = Coder.bytesToString(minArray);
        String stopString = Coder.bytesToString(maxArray);
        if (minArray[0] == 40) {
            startString = startString.substring(1);
            minInclusive = false;
        } else if (minArray[0] == 91) {
            startString = startString.substring(1);
            minInclusive = true;
        } else if (minArray[0] != 45) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The min and max strings must either start with a (, [ or be - or +"));
            return;
        }
        if (maxArray[0] == 40) {
            stopString = stopString.substring(1);
            maxInclusive = false;
        } else if (maxArray[0] == 91) {
            stopString = stopString.substring(1);
            maxInclusive = true;
        } else if (maxArray[0] != 43) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The min and max strings must either start with a (, [ or be - or +"));
            return;
        }
        try {
            removeList = this.getRange(key, keyRegion, context, Coder.stringToByteArrayWrapper(startString), Coder.stringToByteArrayWrapper(stopString), minInclusive, maxInclusive);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        int numRemoved = 0;
        for (ByteArrayWrapper entry : removeList) {
            DoubleWrapper oldVal = keyRegion.remove(entry);
            if (oldVal == null) continue;
            ++numRemoved;
        }
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), numRemoved));
    }

    private Collection<ByteArrayWrapper> getRange(ByteArrayWrapper key, Region<ByteArrayWrapper, DoubleWrapper> keyRegion, ExecutionHandlerContext context, ByteArrayWrapper start, ByteArrayWrapper stop, boolean startInclusive, boolean stopInclusive) throws Exception {
        Object[] params;
        Query query;
        if (start.equals("-") && stop.equals("+")) {
            return new ArrayList<ByteArrayWrapper>(keyRegion.keySet());
        }
        if (start.equals("+") || stop.equals("-")) {
            return null;
        }
        if (start.equals("-")) {
            query = stopInclusive ? this.getQuery(key, SortedSetQuery.ZRANGEBYLEXNINFI, context) : this.getQuery(key, SortedSetQuery.ZRANGEBYLEXNINF, context);
            params = new Object[]{stop, INFINITY_LIMIT};
        } else if (stop.equals("+")) {
            query = startInclusive ? this.getQuery(key, SortedSetQuery.ZRANGEBYLEXPINFI, context) : this.getQuery(key, SortedSetQuery.ZRANGEBYLEXPINF, context);
            params = new Object[]{start, INFINITY_LIMIT};
        } else {
            query = startInclusive ? (stopInclusive ? this.getQuery(key, SortedSetQuery.ZRANGEBYLEXSTISI, context) : this.getQuery(key, SortedSetQuery.ZRANGEBYLEXSTI, context)) : (stopInclusive ? this.getQuery(key, SortedSetQuery.ZRANGEBYLEXSI, context) : this.getQuery(key, SortedSetQuery.ZRANGEBYLEX, context));
            params = new Object[]{start, stop, INFINITY_LIMIT};
        }
        SelectResults results = (SelectResults)query.execute(params);
        return results.asList();
    }
}

