/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.util;

import java.io.FileNotFoundException;
import java.util.EmptyStackException;
import java.util.Stack;
import org.apache.geode.GemFireException;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.lang.SystemUtils;
import org.apache.geode.internal.util.IOUtils;
import org.apache.geode.management.internal.cli.util.JConsoleNotFoundException;
import org.apache.geode.management.internal.cli.util.VisualVmNotFoundException;

public class JdkTool {
    protected static final String JAVA_HOME = System.getProperty("java.home");

    public static String getJVisualVMPathname() {
        if (SystemUtils.isMacOSX()) {
            try {
                return IOUtils.verifyPathnameExists("/System/Library/Java/Support/VisualVM.bundle/Contents/Home/bin/jvisualvm");
            }
            catch (FileNotFoundException e) {
                throw new VisualVmNotFoundException("Java VisualVM could not be found on this system.\nPlease ensure that \"jvisualvm\" is installed in the JDK bin directory and the JDK bin directory is in the system PATH.", e);
            }
        }
        try {
            return JdkTool.getJdkToolPathname("jvisualvm" + JdkTool.getExecutableSuffix(), (GemFireException)new VisualVmNotFoundException("Java VisualVM could not be found on this system.\nPlease ensure that \"jvisualvm\" is installed in the JDK bin directory and the JDK bin directory is in the system PATH."));
        }
        catch (VisualVmNotFoundException e) {
            if (!SystemUtils.isJavaVersionAtLeast("1.6")) {
                throw new VisualVmNotFoundException("Java VisualVM was not bundled with the JDK until version 1.6.\nDownload and install Java VisualVM to the JDK bin directory separately.");
            }
            throw e;
        }
    }

    public static String getJConsolePathname() {
        return JdkTool.getJdkToolPathname("jconsole" + JdkTool.getExecutableSuffix(), (GemFireException)new JConsoleNotFoundException("JConsole could not be found.\nPlease ensure that JAVA_HOME is set to the JDK installation or the JDK bin directory is in the system PATH."));
    }

    protected static String getJdkToolPathname(String jdkToolExecutableName, GemFireException throwable) {
        Assert.assertNotNull(jdkToolExecutableName, "The JDK tool executable name cannot be null!", new Object[0]);
        Assert.assertNotNull(throwable, "The GemFireException cannot be null!", new Object[0]);
        Stack<String> pathnames = new Stack<String>();
        pathnames.push(jdkToolExecutableName);
        pathnames.push(IOUtils.appendToPath(System.getenv("JAVA_HOME"), "..", "bin", jdkToolExecutableName));
        pathnames.push(IOUtils.appendToPath(System.getenv("JAVA_HOME"), "bin", jdkToolExecutableName));
        pathnames.push(IOUtils.appendToPath(JAVA_HOME, "..", "bin", jdkToolExecutableName));
        pathnames.push(IOUtils.appendToPath(JAVA_HOME, "bin", jdkToolExecutableName));
        return JdkTool.getJdkToolPathname(pathnames, throwable);
    }

    protected static String getJdkToolPathname(Stack<String> pathnames, GemFireException throwable) {
        Assert.assertNotNull(pathnames, "The JDK tool executable pathnames cannot be null!", new Object[0]);
        Assert.assertNotNull(throwable, "The GemFireException cannot be null!", new Object[0]);
        try {
            return IOUtils.verifyPathnameExists(pathnames.pop());
        }
        catch (EmptyStackException ignore) {
            throw throwable;
        }
        catch (FileNotFoundException ignore) {
            return JdkTool.getJdkToolPathname(pathnames, throwable);
        }
    }

    protected static String getExecutableSuffix() {
        return SystemUtils.isWindows() ? ".exe" : "";
    }
}

