/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.shell;

import java.io.File;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliAroundInterceptor;
import org.apache.geode.management.internal.cli.CommandRequest;
import org.apache.geode.management.internal.cli.CommandResponse;
import org.apache.geode.management.internal.cli.CommandResponseBuilder;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.remote.CommandExecutor;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.FileResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.security.NotAuthorizedException;
import org.springframework.shell.core.ExecutionStrategy;
import org.springframework.shell.event.ParseResult;
import org.springframework.util.Assert;

public class GfshExecutionStrategy
implements ExecutionStrategy {
    private Class<?> mutex = GfshExecutionStrategy.class;
    private Gfsh shell;
    private LogWrapper logWrapper;

    GfshExecutionStrategy(Gfsh shell) {
        this.shell = shell;
        this.logWrapper = shell.getGfshFileLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(ParseResult parseResult) {
        Method method = parseResult.getMethod();
        if (this.isShellOnly(method)) {
            Assert.notNull((Object)parseResult, (String)"Parse result required");
            Class<?> clazz = this.mutex;
            synchronized (clazz) {
                Assert.isTrue((boolean)this.isReadyForCommands(), (String)"Not yet ready for commands");
                return new CommandExecutor().execute(parseResult);
            }
        }
        if (!GfshParseResult.class.isInstance(parseResult)) {
            throw new IllegalStateException("Configuration error!");
        }
        Result result = this.executeOnRemote((GfshParseResult)parseResult);
        return result;
    }

    private boolean isShellOnly(Method method) {
        CliMetaData cliMetadata = method.getAnnotation(CliMetaData.class);
        return cliMetadata != null && cliMetadata.shellOnly();
    }

    private String getInterceptor(Method method) {
        CliMetaData cliMetadata = method.getAnnotation(CliMetaData.class);
        return cliMetadata != null ? cliMetadata.interceptor() : "__NULL__";
    }

    public boolean isReadyForCommands() {
        return true;
    }

    public void terminate() {
        this.shell = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result executeOnRemote(GfshParseResult parseResult) {
        Result postExecResult;
        Result fileResult;
        Result commandResult = null;
        Object response = null;
        Path tempFile = null;
        if (!this.shell.isConnectedAndReady()) {
            this.shell.logWarning("Can't execute a remote command without connection. Use 'connect' first to connect.", null);
            this.logWrapper.info("Can't execute a remote command \"" + parseResult.getUserInput() + "\" without connection. Use 'connect' first to connect to GemFire.");
            return null;
        }
        List<File> fileData = null;
        CliAroundInterceptor interceptor = null;
        String interceptorClass = this.getInterceptor(parseResult.getMethod());
        if (!"__NULL__".equals(interceptorClass)) {
            try {
                interceptor = (CliAroundInterceptor)ClassPathLoader.getLatest().forName(interceptorClass).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                this.shell.logWarning("Configuration error", e);
            }
            if (interceptor == null) {
                return ResultBuilder.createBadConfigurationErrorResult("Interceptor Configuration Error");
            }
            Result preExecResult = interceptor.preExecution(parseResult);
            if (Result.Status.ERROR.equals((Object)preExecResult.getStatus())) {
                return preExecResult;
            }
            if (preExecResult instanceof FileResult) {
                fileResult = (FileResult)preExecResult;
                fileData = fileResult.getFiles();
            }
        }
        Map<String, String> env = this.shell.getEnv();
        try {
            response = this.shell.getOperationInvoker().processCommand(new CommandRequest(parseResult, env, fileData));
            if (response == null) {
                fileResult = ResultBuilder.createBadResponseErrorResult("Response was null for: " + parseResult.getUserInput());
                return fileResult;
            }
        }
        catch (NotAuthorizedException e) {
            CommandResult commandResult2 = ResultBuilder.createGemFireUnAuthorizedErrorResult("Unauthorized. Reason : " + e.getMessage());
            return commandResult2;
        }
        catch (Exception e) {
            this.shell.logSevere(e.getMessage(), e);
            e.printStackTrace();
            CommandResult commandResult3 = ResultBuilder.createBadResponseErrorResult("Error occurred while executing \"" + parseResult.getUserInput() + "\" on manager.");
            return commandResult3;
        }
        finally {
            env.clear();
        }
        if (response instanceof String) {
            String debugInfo;
            CommandResponse commandResponse = CommandResponseBuilder.prepareCommandResponseFromJson((String)response);
            if (commandResponse.isFailedToPersist()) {
                this.shell.printAsSevere("This change is not persisted in the cluster configuration, either because the cluster configuration service is not running or the command is operating on targeted members.");
                this.logWrapper.severe("This change is not persisted in the cluster configuration, either because the cluster configuration service is not running or the command is operating on targeted members.");
            }
            if (StringUtils.isNotBlank((String)(debugInfo = commandResponse.getDebugInfo()))) {
                debugInfo = debugInfo.replaceAll("\n\n\n", "\n");
                debugInfo = debugInfo.replaceAll("\n\n", "\n");
                debugInfo = debugInfo.replaceAll("\n", "\n[From Manager : " + commandResponse.getSender() + "]");
                debugInfo = "[From Manager : " + commandResponse.getSender() + "]" + debugInfo;
                this.logWrapper.info(debugInfo);
            }
            commandResult = ResultBuilder.fromJson((String)response);
        } else if (response instanceof Path) {
            tempFile = (Path)response;
        }
        if (interceptor != null && (postExecResult = interceptor.postExecution(parseResult, commandResult, tempFile)) != null) {
            if (Result.Status.ERROR.equals((Object)postExecResult.getStatus())) {
                if (this.logWrapper.infoEnabled()) {
                    this.logWrapper.info("Post execution Result :: " + postExecResult);
                }
            } else if (this.logWrapper.fineEnabled()) {
                this.logWrapper.fine("Post execution Result :: " + postExecResult);
            }
            commandResult = postExecResult;
        }
        if (commandResult == null) {
            commandResult = ResultBuilder.createGemFireErrorResult("Unable to build commandResult using the remote response.");
        }
        return commandResult;
    }
}

