/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.remote;

import java.lang.reflect.Method;
import org.apache.geode.SystemFailure;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.cli.exceptions.EntityNotFoundException;
import org.apache.geode.management.internal.cli.exceptions.UserErrorException;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.security.NotAuthorizedException;
import org.apache.logging.log4j.Logger;
import org.springframework.shell.event.ParseResult;
import org.springframework.util.ReflectionUtils;

public class CommandExecutor {
    private Logger logger = LogService.getLogger();

    public Object execute(ParseResult parseResult) {
        return this.execute(null, parseResult);
    }

    public Object execute(Object command, ParseResult parseResult) {
        try {
            Object result = this.invokeCommand(command, parseResult);
            if (result == null) {
                return ResultBuilder.createGemFireErrorResult("Command returned null: " + parseResult);
            }
            return result;
        }
        catch (NotAuthorizedException e) {
            this.logger.error("Not authorized to execute \"" + parseResult + "\".", (Throwable)e);
            throw e;
        }
        catch (IllegalArgumentException | IllegalStateException | UserErrorException e) {
            return ResultBuilder.createUserErrorResult(e.getMessage());
        }
        catch (EntityNotFoundException e) {
            if (e.isStatusOK()) {
                return ResultBuilder.createInfoResult("Skipping: " + e.getMessage());
            }
            return ResultBuilder.createUserErrorResult(e.getMessage());
        }
        catch (Exception e) {
            this.logger.error("Could not execute \"" + parseResult + "\".", (Throwable)e);
            return ResultBuilder.createGemFireErrorResult("Error while processing command <" + parseResult + "> Reason : " + e.getMessage());
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            throw t;
        }
    }

    protected Object invokeCommand(Object command, ParseResult parseResult) {
        if (command == null) {
            command = parseResult.getInstance();
        }
        return ReflectionUtils.invokeMethod((Method)parseResult.getMethod(), (Object)command, (Object[])parseResult.getArguments());
    }
}

