/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.configuration.domain.SharedConfigurationStatus;

public class FetchSharedConfigurationStatusFunction
implements InternalFunction {
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        InternalLocator locator = InternalLocator.getLocator();
        InternalCache cache = (InternalCache)context.getCache();
        DistributedMember member = cache.getDistributedSystem().getDistributedMember();
        SharedConfigurationStatus status = locator.getSharedConfigurationStatus().getStatus();
        String memberId = member.getName();
        if (StringUtils.isBlank((String)memberId)) {
            memberId = member.getId();
        }
        CliFunctionResult result = new CliFunctionResult(memberId, (Serializable[])new String[]{status.name()});
        context.getResultSender().lastResult(result);
    }

    @Override
    public String getId() {
        return FetchSharedConfigurationStatusFunction.class.getName();
    }
}

