/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import org.apache.geode.cache.Cache;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.domain.MemberResult;
import org.apache.geode.management.internal.cli.i18n.CliStrings;

public class CloseDurableClientFunction
implements InternalFunction {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(FunctionContext context) {
        String durableClientId = (String)context.getArguments();
        Cache cache = context.getCache();
        String memberNameOrId = CliUtil.getMemberNameOrId(cache.getDistributedSystem().getDistributedMember());
        MemberResult memberResult = new MemberResult(memberNameOrId);
        try {
            CacheClientNotifier cacheClientNotifier = CacheClientNotifier.getInstance();
            if (cacheClientNotifier != null) {
                CacheClientProxy ccp = cacheClientNotifier.getClientProxy(durableClientId);
                if (ccp != null) {
                    boolean isClosed = cacheClientNotifier.closeDurableClientProxy(durableClientId);
                    if (isClosed) {
                        memberResult.setSuccessMessage(CliStrings.format("Closed the durable client : \"{0}\".", (Object)durableClientId));
                    } else {
                        memberResult.setErrorMessage(CliStrings.format("No client found with client-id : {0}", (Object)durableClientId));
                    }
                } else {
                    memberResult.setErrorMessage(CliStrings.format("No client found with client-id : {0}", (Object)durableClientId));
                }
            } else {
                memberResult.setErrorMessage("No client found on this server");
            }
        }
        catch (Exception e) {
            memberResult.setExceptionMessage(e.getMessage());
        }
        finally {
            context.getResultSender().lastResult(memberResult);
        }
    }

    @Override
    public String getId() {
        return CloseDurableClientFunction.class.getName();
    }
}

