/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.converters;

import java.util.Arrays;
import java.util.List;
import org.apache.geode.cache.ExpirationAction;
import org.springframework.shell.core.Completion;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.MethodTarget;

public class ExpirationActionConverter
implements Converter<ExpirationAction> {
    private static ExpirationAction[] actions = new ExpirationAction[]{ExpirationAction.INVALIDATE, ExpirationAction.LOCAL_INVALIDATE, ExpirationAction.DESTROY, ExpirationAction.LOCAL_DESTROY};

    public boolean supports(Class<?> type, String optionContext) {
        return type.isAssignableFrom(ExpirationAction.class);
    }

    public ExpirationAction convertFromText(String value, Class<?> targetType, String optionContext) {
        String enumValue = value.replace('-', '_');
        return Arrays.stream(actions).filter(x -> x.toString().equalsIgnoreCase(enumValue)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Expiration action %s is not valid.", value)));
    }

    public boolean getAllPossibleValues(List<Completion> completions, Class<?> targetType, String existingData, String optionContext, MethodTarget target) {
        Arrays.stream(actions).forEach(x -> completions.add(new Completion(x.toString())));
        return true;
    }
}

