/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands.lifecycle;

import java.io.IOException;
import org.apache.geode.distributed.AbstractLauncher;
import org.apache.geode.distributed.ServerLauncher;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.management.MemberMXBean;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.shell.MXBeanProvider;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class StatusServerCommand
extends InternalGfshCommand {
    @CliCommand(value={"status server"}, help="Display the status of a Geode Cache Server.")
    @CliMetaData(shellOnly=true, relatedTopic={"Server", "Lifecycle"})
    public Result statusServer(@CliOption(key={"name"}, optionContext="geode.converter.member.idOrName:disable-string-converter", help="Member name or ID of the Cache Server in the Geode cluster.") String member, @CliOption(key={"pid"}, help="Process ID (PID) of the running Geode Cache Server. Deprecated: Since Geode 1.2. Requires the JDK tools.jar which is not included on the classpath by default. Use --dir instead.") Integer pid, @CliOption(key={"dir"}, help="Working directory in which the Cache Server is running. The default is the current directory.") String workingDirectory) throws IOException {
        if (StringUtils.isNotBlank((String)member)) {
            if (this.isConnectedAndReady()) {
                MemberMXBean serverProxy = MXBeanProvider.getMemberMXBean(member);
                if (serverProxy != null) {
                    return ResultBuilder.createInfoResult(ServerLauncher.ServerState.fromJson(serverProxy.status()).toString());
                }
                return ResultBuilder.createUserErrorResult(CliStrings.format("No Geode Cache Server with member name or ID {0} could be found.", (Object)member));
            }
            return ResultBuilder.createUserErrorResult(CliStrings.format("Gfsh must be connected in order to get the status of a {0} by member name or ID.", (Object)"Cache Server"));
        }
        ServerLauncher serverLauncher = new ServerLauncher.Builder().setCommand(ServerLauncher.Command.STATUS).setDebug(this.isDebugging()).setDisableDefaultServer(true).setPid(pid).setWorkingDirectory(workingDirectory).build();
        ServerLauncher.ServerState status = serverLauncher.status();
        if (status.getStatus().equals((Object)AbstractLauncher.Status.NOT_RESPONDING) || status.getStatus().equals((Object)AbstractLauncher.Status.STOPPED)) {
            return ResultBuilder.createGemFireErrorResult(status.toString());
        }
        return ResultBuilder.createInfoResult(status.toString());
    }
}

