/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Set;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.deadlock.DeadlockDetector;
import org.apache.geode.distributed.internal.deadlock.Dependency;
import org.apache.geode.distributed.internal.deadlock.DependencyGraph;
import org.apache.geode.distributed.internal.deadlock.GemFireDeadlockDetector;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.InfoResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ShowDeadlockCommand
extends InternalGfshCommand {
    @CliCommand(value={"show dead-locks"}, help="Display any deadlocks in the Geode distributed system.")
    @CliMetaData(relatedTopic={"Debug-Utility"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result showDeadlock(@CliOption(key={"file"}, help="Name of the file to which dependencies between members will be written.", mandatory=true) String filename) {
        CommandResult result;
        try {
            if (!filename.endsWith(".txt")) {
                return ResultBuilder.createUserErrorResult(CliStrings.format("Invalid file type, the file extension must be \"{0}\"", (Object)".txt"));
            }
            Set<DistributedMember> allMembers = this.getAllMembers();
            GemFireDeadlockDetector gfeDeadLockDetector = new GemFireDeadlockDetector(allMembers);
            DependencyGraph dependencyGraph = gfeDeadLockDetector.find();
            Collection<Dependency> deadlock = dependencyGraph.findCycle();
            DependencyGraph deepest = null;
            if (deadlock == null && (deepest = dependencyGraph.findLongestCallChain()) != null) {
                deadlock = deepest.getEdges();
            }
            Set dependencies = (Set)dependencyGraph.getEdges();
            InfoResultData resultData = ResultBuilder.createInfoResultData();
            if (deadlock != null) {
                if (deepest != null) {
                    resultData.addLine("No deadlock was detected.  Here is the deepest call chain that could be found");
                } else {
                    resultData.addLine("Deadlock detected.");
                }
                resultData.addLine(DeadlockDetector.prettyFormat(deadlock));
            } else {
                resultData.addLine("No deadlock was detected.");
            }
            resultData.addAsFile(filename, DeadlockDetector.prettyFormat(dependencies), MessageFormat.format("Please view the dependencies between the members in file : {0}", filename), false);
            result = ResultBuilder.buildResult(resultData);
        }
        catch (Exception e) {
            result = ResultBuilder.createGemFireErrorResult("Error : " + e.getMessage());
        }
        return result;
    }
}

