/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Set;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.ListDeployedFunction;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ListDeployedCommand
extends InternalGfshCommand {
    private final ListDeployedFunction listDeployedFunction = new ListDeployedFunction();

    @CliCommand(value={"list deployed"}, help="Display a list of JARs that were deployed to members using the \"deploy\" command.")
    @CliMetaData(relatedTopic={"Configuration"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result listDeployed(@CliOption(key={"group", "groups"}, help="Group(s) of members for which deployed JARs will be displayed.  If not specified, JARs for all members will be displayed.") String[] group) {
        try {
            TabularResultData tabularData = ResultBuilder.createTabularResultData();
            boolean accumulatedData = false;
            Set<DistributedMember> targetMembers = this.findMembers(group, null);
            if (targetMembers.isEmpty()) {
                return ResultBuilder.createUserErrorResult("No Members Found");
            }
            ResultCollector<?, ?> rc = CliUtil.executeFunction(this.listDeployedFunction, null, targetMembers);
            List<CliFunctionResult> results = CliFunctionResult.cleanResults((List)rc.getResult());
            for (CliFunctionResult result : results) {
                if (result.getThrowable() != null) {
                    tabularData.accumulate("Member", result.getMemberIdOrName());
                    tabularData.accumulate("JAR", "");
                    tabularData.accumulate("JAR Location", "ERROR: " + result.getThrowable().getClass().getName() + ": " + result.getThrowable().getMessage());
                    accumulatedData = true;
                    tabularData.setStatus(Result.Status.ERROR);
                    continue;
                }
                String[] strings = (String[])result.getSerializables();
                for (int i = 0; i < strings.length; i += 2) {
                    tabularData.accumulate("Member", result.getMemberIdOrName());
                    tabularData.accumulate("JAR", strings[i]);
                    tabularData.accumulate("JAR Location", strings[i + 1]);
                    accumulatedData = true;
                }
            }
            if (!accumulatedData) {
                return ResultBuilder.createInfoResult("No JAR Files Found");
            }
            return ResultBuilder.buildResult(tabularData);
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            return ResultBuilder.createGemFireErrorResult("Exception while attempting to list deployed: " + th.getClass().getName() + ": " + th.getMessage());
        }
    }
}

