/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.domain.AsyncEventQueueDetails;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.ListAsyncEventQueuesFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;

public class ListAsyncEventQueuesCommand
extends InternalGfshCommand {
    @CliCommand(value={"list async-event-queues"}, help="Display the Async Event Queues for all members.")
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result listAsyncEventQueues() {
        try {
            TabularResultData tabularData = ResultBuilder.createTabularResultData();
            boolean accumulatedData = false;
            Set<DistributedMember> targetMembers = this.getAllNormalMembers();
            if (targetMembers.isEmpty()) {
                return ResultBuilder.createUserErrorResult("No Members Found");
            }
            ResultCollector<?, ?> rc = CliUtil.executeFunction(new ListAsyncEventQueuesFunction(), new Object[0], targetMembers);
            List<CliFunctionResult> results = CliFunctionResult.cleanResults((List)rc.getResult());
            for (CliFunctionResult result : results) {
                AsyncEventQueueDetails[] details;
                if (result.getThrowable() != null) {
                    tabularData.accumulate("Member", result.getMemberIdOrName());
                    tabularData.accumulate("Result", "ERROR: " + result.getThrowable().getClass().getName() + ": " + result.getThrowable().getMessage());
                    accumulatedData = true;
                    tabularData.setStatus(Result.Status.ERROR);
                    continue;
                }
                for (AsyncEventQueueDetails detail : details = (AsyncEventQueueDetails[])result.getSerializables()) {
                    tabularData.accumulate("Member", result.getMemberIdOrName());
                    tabularData.accumulate("ID", detail.getId());
                    tabularData.accumulate("Batch Size", detail.getBatchSize());
                    tabularData.accumulate("Persistent", detail.isPersistent());
                    tabularData.accumulate("Disk Store", detail.getDiskStoreName());
                    tabularData.accumulate("Max Memory", detail.getMaxQueueMemory());
                    Properties listenerProperties = detail.getListenerProperties();
                    if (listenerProperties == null || listenerProperties.size() == 0) {
                        tabularData.accumulate("Listener", detail.getListener());
                    } else {
                        StringBuilder propsStringBuilder = new StringBuilder();
                        propsStringBuilder.append('(');
                        boolean firstProperty = true;
                        for (Map.Entry<Object, Object> property : listenerProperties.entrySet()) {
                            if (!firstProperty) {
                                propsStringBuilder.append(',');
                            } else {
                                firstProperty = false;
                            }
                            propsStringBuilder.append(property.getKey()).append('=').append(property.getValue());
                        }
                        propsStringBuilder.append(')');
                        tabularData.accumulate("Listener", detail.getListener() + propsStringBuilder.toString());
                    }
                    accumulatedData = true;
                }
            }
            if (!accumulatedData) {
                return ResultBuilder.createInfoResult("No Async Event Queues Found");
            }
            return ResultBuilder.buildResult(tabularData);
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            return ResultBuilder.createGemFireErrorResult(CliStrings.format("An error occurred while collecting queue information: \"{0}\"", new Object[]{th.getMessage()}));
        }
    }
}

