/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.ExportConfigFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.InfoResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ExportConfigCommand
extends InternalGfshCommand {
    private final ExportConfigFunction exportConfigFunction = new ExportConfigFunction();

    @CliCommand(value={"export config"}, help="Export configuration properties for a member or members.")
    @CliMetaData(interceptor="org.apache.geode.management.internal.cli.commands.ExportConfigCommand$Interceptor", relatedTopic={"Configuration"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result exportConfig(@CliOption(key={"member", "members"}, optionContext="geode.converter.all.member.idOrName:disable-string-converter", help="Name/Id of the member(s) whose configuration will be exported.") String[] member, @CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Group(s) of members whose configuration will be exported.") String[] group, @CliOption(key={"dir"}, help="Directory to which the exported configuration files will be written.") String dir) {
        InfoResultData infoData = ResultBuilder.createInfoResultData();
        Set<DistributedMember> targetMembers = this.findMembers(group, member);
        if (targetMembers.isEmpty()) {
            return ResultBuilder.createUserErrorResult("No Members Found");
        }
        ResultCollector<?, ?> rc = CliUtil.executeFunction(this.exportConfigFunction, null, targetMembers);
        List<CliFunctionResult> results = CliFunctionResult.cleanResults((List)rc.getResult());
        for (CliFunctionResult result : results) {
            if (result.getThrowable() != null) {
                infoData.addLine(CliStrings.format("Exception while exporting config: {0}", result.getMemberIdOrName(), result.getThrowable()));
                continue;
            }
            if (!result.isSuccessful()) continue;
            String cacheFileName = result.getMemberIdOrName() + "-cache.xml";
            String propsFileName = result.getMemberIdOrName() + "-gf.properties";
            String[] fileContent = (String[])result.getSerializables();
            infoData.addAsFile(cacheFileName, fileContent[0], "Downloading Cache XML file: {0}", false);
            infoData.addAsFile(propsFileName, fileContent[1], "Downloading properties file: {0}", false);
        }
        return ResultBuilder.buildResult(infoData);
    }

    public static class Interceptor
    extends AbstractCliAroundInterceptor {
        private String saveDirString;

        @Override
        public Result preExecution(GfshParseResult parseResult) {
            String dir = parseResult.getParamValueAsString("dir");
            if (StringUtils.isBlank((String)dir)) {
                this.saveDirString = new File(".").getAbsolutePath();
                return ResultBuilder.createInfoResult("OK");
            }
            File saveDirFile = new File(dir.trim());
            if (!saveDirFile.exists() && !saveDirFile.mkdirs()) {
                return ResultBuilder.createGemFireErrorResult(CliStrings.format("Directory {0} could not be created", (Object)dir));
            }
            if (!saveDirFile.isDirectory()) {
                return ResultBuilder.createGemFireErrorResult(CliStrings.format("{0} is not a directory", (Object)dir));
            }
            try {
                if (!saveDirFile.canWrite()) {
                    return ResultBuilder.createGemFireErrorResult(CliStrings.format("{0} is not writeable", (Object)saveDirFile.getCanonicalPath()));
                }
            }
            catch (IOException ioex) {
                return ResultBuilder.createGemFireErrorResult(CliStrings.format("{0} is not writeable", (Object)saveDirFile.getName()));
            }
            this.saveDirString = saveDirFile.getAbsolutePath();
            return ResultBuilder.createInfoResult("OK");
        }

        @Override
        public Result postExecution(GfshParseResult parseResult, Result commandResult, Path tempFile) {
            if (commandResult.hasIncomingFiles()) {
                try {
                    commandResult.saveIncomingFiles(this.saveDirString);
                }
                catch (IOException ioex) {
                    Gfsh.getCurrentInstance().logSevere("Unable to export config", ioex);
                }
            }
            return commandResult;
        }
    }
}

