/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Set;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.cli.CliUtil;

class DiskStoreCommandsUtils {
    DiskStoreCommandsUtils() {
    }

    static void configureLogging(List<String> commandList) {
        URL configUrl = LogService.class.getResource("/log4j2-cli.xml");
        String configFilePropertyValue = configUrl.toString();
        commandList.add("-Dlog4j.configurationFile=" + configFilePropertyValue);
    }

    static String validatedDirectories(String[] diskDirs) {
        String invalidDirectories = null;
        StringBuilder builder = null;
        for (String diskDirPath : diskDirs) {
            File diskDir = new File(diskDirPath);
            if (diskDir.exists()) continue;
            if (builder == null) {
                builder = new StringBuilder();
            } else if (builder.length() != 0) {
                builder.append(", ");
            }
            builder.append(diskDirPath);
        }
        if (builder != null) {
            invalidDirectories = builder.toString();
        }
        return invalidDirectories;
    }

    static Set<DistributedMember> getNormalMembers(InternalCache cache) {
        return CliUtil.getAllNormalMembers(cache);
    }
}

