/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics;

import java.io.File;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.geode.CancelCriterion;
import org.apache.geode.CancelException;
import org.apache.geode.Statistics;
import org.apache.geode.SystemFailure;
import org.apache.geode.internal.NanoTimer;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.io.MainWithChildrenRollingFileHandler;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LoggingThreadGroup;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.statistics.CallbackSampler;
import org.apache.geode.internal.statistics.SampleCollector;
import org.apache.geode.internal.statistics.StatArchiveHandlerConfig;
import org.apache.geode.internal.statistics.StatSamplerStats;
import org.apache.geode.internal.statistics.StatisticsImpl;
import org.apache.geode.internal.statistics.StatisticsManager;
import org.apache.geode.internal.statistics.StatisticsSampler;
import org.apache.geode.internal.statistics.VMStatsContract;
import org.apache.geode.internal.statistics.VMStatsContractFactory;
import org.apache.geode.internal.statistics.platform.OsStatisticsFactory;
import org.apache.geode.internal.util.concurrent.StoppableCountDownLatch;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public abstract class HostStatSampler
implements Runnable,
StatisticsSampler,
StatArchiveHandlerConfig {
    private static final Logger logger = LogService.getLogger();
    public static final String TEST_FILE_SIZE_LIMIT_IN_KB_PROPERTY = "gemfire.stats.test.fileSizeLimitInKB";
    public static final String OS_STATS_DISABLED_PROPERTY = "osStatsDisabled";
    protected static final String INITIALIZATION_TIMEOUT_PROPERTY = "gemfire.statSamplerInitializationTimeout";
    protected static final int INITIALIZATION_TIMEOUT_DEFAULT = 30000;
    protected static final long INITIALIZATION_TIMEOUT_MILLIS = Long.getLong("gemfire.statSamplerInitializationTimeout", 30000L);
    private static final long STAT_SAMPLER_DELAY_THRESHOLD = Long.getLong("gemfire.statSamplerDelayThreshold", 3000L);
    private static final long STAT_SAMPLER_DELAY_THRESHOLD_NANOS = NanoTimer.millisToNanos(STAT_SAMPLER_DELAY_THRESHOLD);
    private static final int MIN_MS_SLEEP = 1;
    private static final int WAIT_FOR_SLEEP_INTERVAL = 10;
    private Thread statThread = null;
    private volatile boolean stopRequested = false;
    private final boolean osStatsDisabled = Boolean.getBoolean("osStatsDisabled");
    private final boolean fileSizeLimitInKB;
    private final StatSamplerStats samplerStats;
    private VMStatsContract vmStats;
    private SampleCollector sampleCollector;
    private final StoppableCountDownLatch statSamplerInitializedLatch;
    private final CancelCriterion stopper;
    private final CallbackSampler callbackSampler;
    private final NanoTimer timer;

    protected HostStatSampler(CancelCriterion stopper, StatSamplerStats samplerStats) {
        this(stopper, samplerStats, new NanoTimer());
    }

    protected HostStatSampler(CancelCriterion stopper, StatSamplerStats samplerStats, NanoTimer timer) {
        this.stopper = stopper;
        this.statSamplerInitializedLatch = new StoppableCountDownLatch(this.stopper, 1);
        this.samplerStats = samplerStats;
        this.fileSizeLimitInKB = Boolean.getBoolean(TEST_FILE_SIZE_LIMIT_IN_KB_PROPERTY);
        this.callbackSampler = new CallbackSampler(stopper, samplerStats);
        this.timer = timer;
    }

    public StatSamplerStats getStatSamplerStats() {
        return this.samplerStats;
    }

    @Override
    public int getStatisticsModCount() {
        return this.getStatisticsManager().getStatListModCount();
    }

    @Override
    public Statistics[] getStatistics() {
        return this.getStatisticsManager().getStatistics();
    }

    @Override
    public long getSystemId() {
        return this.getStatisticsManager().getId();
    }

    @Override
    public long getSystemStartTime() {
        return this.getStatisticsManager().getStartTime();
    }

    @Override
    public String getSystemDirectoryPath() {
        try {
            return SocketCreator.getHostName(SocketCreator.getLocalHost());
        }
        catch (UnknownHostException ignore) {
            return "";
        }
    }

    @Override
    public boolean waitForSample(long timeout) throws InterruptedException {
        long endTime = System.currentTimeMillis() + timeout;
        int startSampleCount = this.samplerStats.getSampleCount();
        while (System.currentTimeMillis() < endTime && this.samplerStats.getSampleCount() <= startSampleCount) {
            Thread.sleep(10L);
        }
        return this.samplerStats.getSampleCount() > startSampleCount;
    }

    @Override
    public SampleCollector waitForSampleCollector(long timeout) throws InterruptedException {
        long endTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < endTime && this.sampleCollector == null || !this.sampleCollector.isInitialized()) {
            Thread.sleep(10L);
        }
        return this.sampleCollector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean isDebugEnabled_STATISTICS = logger.isTraceEnabled(LogMarker.STATISTICS_VERBOSE);
        if (isDebugEnabled_STATISTICS) {
            logger.trace(LogMarker.STATISTICS_VERBOSE, "HostStatSampler started");
        }
        boolean latchCountedDown = false;
        try {
            this.initSpecialStats();
            this.sampleCollector = new SampleCollector(this);
            HostStatSampler hostStatSampler = this;
            this.sampleCollector.initialize(this, hostStatSampler.timer.getTime(), new MainWithChildrenRollingFileHandler());
            this.statSamplerInitializedLatch.countDown();
            latchCountedDown = true;
            this.timer.reset();
            long nanosLastTimeStamp = this.timer.getLastResetTime() - this.getNanoRate();
            while (!this.stopRequested()) {
                SystemFailure.checkFailure();
                if (Thread.currentThread().isInterrupted()) {
                    break;
                }
                long nanosBeforeSleep = this.timer.getLastResetTime();
                long nanosToDelay = nanosLastTimeStamp + this.getNanoRate();
                this.delay(nanosToDelay);
                nanosLastTimeStamp = this.timer.getLastResetTime();
                if (!this.stopRequested() && this.isSamplingEnabled()) {
                    long nanosTimeStamp = this.timer.getLastResetTime();
                    long nanosElapsedSleeping = nanosTimeStamp - nanosBeforeSleep;
                    this.checkElapsedSleepTime(nanosElapsedSleeping);
                    if (this.stopRequested()) {
                        break;
                    }
                    this.sampleSpecialStats(false);
                    if (this.stopRequested()) {
                        break;
                    }
                    this.checkListeners();
                    if (this.stopRequested()) {
                        break;
                    }
                    this.sampleCollector.sample(nanosTimeStamp);
                    long nanosSpentWorking = this.timer.reset();
                    this.accountForTimeSpentWorking(nanosSpentWorking, nanosElapsedSleeping);
                    continue;
                }
                if (this.stopRequested() || this.isSamplingEnabled()) continue;
                this.sampleSpecialStats(true);
            }
        }
        catch (InterruptedException | CancelException nanosLastTimeStamp) {
        }
        catch (RuntimeException ex) {
            logger.fatal(LogMarker.STATISTICS_MARKER, ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error ex) {
            SystemFailure.checkFailure();
            logger.fatal(LogMarker.STATISTICS_MARKER, ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        finally {
            try {
                this.closeSpecialStats();
                if (this.sampleCollector != null) {
                    this.sampleCollector.close();
                }
            }
            finally {
                if (!latchCountedDown) {
                    this.statSamplerInitializedLatch.countDown();
                }
            }
            if (isDebugEnabled_STATISTICS) {
                logger.trace(LogMarker.STATISTICS_VERBOSE, "HostStatSampler stopped");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Class<HostStatSampler> clazz = HostStatSampler.class;
        synchronized (HostStatSampler.class) {
            if (this.statThread != null) {
                try {
                    int msToWait = this.getSampleRate() + 100;
                    this.statThread.join(msToWait);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                if (this.statThread.isAlive()) {
                    throw new IllegalStateException(LocalizedStrings.HostStatSampler_STATISTICS_SAMPLING_THREAD_IS_ALREADY_RUNNING_INDICATING_AN_INCOMPLETE_SHUTDOWN_OF_A_PREVIOUS_CACHE.toLocalizedString());
                }
            }
            LoggingThreadGroup group = LoggingThreadGroup.createThreadGroup("StatSampler Threads");
            this.callbackSampler.start(this.getStatisticsManager(), group, this.getSampleRate(), TimeUnit.MILLISECONDS);
            this.statThread = new Thread((ThreadGroup)group, this);
            this.statThread.setName(this.statThread.getName() + " StatSampler");
            this.statThread.setPriority(10);
            this.statThread.setDaemon(true);
            this.statThread.start();
            try {
                this.waitForInitialization(INITIALIZATION_TIMEOUT_MILLIS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return;
        }
    }

    public void stop() {
        this.stop(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void stop(boolean interruptIfAlive) {
        Class<HostStatSampler> clazz = HostStatSampler.class;
        // MONITORENTER : org.apache.geode.internal.statistics.HostStatSampler.class
        this.callbackSampler.stop();
        if (this.statThread == null) {
            // MONITOREXIT : clazz
            return;
        }
        this.stopRequested = true;
        HostStatSampler hostStatSampler = this;
        // MONITORENTER : hostStatSampler
        this.notifyAll();
        // MONITOREXIT : hostStatSampler
        try {
            this.statThread.join(5000L);
            return;
        }
        catch (InterruptedException ignore) {
            try {
                this.statThread.join(2000L);
                Thread.currentThread().interrupt();
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            finally {
                Thread.currentThread().interrupt();
            }
        }
        finally {
            if (this.statThread.isAlive()) {
                if (interruptIfAlive) {
                    this.statThread.interrupt();
                    this.stop(false);
                } else {
                    logger.warn(LogMarker.STATISTICS_MARKER, (Message)LocalizedMessage.create(LocalizedStrings.HostStatSampler_HOSTSTATSAMPLER_THREAD_COULD_NOT_BE_STOPPED));
                }
            } else {
                this.stopRequested = false;
                this.statThread = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAlive() {
        Class<HostStatSampler> clazz = HostStatSampler.class;
        synchronized (HostStatSampler.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.statThread != null && this.statThread.isAlive();
        }
    }

    public void waitForInitialization() throws InterruptedException {
        this.statSamplerInitializedLatch.await();
    }

    public boolean waitForInitialization(long ms) throws InterruptedException {
        return this.awaitInitialization(ms, TimeUnit.MILLISECONDS);
    }

    public boolean awaitInitialization(long timeout, TimeUnit unit) throws InterruptedException {
        return this.statSamplerInitializedLatch.await(timeout, unit);
    }

    public void changeArchive(File newFile) {
        HostStatSampler hostStatSampler = this;
        this.sampleCollector.changeArchive(newFile, hostStatSampler.timer.getTime());
    }

    public VMStatsContract getVMStats() {
        return this.vmStats;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append("@").append(System.identityHashCode(this));
        return sb.toString();
    }

    protected abstract void checkListeners();

    protected abstract int getSampleRate();

    public abstract boolean isSamplingEnabled();

    protected abstract StatisticsManager getStatisticsManager();

    protected OsStatisticsFactory getOsStatisticsFactory() {
        return null;
    }

    protected void initProcessStats(long id) {
    }

    protected void sampleProcessStats(boolean prepareOnly) {
    }

    protected void closeProcessStats() {
    }

    protected long getSpecialStatsId() {
        return this.getStatisticsManager().getId();
    }

    protected boolean fileSizeLimitInKB() {
        return this.fileSizeLimitInKB;
    }

    protected boolean osStatsDisabled() {
        return this.osStatsDisabled;
    }

    protected boolean stopRequested() {
        return this.stopper.isCancelInProgress() || this.stopRequested;
    }

    public SampleCollector getSampleCollector() {
        return this.sampleCollector;
    }

    private synchronized void initSpecialStats() {
        long id = this.getSpecialStatsId();
        this.vmStats = VMStatsContractFactory.create(this.getStatisticsManager(), id);
        this.initProcessStats(id);
    }

    private synchronized void closeSpecialStats() {
        if (this.vmStats != null) {
            this.vmStats.close();
        }
        this.closeProcessStats();
    }

    private void accountForTimeSpentWorking(long nanosSpentWorking, long nanosSpentSleeping) {
        this.samplerStats.tookSample(nanosSpentWorking, this.getStatisticsManager().getStatisticsCount(), nanosSpentSleeping);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delay(long nanosToDelay) throws InterruptedException {
        this.timer.reset();
        long now = this.timer.getLastResetTime();
        long remainingNanos = nanosToDelay - now;
        if (remainingNanos <= 0L) {
            remainingNanos = NanoTimer.millisToNanos(1L);
        }
        while (remainingNanos > 0L && !this.stopRequested()) {
            long ms = NanoTimer.nanosToMillis(remainingNanos);
            if (ms <= 0L) {
                Thread.yield();
            } else {
                if (ms > 1L) {
                    --ms;
                }
                HostStatSampler hostStatSampler = this;
                synchronized (hostStatSampler) {
                    if (this.stopRequested()) {
                        return;
                    }
                    this.wait(ms);
                }
            }
            this.timer.reset();
            now = this.timer.getLastResetTime();
            remainingNanos = nanosToDelay - now;
        }
    }

    private long getNanoRate() {
        return NanoTimer.millisToNanos(this.getSampleRate());
    }

    private void sampleSpecialStats(boolean prepareOnly) {
        List<Statistics> statsList = this.getStatisticsManager().getStatsList();
        for (Statistics s : statsList) {
            if (this.stopRequested()) {
                return;
            }
            if (!(s instanceof StatisticsImpl)) continue;
            ((StatisticsImpl)s).prepareForSample();
        }
        if (!prepareOnly && this.vmStats != null) {
            if (this.stopRequested()) {
                return;
            }
            this.vmStats.refresh();
        }
        this.sampleProcessStats(prepareOnly);
    }

    private void checkElapsedSleepTime(long elapsedSleepTime) {
        long wakeupDelay;
        if (STAT_SAMPLER_DELAY_THRESHOLD > 0L && (wakeupDelay = elapsedSleepTime - this.getNanoRate()) > STAT_SAMPLER_DELAY_THRESHOLD_NANOS) {
            this.samplerStats.incJvmPauses();
            logger.warn(LogMarker.STATISTICS_MARKER, (Message)LocalizedMessage.create(LocalizedStrings.HostStatSampler_STATISTICS_SAMPLING_THREAD_DETECTED_A_WAKEUP_DELAY_OF_0_MS_INDICATING_A_POSSIBLE_RESOURCE_ISSUE, NanoTimer.nanosToMillis(wakeupDelay)));
        }
    }
}

