/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.size;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.util.ObjectSizer;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.cache.PlaceHolderDiskRegion;
import org.apache.geode.internal.size.ObjectGraphSizer;
import org.apache.logging.log4j.Logger;

public class ReflectionObjectSizer
implements ObjectSizer,
Serializable {
    private static final ReflectionObjectSizer INSTANCE = new ReflectionObjectSizer();
    private static final ObjectGraphSizer.ObjectFilter FILTER = new ObjectGraphSizer.ObjectFilter(){

        @Override
        public boolean accept(Object parent, Object object) {
            return !(object instanceof Region) && !(object instanceof Cache) && !(object instanceof PlaceHolderDiskRegion) && !(object instanceof InternalDistributedSystem) && !(object instanceof ClassLoader) && !(object instanceof Logger);
        }
    };

    @Override
    public int sizeof(Object o) {
        try {
            return (int)ObjectGraphSizer.size(o, FILTER, false);
        }
        catch (IllegalArgumentException e) {
            throw new InternalGemFireError(e);
        }
        catch (IllegalAccessException e) {
            throw new InternalGemFireError(e);
        }
    }

    public static ReflectionObjectSizer getInstance() {
        return INSTANCE;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
    }

    private Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }

    private ReflectionObjectSizer() {
    }
}

