/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.security;

import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.internal.ClassLoadUtil;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.geode.security.PostProcessor;
import org.apache.geode.security.SecurityManager;

public class CallbackInstantiator {
    public static <T> T getObjectOfTypeFromClassName(String className, Class<T> expectedClazz) {
        Class actualClass;
        try {
            actualClass = ClassLoadUtil.classFromName(className);
        }
        catch (Exception e) {
            throw new GemFireSecurityException("Instance could not be obtained, " + e, e);
        }
        if (!expectedClazz.isAssignableFrom(actualClass)) {
            throw new GemFireSecurityException("Instance could not be obtained. Expecting a " + expectedClazz.getName() + " class.");
        }
        try {
            return actualClass.newInstance();
        }
        catch (Exception e) {
            throw new GemFireSecurityException("Instance could not be obtained. Error instantiating " + actualClass.getName(), e);
        }
    }

    public static SecurityManager getSecurityManager(Properties properties) {
        String securityManagerConfig = properties.getProperty("security-manager");
        if (StringUtils.isBlank((String)securityManagerConfig)) {
            return null;
        }
        SecurityManager securityManager = CallbackInstantiator.getObjectOfTypeFromClassName(securityManagerConfig, SecurityManager.class);
        securityManager.init(properties);
        return securityManager;
    }

    public static PostProcessor getPostProcessor(Properties properties) {
        String postProcessorConfig = properties.getProperty("security-post-processor");
        if (StringUtils.isBlank((String)postProcessorConfig)) {
            return null;
        }
        PostProcessor postProcessor = CallbackInstantiator.getObjectOfTypeFromClassName(postProcessorConfig, PostProcessor.class);
        postProcessor.init(properties);
        return postProcessor;
    }

    private static <T> T getObjectOfTypeFromFactoryMethod(String factoryMethodName) {
        Object actualObject;
        try {
            Method factoryMethod = ClassLoadUtil.methodFromName(factoryMethodName);
            actualObject = factoryMethod.invoke(null, (Object[])null);
        }
        catch (Exception e) {
            throw new GemFireSecurityException("Instance could not be obtained from " + factoryMethodName, e);
        }
        if (actualObject == null) {
            throw new GemFireSecurityException("Instance could not be obtained from " + factoryMethodName);
        }
        return (T)actualObject;
    }

    public static <T> T getObjectOfType(String classOrMethod, Class<T> expectedClazz) {
        T object;
        try {
            object = CallbackInstantiator.getObjectOfTypeFromClassName(classOrMethod, expectedClazz);
        }
        catch (Exception ignore) {
            object = CallbackInstantiator.getObjectOfTypeFromFactoryMethod(classOrMethod);
        }
        return object;
    }
}

