/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.offheap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.offheap.MemoryAllocatorImpl;
import org.apache.geode.internal.offheap.RefCountChangeInfo;

class ReferenceCountHelperImpl {
    private boolean trackRefCounts;
    private boolean trackFreedRefCounts;
    private ConcurrentMap<Long, List<RefCountChangeInfo>> stacktraces;
    private ConcurrentMap<Long, List<RefCountChangeInfo>> freedStacktraces;
    private ThreadLocal<Object> refCountOwner;
    private ThreadLocal<AtomicInteger> refCountReenterCount;
    private static final Object SKIP_REF_COUNT_TRACKING = new Object();
    private static final List<RefCountChangeInfo> LOCKED = Collections.emptyList();

    ReferenceCountHelperImpl(boolean trackRefCounts, boolean trackFreedRefCounts) {
        this.trackRefCounts = trackRefCounts;
        this.trackFreedRefCounts = trackFreedRefCounts;
        if (trackRefCounts) {
            this.stacktraces = new ConcurrentHashMap<Long, List<RefCountChangeInfo>>();
            this.freedStacktraces = trackFreedRefCounts ? new ConcurrentHashMap<Long, List<RefCountChangeInfo>>() : null;
            this.refCountOwner = new ThreadLocal();
            this.refCountReenterCount = new ThreadLocal();
        } else {
            this.stacktraces = null;
            this.freedStacktraces = null;
            this.refCountOwner = null;
            this.refCountReenterCount = null;
        }
    }

    public boolean trackReferenceCounts() {
        return this.trackRefCounts;
    }

    public boolean trackFreedReferenceCounts() {
        return this.trackFreedRefCounts;
    }

    public void setReferenceCountOwner(Object owner) {
        if (this.trackReferenceCounts()) {
            if (this.refCountOwner.get() != null) {
                AtomicInteger ai = this.refCountReenterCount.get();
                if (owner != null) {
                    ai.incrementAndGet();
                } else if (ai.decrementAndGet() <= 0) {
                    this.refCountOwner.set(null);
                    ai.set(0);
                }
            } else {
                AtomicInteger ai = this.refCountReenterCount.get();
                if (ai == null) {
                    ai = new AtomicInteger(0);
                    this.refCountReenterCount.set(ai);
                }
                if (owner != null) {
                    ai.set(1);
                } else {
                    ai.set(0);
                }
                this.refCountOwner.set(owner);
            }
        }
    }

    public Object createReferenceCountOwner() {
        Object result = null;
        if (this.trackReferenceCounts()) {
            result = new Object();
            this.setReferenceCountOwner(result);
        }
        return result;
    }

    public void skipRefCountTracking() {
        this.setReferenceCountOwner(SKIP_REF_COUNT_TRACKING);
    }

    public boolean isRefCountTracking() {
        if (!this.trackReferenceCounts()) {
            return false;
        }
        return this.getReferenceCountOwner() != SKIP_REF_COUNT_TRACKING;
    }

    public void unskipRefCountTracking() {
        this.setReferenceCountOwner(null);
    }

    public List<RefCountChangeInfo> getRefCountInfo(long address) {
        if (!this.trackReferenceCounts()) {
            return null;
        }
        List result = (List)this.stacktraces.get(address);
        this.getReferenceCountInfoTestHook(this.stacktraces, address);
        while (result != null && !this.stacktraces.replace(address, result, LOCKED)) {
            result = (List)this.stacktraces.get(address);
        }
        return result;
    }

    protected void getReferenceCountInfoTestHook(ConcurrentMap<Long, List<RefCountChangeInfo>> stacktraces, long address) {
    }

    public List<RefCountChangeInfo> peekRefCountInfo(long address) {
        if (!this.trackReferenceCounts()) {
            return null;
        }
        return (List)this.stacktraces.get(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refCountChanged(Long address, boolean decRefCount, int rc) {
        List newList;
        if (!this.trackReferenceCounts()) {
            return;
        }
        Object owner = this.refCountOwner.get();
        if (owner == SKIP_REF_COUNT_TRACKING) {
            return;
        }
        List list = (List)this.stacktraces.get(address);
        if (list == null) {
            newList = new ArrayList();
            this.refCountChangedTestHook(address, decRefCount, rc);
            List old = this.stacktraces.putIfAbsent(address, newList);
            list = old == null ? newList : old;
        }
        if (decRefCount && owner != null) {
            newList = list;
            synchronized (newList) {
                for (int i = 0; i < list.size(); ++i) {
                    RefCountChangeInfo info = (RefCountChangeInfo)list.get(i);
                    if (owner instanceof RegionEntry) {
                        if (owner != info.getOwner()) continue;
                        if (info.getUseCount() > 0) {
                            info.decUseCount();
                        } else {
                            list.remove(i);
                        }
                        return;
                    }
                    if (!owner.equals(info.getOwner())) continue;
                    if (info.getUseCount() > 0) {
                        info.decUseCount();
                    } else {
                        list.remove(i);
                    }
                    return;
                }
            }
        }
        if (list == LOCKED) {
            MemoryAllocatorImpl.debugLog("refCount " + (decRefCount ? "deced" : "inced") + " after orphan detected for @" + Long.toHexString(address), true);
            return;
        }
        RefCountChangeInfo info = new RefCountChangeInfo(decRefCount, rc, owner);
        List list2 = list;
        synchronized (list2) {
            for (RefCountChangeInfo e : list) {
                if (!e.isSameCaller(info)) continue;
                e.incUseCount();
                return;
            }
            list.add(info);
        }
    }

    protected void refCountChangedTestHook(Long address, boolean decRefCount, int rc) {
    }

    void freeRefCountInfo(Long address) {
        if (!this.trackReferenceCounts()) {
            return;
        }
        List freedInfo = (List)this.stacktraces.remove(address);
        if (freedInfo == LOCKED) {
            MemoryAllocatorImpl.debugLog("freed after orphan detected for @" + Long.toHexString(address), true);
        } else if (this.trackFreedReferenceCounts()) {
            if (freedInfo != null) {
                this.freedStacktraces.put(address, freedInfo);
            } else {
                this.freedStacktraces.remove(address);
            }
        }
    }

    Object getReferenceCountOwner() {
        if (!this.trackReferenceCounts()) {
            return null;
        }
        return this.refCountOwner.get();
    }

    AtomicInteger getReenterCount() {
        if (!this.trackReferenceCounts()) {
            return null;
        }
        return this.refCountReenterCount.get();
    }

    public List<RefCountChangeInfo> getFreeRefCountInfo(long address) {
        if (!this.trackReferenceCounts() || !this.trackFreedReferenceCounts()) {
            return null;
        }
        return (List)this.freedStacktraces.get(address);
    }
}

