/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.offheap;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.geode.internal.offheap.AddressableMemoryManager;
import org.apache.geode.internal.offheap.MemoryAllocatorImpl;
import org.apache.geode.internal.offheap.MemoryBlock;

public class Fragment
implements MemoryBlock {
    private static final byte FILL_BYTE = 60;
    private final long baseAddr;
    private final int size;
    private volatile int freeIdx;
    private static AtomicIntegerFieldUpdater<Fragment> freeIdxUpdater = AtomicIntegerFieldUpdater.newUpdater(Fragment.class, "freeIdx");

    public Fragment(long addr, int size) {
        MemoryAllocatorImpl.validateAddress(addr);
        this.baseAddr = addr;
        this.size = size;
        freeIdxUpdater.set(this, 0);
    }

    public int freeSpace() {
        return this.getSize() - this.getFreeIndex();
    }

    public boolean allocate(int oldOffset, int newOffset) {
        return freeIdxUpdater.compareAndSet(this, oldOffset, newOffset);
    }

    public int getFreeIndex() {
        return freeIdxUpdater.get(this);
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public long getAddress() {
        return this.baseAddr;
    }

    @Override
    public MemoryBlock.State getState() {
        return MemoryBlock.State.UNUSED;
    }

    @Override
    public MemoryBlock getNextBlock() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getBlockSize() {
        return this.freeSpace();
    }

    @Override
    public int getSlabId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFreeListId() {
        return -1;
    }

    @Override
    public int getRefCount() {
        return 0;
    }

    @Override
    public String getDataType() {
        return "N/A";
    }

    @Override
    public boolean isSerialized() {
        return false;
    }

    @Override
    public boolean isCompressed() {
        return false;
    }

    @Override
    public Object getDataValue() {
        return null;
    }

    public void fill() {
        AddressableMemoryManager.fill(this.baseAddr, this.size, (byte)60);
    }

    public boolean equals(Object o) {
        if (o instanceof Fragment) {
            return this.getAddress() == ((Fragment)o).getAddress();
        }
        return false;
    }

    public int hashCode() {
        long value = this.getAddress();
        return (int)(value ^ value >>> 32);
    }

    public String toString() {
        return "Fragment [baseAddr=" + this.baseAddr + ", size=" + this.size + ", freeIdx=" + this.freeIdx + "]";
    }
}

