/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.logging;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Date;
import org.apache.geode.internal.OSProcess;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.io.MainWithChildrenRollingFileHandler;
import org.apache.geode.internal.io.RollingFileHandler;
import org.apache.geode.internal.logging.LocalLogWriter;
import org.apache.geode.internal.logging.LogConfig;
import org.apache.geode.internal.logging.log4j.AlertAppender;
import org.apache.geode.internal.util.LogFileUtils;

public class ManagerLogWriter
extends LocalLogWriter {
    public static final String TEST_FILE_SIZE_LIMIT_IN_KB_PROPERTY = "gemfire.logging.test.fileSizeLimitInKB";
    private final boolean fileSizeLimitInKB;
    private final RollingFileHandler rollingFileHandler;
    private LogConfig cfg = null;
    private LocalLogWriter mainLogger = this;
    private File logDir = null;
    private int mainLogId = -1;
    private int childId = 0;
    private boolean useChildLogging = false;
    private boolean rolling = false;
    private boolean mainLog = true;
    private File activeLogFile = null;
    private boolean started = false;

    public ManagerLogWriter(int level, PrintStream out) {
        this(level, out, null);
    }

    public ManagerLogWriter(int level, PrintStream out, String connectionName) {
        super(level, out, connectionName);
        this.fileSizeLimitInKB = Boolean.getBoolean(TEST_FILE_SIZE_LIMIT_IN_KB_PROPERTY);
        this.rollingFileHandler = new MainWithChildrenRollingFileHandler();
    }

    public void setConfig(LogConfig cfg) {
        this.cfg = cfg;
        this.configChanged();
    }

    public void configChanged() {
        this.setLevel(this.cfg.getLogLevel());
        boolean bl = this.useChildLogging = this.cfg.getLogFile() != null && !this.cfg.getLogFile().equals(new File("")) && this.cfg.getLogFileSizeLimit() != 0;
        if (this.useChildLogging()) {
            this.logDir = this.rollingFileHandler.getParentFile(this.cfg.getLogFile());
            this.mainLogId = this.rollingFileHandler.calcNextMainId(this.logDir, true);
        }
        if (this.started) {
            if (this.useChildLogging()) {
                if (this.mainLog) {
                    this.rollLog();
                }
            } else {
                this.switchLogs(this.cfg.getLogFile(), true);
            }
        }
    }

    public File getChildLogFile() {
        return this.activeLogFile;
    }

    public File getLogDir() {
        return this.logDir;
    }

    public int getMainLogId() {
        return this.mainLogId;
    }

    private File getNextChildLogFile() {
        String path = this.cfg.getLogFile().getPath();
        int extIdx = path.lastIndexOf(46);
        String ext = "";
        if (extIdx != -1) {
            ext = path.substring(extIdx);
            path = path.substring(0, extIdx);
        }
        path = path + this.rollingFileHandler.formatId(this.mainLogId) + this.rollingFileHandler.formatId(this.childId) + ext;
        ++this.childId;
        File result = new File(path);
        if (result.exists()) {
            return this.getNextChildLogFile();
        }
        return result;
    }

    public boolean useChildLogging() {
        return this.useChildLogging;
    }

    private long getLogFileSizeLimit() {
        if (this.rolling || this.mainLog) {
            return Long.MAX_VALUE;
        }
        long result = this.cfg.getLogFileSizeLimit();
        if (result == 0L) {
            return Long.MAX_VALUE;
        }
        if (this.fileSizeLimitInKB) {
            return result * 1024L;
        }
        return result * 0x100000L;
    }

    private long getLogDiskSpaceLimit() {
        long result = this.cfg.getLogDiskSpaceLimit();
        return result * 0x100000L;
    }

    private String getMetaLogFileName(String baseLogFileName, int mainLogId) {
        String metaLogFile = null;
        int extIdx = baseLogFileName.lastIndexOf(46);
        String ext = "";
        if (extIdx != -1) {
            ext = baseLogFileName.substring(extIdx);
            metaLogFile = baseLogFileName.substring(0, extIdx);
        }
        String fileName = new File(metaLogFile).getName();
        String parent = new File(metaLogFile).getParent();
        metaLogFile = "meta-" + fileName + this.rollingFileHandler.formatId(mainLogId) + ext;
        if (parent != null) {
            metaLogFile = parent + File.separator + metaLogFile;
        }
        return metaLogFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void switchLogs(File newLog, boolean newIsMain) {
        this.rolling = true;
        try {
            try {
                if (!newIsMain) {
                    if (this.mainLog && this.mainLogger == this && this.cfg.getLogFile() != null) {
                        String metaLogFile = this.getMetaLogFileName(this.cfg.getLogFile().getPath(), this.mainLogId);
                        this.mainLogger = new LocalLogWriter(800, new PrintStream(new FileOutputStream(metaLogFile, true), true));
                        if (this.activeLogFile == null) {
                            this.mainLogger.info(LocalizedStrings.ManagerLogWriter_SWITCHING_TO_LOG__0, this.cfg.getLogFile());
                        }
                    } else {
                        this.mainLogger.info(LocalizedStrings.ManagerLogWriter_ROLLING_CURRENT_LOG_TO_0, newLog);
                    }
                }
                boolean renameOK = true;
                String oldName = this.cfg.getLogFile().getAbsolutePath();
                File tmpFile = null;
                if (this.activeLogFile != null && !this.activeLogFile.getAbsolutePath().equals(newLog.getAbsolutePath())) {
                    File oldFile;
                    File tmpLogDir;
                    PrintStream tmpps;
                    PrintWriter oldPW;
                    boolean isWindows = false;
                    String os = System.getProperty("os.name");
                    if (os != null && os.indexOf("Windows") != -1) {
                        isWindows = true;
                    }
                    if (isWindows && (oldPW = this.setTarget(new PrintWriter(tmpps = OSProcess.redirectOutput(tmpFile = File.createTempFile("mlw", null, tmpLogDir = this.rollingFileHandler.getParentFile(this.cfg.getLogFile())), AlertAppender.getInstance().isAlertingDisabled()), true))) != null) {
                        oldPW.close();
                    }
                    if (!(renameOK = LogFileUtils.renameAggressively(oldFile = this.activeLogFile, newLog.getAbsoluteFile()))) {
                        this.mainLogger.warning("Could not delete original file '" + oldFile + "' after copying to '" + newLog.getAbsoluteFile() + "'. Continuing without rolling.");
                    } else {
                        renameOK = true;
                    }
                }
                this.activeLogFile = new File(oldName);
                PrintStream ps = OSProcess.redirectOutput(this.activeLogFile, AlertAppender.getInstance().isAlertingDisabled());
                PrintWriter oldPW = this.setTarget(new PrintWriter(ps, true), this.activeLogFile.length());
                if (oldPW != null) {
                    oldPW.close();
                }
                if (tmpFile != null) {
                    tmpFile.delete();
                }
                this.mainLog = newIsMain;
                if (this.mainLogger == null) {
                    this.mainLogger = this;
                }
                if (!renameOK) {
                    this.mainLogger.warning("Could not rename \"" + this.activeLogFile + "\" to \"" + newLog + "\". Continuing without rolling.");
                }
            }
            catch (IOException ex) {
                this.mainLogger.warning("Could not open log \"" + newLog + "\" because " + ex);
            }
            this.checkDiskSpace(this.activeLogFile);
        }
        finally {
            this.rolling = false;
        }
    }

    public void closingLogFile() {
        PrintWriter pw;
        OutputStream out = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        };
        this.close();
        if (this.mainLogger != null) {
            this.mainLogger.close();
        }
        if ((pw = this.setTarget(new PrintWriter(out, true))) != null) {
            pw.close();
        }
    }

    public static File getLogNameForOldMainLog(File log, boolean useOldFile) {
        MainWithChildrenRollingFileHandler rollingFileHandler = new MainWithChildrenRollingFileHandler();
        File dir = rollingFileHandler.getParentFile(log.getAbsoluteFile());
        int previousMainId = rollingFileHandler.calcNextMainId(dir, true);
        if (useOldFile && previousMainId > 0) {
            --previousMainId;
        }
        if (previousMainId == 0) {
            previousMainId = 1;
        }
        File result = null;
        int childId = rollingFileHandler.calcNextChildId(log, previousMainId > 0 ? previousMainId : 0);
        StringBuffer buf = new StringBuffer(log.getPath());
        int insertIdx = buf.lastIndexOf(".");
        if (insertIdx == -1) {
            buf.append(rollingFileHandler.formatId(previousMainId)).append(rollingFileHandler.formatId(childId));
        } else {
            buf.insert(insertIdx, rollingFileHandler.formatId(childId));
            buf.insert(insertIdx, rollingFileHandler.formatId(previousMainId));
        }
        result = new File(buf.toString());
        return result;
    }

    private void checkDiskSpace(File newLog) {
        this.rollingFileHandler.checkDiskSpace("log", newLog, this.getLogDiskSpaceLimit(), this.logDir, this.mainLogger);
    }

    public void rollLog() {
        this.rollLog(false);
    }

    private void rollLogIfFull() {
        this.rollLog(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollLog(boolean ifFull) {
        if (!this.useChildLogging()) {
            return;
        }
        ManagerLogWriter managerLogWriter = this;
        synchronized (managerLogWriter) {
            if (ifFull && !this.activeLogFull()) {
                return;
            }
            this.switchLogs(this.getNextChildLogFile(), false);
        }
    }

    public void startupComplete() {
        this.started = true;
        this.rollLog();
    }

    public void shuttingDown() {
        if (this.useChildLogging()) {
            this.switchLogs(this.cfg.getLogFile(), true);
        }
    }

    private boolean activeLogFull() {
        long limit = this.getLogFileSizeLimit();
        if (limit == Long.MAX_VALUE) {
            return false;
        }
        return this.getBytesLogged() >= limit;
    }

    @Override
    public String put(int msgLevel, Date msgDate, String connectionName, String threadName, long tid, String msg, String exceptionText) {
        String result = null;
        result = super.put(msgLevel, msgDate, connectionName, threadName, tid, msg, exceptionText);
        return result;
    }

    @Override
    public void writeFormattedMessage(String s) {
        this.rollLogIfFull();
        super.writeFormattedMessage(s);
    }
}

