/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.logging;

import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.Banner;
import org.apache.geode.internal.ConfigSource;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.InternalLogWriter;
import org.apache.geode.internal.logging.LogConfig;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.SecurityLogWriter;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.logging.log4j.LogWriterLogger;

public class LogWriterFactory {
    public static InternalLogWriter toSecurityLogWriter(InternalLogWriter logWriter) {
        return new SecurityLogWriter(logWriter.getLogWriterLevel(), logWriter);
    }

    public static InternalLogWriter createLogWriterLogger(boolean isLoner, boolean isSecure, LogConfig config, boolean logConfig) {
        String name = null;
        name = isSecure ? "org.apache.geode.security" : "org.apache.geode";
        LogWriterLogger logger = LogService.createLogWriterLogger(name, config.getName(), isSecure);
        if (isSecure) {
            logger.setLogWriterLevel(((DistributionConfig)config).getSecurityLogLevel());
        } else {
            ConfigSource source;
            boolean defaultSource = false;
            if (config instanceof DistributionConfig && (source = ((DistributionConfig)config).getConfigSource("log-level")) == null) {
                defaultSource = true;
            }
            if (!defaultSource) {
                logger.setLogWriterLevel(config.getLogLevel());
            }
        }
        if (!Boolean.getBoolean("Locator.inhibitDMBanner") && InternalDistributedSystem.getReconnectAttemptCounter() == 0 && !isSecure && logConfig) {
            logger.info(LogMarker.CONFIG_MARKER, Banner.getString(null));
        } else {
            logger.debug("skipping banner - Locator.inhibitDMBanner is set to true");
        }
        if (logConfig && !isLoner) {
            logger.info(LogMarker.CONFIG_MARKER, LocalizedMessage.create(LocalizedStrings.InternalDistributedSystem_STARTUP_CONFIGURATION_0, config.toLoggerString()));
        }
        return logger;
    }
}

