/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.config;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.internal.ClassPathLoader;
import org.xml.sax.SAXException;

public class JAXBService {
    public static String CACHE_SCHEMA = "http://geode.apache.org/schema/cache http://geode.apache.org/schema/cache/cache-1.0.xsd";
    Map<Class, String> classAndSchema = new HashMap<Class, String>();
    Marshaller marshaller;
    Unmarshaller unmarshaller;

    public JAXBService() {
        this.registerBindClassWithSchema(CacheConfig.class, CACHE_SCHEMA);
        URL local_cache_xsd = ClassPathLoader.getLatest().getResource("META-INF/schemas/geode.apache.org/schema/cache/cache-1.0.xsd");
        this.validateWith(local_cache_xsd);
    }

    public void validateWith(URL url) {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = null;
        try {
            schema = factory.newSchema(url);
        }
        catch (SAXException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.marshaller.setSchema(schema);
    }

    public void registerBindClassWithSchema(Class c, String nameSpaceAndSchemaLocation) {
        if (!this.classAndSchema.keySet().contains(c)) {
            this.classAndSchema.put(c, nameSpaceAndSchemaLocation);
            try {
                Set<Class> bindClasses = this.classAndSchema.keySet();
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])bindClasses.toArray(new Class[bindClasses.size()]));
                this.marshaller = jaxbContext.createMarshaller();
                this.unmarshaller = jaxbContext.createUnmarshaller();
                this.marshaller.setProperty("jaxb.formatted.output", (Object)true);
                this.updateSchema();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return;
        }
        String oldSchema = this.classAndSchema.get(c);
        if (nameSpaceAndSchemaLocation == null) {
            return;
        }
        if (!nameSpaceAndSchemaLocation.equals(oldSchema)) {
            this.classAndSchema.put(c, nameSpaceAndSchemaLocation);
            this.updateSchema();
        }
    }

    void updateSchema() {
        try {
            String schemas = this.classAndSchema.values().stream().filter(Objects::nonNull).collect(Collectors.joining(" "));
            this.marshaller.setProperty("jaxb.schemaLocation", (Object)schemas);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String marshall(Object object) {
        StringWriter sw = new StringWriter();
        try {
            this.marshaller.marshal(object, (Writer)sw);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return sw.toString();
    }

    public <T> T unMarshall(String xml) {
        try {
            return (T)this.unmarshaller.unmarshal((Reader)new StringReader(xml));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void registerBindClasses(Class clazz) {
        this.registerBindClassWithSchema(clazz, null);
    }
}

