/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tx;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.geode.cache.CacheException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.ReplySender;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.RemoteOperationException;
import org.apache.geode.internal.cache.tx.RemoteOperationMessage;
import org.apache.geode.internal.cache.tx.RemoteOperationMessageWithDirectReply;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

public class RemoteClearMessage
extends RemoteOperationMessageWithDirectReply {
    private static final Logger logger = LogService.getLogger();
    private transient DistributedRegion region;

    public RemoteClearMessage() {
    }

    public static RemoteClearMessage create(InternalDistributedMember recipient, DistributedRegion region) {
        return new RemoteClearMessage(recipient, region, Operation.CLEAR);
    }

    private RemoteClearMessage(InternalDistributedMember recipient, DistributedRegion region, Operation op) {
        super(recipient, region.getFullPath(), new RemoteOperationMessage.RemoteOperationResponse(region.getSystem(), recipient));
        this.region = region;
    }

    public void distribute() throws RemoteOperationException {
        RemoteOperationMessage.RemoteOperationResponse p = (RemoteOperationMessage.RemoteOperationResponse)this.processor;
        Set failures = this.region.getDistributionManager().putOutgoing(this);
        if (failures != null && failures.size() > 0) {
            throw new RemoteOperationException(LocalizedStrings.FAILED_SENDING_0.toLocalizedString(this));
        }
        p.waitForRemoteResponse();
    }

    @Override
    protected boolean operateOnRegion(ClusterDistributionManager dm, LocalRegion r, long startTime) throws CacheException, RemoteOperationException {
        if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
            logger.trace(LogMarker.DM_VERBOSE, "RemoteClearMessage operateOnRegion: {}", (Object)r.getFullPath());
        }
        r.waitOnInitialization();
        r.clear();
        RemoteClearReplyMessage.send(this.getSender(), this.getProcessorId(), this.getReplySender(dm));
        return false;
    }

    @Override
    protected void appendFields(StringBuffer buff) {
        super.appendFields(buff);
    }

    @Override
    public int getDSFID() {
        return -131;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        in.readByte();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeByte(Operation.CLEAR.ordinal());
    }

    public static class RemoteClearReplyMessage
    extends ReplyMessage {
        public RemoteClearReplyMessage() {
        }

        private RemoteClearReplyMessage(int processorId) {
            this.processorId = processorId;
        }

        public static void send(InternalDistributedMember recipient, int processorId, ReplySender replySender) {
            Assert.assertTrue(recipient != null, "RemoteClearReplyMessage NULL recipient");
            RemoteClearReplyMessage m = new RemoteClearReplyMessage(processorId);
            m.setRecipient(recipient);
            replySender.putOutgoing(m);
        }

        @Override
        public void process(DistributionManager dm, ReplyProcessor21 processor) {
            long startTime = this.getTimestamp();
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                    logger.trace(LogMarker.DM_VERBOSE, "RemoteClearReplyMessage processor not found");
                }
                return;
            }
            processor.process(this);
            dm.getStats().incReplyMessageTime(DistributionStats.getStatTime() - startTime);
        }

        @Override
        public int getDSFID() {
            return -132;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("RemoteClearReplyMessage ").append("processorid=").append(this.processorId).append(" reply to sender ").append(this.getSender());
            return sb.toString();
        }
    }

    private static enum Operation {
        CLEAR;

    }
}

