/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tx;

import java.util.Set;
import org.apache.geode.cache.EntryExistsException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.UnsupportedOperationInTransactionException;
import org.apache.geode.cache.client.ServerOperationException;
import org.apache.geode.cache.client.internal.ServerRegionDataAccess;
import org.apache.geode.internal.cache.DistributedPutAllOperation;
import org.apache.geode.internal.cache.DistributedRemoveAllOperation;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.KeyInfo;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.VersionedObjectList;
import org.apache.geode.internal.cache.tx.TXRegionStub;

public class ClientTXRegionStub
implements TXRegionStub {
    private final ServerRegionDataAccess proxy;

    public ClientTXRegionStub(LocalRegion region) {
        this.proxy = region.getServerProxy();
    }

    @Override
    public boolean containsKey(KeyInfo keyInfo) {
        return this.proxy.containsKey(keyInfo.getKey());
    }

    @Override
    public boolean containsValueForKey(KeyInfo keyInfo) {
        return this.proxy.containsValueForKey(keyInfo.getKey());
    }

    @Override
    public void destroyExistingEntry(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) {
        if (event.getOperation().isLocal()) {
            throw new UnsupportedOperationInTransactionException();
        }
        Object result = this.proxy.destroy(event.getKey(), expectedOldValue, event.getOperation(), event, event.getCallbackArgument());
        if (result instanceof EntryNotFoundException) {
            throw (EntryNotFoundException)result;
        }
    }

    @Override
    public Object findObject(KeyInfo keyInfo, boolean isCreate, boolean generateCallbacks, Object value, boolean preferCD, ClientProxyMembershipID requestingClient, EntryEventImpl event) {
        return this.proxy.get(keyInfo.getKey(), keyInfo.getCallbackArg(), event);
    }

    @Override
    public Region.Entry<?, ?> getEntry(KeyInfo keyInfo, boolean allowTombstones) {
        return this.proxy.getEntry(keyInfo.getKey());
    }

    @Override
    public Object getEntryForIterator(KeyInfo keyInfo, boolean allowTombstones) {
        return this.getEntry(keyInfo, allowTombstones);
    }

    @Override
    public void invalidateExistingEntry(EntryEventImpl event, boolean invokeCallbacks, boolean forceNewEntry) {
        if (event.getOperation().isLocal()) {
            throw new UnsupportedOperationInTransactionException();
        }
        this.proxy.invalidate(event);
    }

    @Override
    public boolean putEntry(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed) {
        if (event.isBulkOpInProgress()) {
            return true;
        }
        Object result = null;
        try {
            result = this.proxy.put(event.getKey(), event.getRawNewValue(), event.getDeltaBytes(), event, event.getOperation(), requireOldValue, expectedOldValue, event.getCallbackArgument(), event.isCreate());
        }
        catch (ServerOperationException e) {
            if (e.getCause() != null && e.getCause() instanceof EntryExistsException) {
                throw (EntryExistsException)e.getCause();
            }
            throw e;
        }
        if (event.getOperation() == Operation.REPLACE) {
            if (!requireOldValue) {
                return (Boolean)result;
            }
            event.setOldValue(result);
        } else if (event.getOperation() == Operation.PUT_IF_ABSENT) {
            event.setOldValue(result);
            if (result != null) {
                return false;
            }
        }
        return true;
    }

    @Override
    public int entryCount() {
        return this.proxy.size();
    }

    @Override
    public Set getRegionKeysForIteration() {
        return this.proxy.keySet();
    }

    @Override
    public void postPutAll(DistributedPutAllOperation putallOp, VersionedObjectList successfulPuts, LocalRegion r) {
    }

    @Override
    public void postRemoveAll(DistributedRemoveAllOperation op, VersionedObjectList successfulOps, LocalRegion region) {
    }

    @Override
    public void cleanup() {
    }
}

