/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.util.Map;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.pdx.internal.PdxType;

public class GetPdxTypes70
extends BaseCommand {
    private static final GetPdxTypes70 singleton = new GetPdxTypes70();

    public static Command getCommand() {
        return singleton;
    }

    private GetPdxTypes70() {
    }

    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long start) throws IOException, ClassNotFoundException {
        Map<Integer, PdxType> types;
        serverConnection.setAsTrue(2);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received get pdx types from {}", (Object)serverConnection.getName(), (Object)serverConnection.getSocketString());
        }
        if (!ServerConnection.allowInternalMessagesWithoutCredentials) {
            serverConnection.getAuthzRequest();
        }
        try {
            InternalCache cache = serverConnection.getCache();
            types = cache.getPdxRegistry().typeMap();
        }
        catch (Exception e) {
            GetPdxTypes70.writeException(clientMessage, e, false, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        Message responseMsg = serverConnection.getResponseMessage();
        responseMsg.setMessageType(1);
        responseMsg.setNumberOfParts(1);
        responseMsg.setTransactionId(clientMessage.getTransactionId());
        responseMsg.addObjPart(types);
        responseMsg.send(serverConnection);
        serverConnection.setAsTrue(1);
    }
}

