/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.Principal;
import java.util.Properties;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.VersionedDataInputStream;
import org.apache.geode.internal.VersionedDataOutputStream;
import org.apache.geode.internal.VersionedDataStream;
import org.apache.geode.internal.cache.tier.CommunicationMode;
import org.apache.geode.internal.cache.tier.Encryptor;
import org.apache.geode.internal.cache.tier.ServerSideHandshake;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.EncryptorImpl;
import org.apache.geode.internal.cache.tier.sockets.Handshake;
import org.apache.geode.internal.cache.tier.sockets.ServerSideHandshakeFactory;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.pdx.internal.PeerTypeRegistration;
import org.apache.geode.security.AuthenticationRequiredException;

public class ServerSideHandshakeImpl
extends Handshake
implements ServerSideHandshake {
    private static final Version currentServerVersion = ServerSideHandshakeFactory.currentServerVersion;
    private Version clientVersion;
    private final byte replyCode;

    @Override
    protected byte getReplyCode() {
        return this.replyCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerSideHandshakeImpl(Socket sock, int timeout, DistributedSystem sys, Version clientVersion, CommunicationMode communicationMode, SecurityService securityService) throws IOException, AuthenticationRequiredException {
        this.clientVersion = clientVersion;
        this.system = sys;
        this.securityService = securityService;
        this.encryptor = new EncryptorImpl(sys.getSecurityLogWriter());
        int soTimeout = -1;
        try {
            soTimeout = sock.getSoTimeout();
            sock.setSoTimeout(timeout);
            InputStream inputStream = sock.getInputStream();
            int valRead = inputStream.read();
            if (valRead == -1) {
                throw new EOFException(LocalizedStrings.HandShake_HANDSHAKE_EOF_REACHED_BEFORE_CLIENT_CODE_COULD_BE_READ.toLocalizedString());
            }
            this.replyCode = (byte)valRead;
            if (this.replyCode != 59) {
                throw new IOException(LocalizedStrings.HandShake_HANDSHAKE_REPLY_CODE_IS_NOT_OK.toLocalizedString());
            }
            try {
                DataInputStream dataInputStream = new DataInputStream(inputStream);
                DataOutputStream dataOutputStream = new DataOutputStream(sock.getOutputStream());
                this.clientReadTimeout = dataInputStream.readInt();
                if (clientVersion.compareTo(Version.CURRENT) < 0) {
                    dataInputStream = new VersionedDataInputStream(dataInputStream, clientVersion);
                    dataOutputStream = new VersionedDataOutputStream(dataOutputStream, clientVersion);
                }
                this.id = ClientProxyMembershipID.readCanonicalized(dataInputStream);
                if (clientVersion.compareTo(Version.GFE_603) >= 0) {
                    this.setOverrides(new byte[]{dataInputStream.readByte()});
                } else {
                    this.setClientConflation(dataInputStream.readByte());
                }
                this.credentials = this.clientVersion.compareTo(Version.GFE_65) < 0 || communicationMode.isWAN() ? ServerSideHandshakeImpl.readCredentials(dataInputStream, dataOutputStream, sys, this.securityService) : this.readCredential(dataInputStream, dataOutputStream, sys);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(LocalizedStrings.HandShake_CLIENTPROXYMEMBERSHIPID_CLASS_COULD_NOT_BE_FOUND_WHILE_DESERIALIZING_THE_OBJECT.toLocalizedString());
            }
        }
        finally {
            if (soTimeout != -1) {
                try {
                    sock.setSoTimeout(soTimeout);
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Version getClientVersion() {
        return this.clientVersion;
    }

    @Override
    public Version getVersion() {
        return this.clientVersion;
    }

    @Override
    public void handshakeWithClient(OutputStream out, InputStream in, byte endpointType, int queueSize, CommunicationMode communicationMode, Principal principal) throws IOException {
        DataInputStream dis;
        DataOutputStream dos = new DataOutputStream(out);
        if (this.clientVersion.compareTo(Version.CURRENT) < 0) {
            dis = new VersionedDataInputStream(in, this.clientVersion);
            dos = new VersionedDataOutputStream(dos, this.clientVersion);
        } else {
            dis = new DataInputStream(in);
        }
        if (communicationMode.isWAN() && principal != null) {
            dos.writeByte(65);
        } else {
            dos.writeByte(59);
        }
        if (communicationMode.isWAN()) {
            Version.writeOrdinal(dos, currentServerVersion.ordinal(), true);
        }
        dos.writeByte(endpointType);
        dos.writeInt(queueSize);
        DistributedMember member = this.system.getDistributedMember();
        Version v = Version.CURRENT;
        if (dos instanceof VersionedDataStream) {
            v = ((VersionedDataStream)((Object)dos)).getVersion();
        }
        HeapDataOutputStream hdos = new HeapDataOutputStream(v);
        DataSerializer.writeObject(member, hdos);
        DataSerializer.writeByteArray(hdos.toByteArray(), dos);
        hdos.close();
        dos.writeUTF("");
        if (!communicationMode.isWAN() && this.clientVersion.compareTo(Version.GFE_61) >= 0) {
            dos.writeBoolean(((InternalDistributedSystem)this.system).getConfig().getDeltaPropagation());
        }
        if (communicationMode.isWAN() && principal != null) {
            this.sendCredentialsForWan(dos, dis);
        }
        if (communicationMode.isWAN() && this.clientVersion.compareTo(Version.GFE_66) >= 0 && currentServerVersion.compareTo(Version.GFE_66) >= 0) {
            dos.writeByte(((InternalDistributedSystem)this.system).getDistributionManager().getDistributedSystemId());
        }
        if (communicationMode.isWAN() && this.clientVersion.compareTo(Version.GFE_80) >= 0 && currentServerVersion.compareTo(Version.GFE_80) >= 0) {
            int pdxSize = PeerTypeRegistration.getPdxRegistrySize();
            dos.writeInt(pdxSize);
        }
        dos.flush();
    }

    @Override
    public Encryptor getEncryptor() {
        return this.encryptor;
    }

    private void sendCredentialsForWan(OutputStream out, InputStream in) {
        try {
            Properties wanCredentials = this.getCredentials(this.id.getDistributedMember());
            DataOutputStream dos = new DataOutputStream(out);
            DataInputStream dis = new DataInputStream(in);
            this.writeCredentials(dos, dis, wanCredentials, false, this.system.getDistributedMember());
        }
        catch (Exception e) {
            this.system.getSecurityLogWriter().convertToLogWriterI18n().severe(LocalizedStrings.HandShake_AN_EXCEPTION_WAS_THROWN_WHILE_SENDING_WAN_CREDENTIALS_0, e.getLocalizedMessage());
        }
    }

    @Override
    public int getClientReadTimeout() {
        return this.clientReadTimeout;
    }
}

