/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.IOException;
import java.net.Socket;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.client.protocol.ClientProtocolProcessor;
import org.apache.geode.internal.cache.client.protocol.ClientProtocolService;
import org.apache.geode.internal.cache.client.protocol.ClientProtocolServiceLoader;
import org.apache.geode.internal.cache.client.protocol.exception.ServiceLoadingFailureException;
import org.apache.geode.internal.cache.client.protocol.exception.ServiceVersionNotFoundException;
import org.apache.geode.internal.cache.tier.Acceptor;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.CommunicationMode;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.OriginalServerConnection;
import org.apache.geode.internal.cache.tier.sockets.ProtobufServerConnection;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.SecurityService;

public class ServerConnectionFactory {
    private final ClientProtocolServiceLoader clientProtocolServiceLoader = new ClientProtocolServiceLoader();
    private volatile ClientProtocolService clientProtocolService;

    private synchronized ClientProtocolService getClientProtocolService(StatisticsFactory statisticsFactory, String serverName) {
        if (this.clientProtocolService == null) {
            this.clientProtocolService = this.clientProtocolServiceLoader.lookupService();
            this.clientProtocolService.initializeStatistics(serverName, statisticsFactory);
        }
        return this.clientProtocolService;
    }

    public ServerConnection makeServerConnection(Socket socket, InternalCache cache, CachedRegionHelper helper, CacheServerStats stats, int hsTimeout, int socketBufferSize, String communicationModeStr, byte communicationMode, Acceptor acceptor, SecurityService securityService) throws IOException {
        if (CommunicationMode.ProtobufClientServerProtocol.getModeNumber() == communicationMode) {
            if (!Boolean.getBoolean("geode.feature-protobuf-protocol")) {
                throw new IOException("Server received unknown communication mode: " + communicationMode);
            }
            try {
                return this.createProtobufServerConnection(socket, cache, helper, stats, hsTimeout, socketBufferSize, communicationModeStr, communicationMode, acceptor, securityService);
            }
            catch (ServiceLoadingFailureException ex) {
                throw new IOException("Could not load protobuf client protocol", ex);
            }
            catch (ServiceVersionNotFoundException ex) {
                throw new IOException("No service matching provided version byte", ex);
            }
        }
        return new OriginalServerConnection(socket, cache, helper, stats, hsTimeout, socketBufferSize, communicationModeStr, communicationMode, acceptor, securityService);
    }

    private ServerConnection createProtobufServerConnection(Socket socket, InternalCache cache, CachedRegionHelper helper, CacheServerStats stats, int hsTimeout, int socketBufferSize, String communicationModeStr, byte communicationMode, Acceptor acceptor, SecurityService securityService) {
        ClientProtocolService service = this.getClientProtocolService(cache.getDistributedSystem(), acceptor.getServerName());
        ClientProtocolProcessor processor = service.createProcessorForCache(cache, securityService);
        return new ProtobufServerConnection(socket, cache, helper, stats, hsTimeout, socketBufferSize, communicationModeStr, communicationMode, acceptor, processor, securityService);
    }
}

