/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.IOException;
import java.net.Socket;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.tier.Acceptor;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.security.SecurityService;
import org.apache.logging.log4j.message.Message;

public class OriginalServerConnection
extends ServerConnection {
    private boolean doHandshake = true;

    public OriginalServerConnection(Socket socket, InternalCache internalCache, CachedRegionHelper helper, CacheServerStats stats, int hsTimeout, int socketBufferSize, String communicationModeStr, byte communicationMode, Acceptor acceptor, SecurityService securityService) {
        super(socket, internalCache, helper, stats, hsTimeout, socketBufferSize, communicationModeStr, communicationMode, acceptor, securityService);
    }

    @Override
    protected boolean doHandShake(byte endpointType, int queueSize) {
        try {
            this.handshake.handshakeWithClient(this.theSocket.getOutputStream(), this.theSocket.getInputStream(), endpointType, queueSize, this.communicationMode, this.principal);
        }
        catch (IOException ioe) {
            if (!this.crHelper.isShutdown() && !this.isTerminated()) {
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.ServerConnection_0_HANDSHAKE_ACCEPT_FAILED_ON_SOCKET_1_2, new Object[]{this.name, this.theSocket, ioe}));
            }
            this.cleanup();
            return false;
        }
        return true;
    }

    @Override
    protected void doOneMessage() {
        if (this.doHandshake) {
            this.doHandshake();
            this.doHandshake = false;
        } else {
            this.resetTransientData();
            this.doNormalMsg();
        }
    }
}

