/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.geode.DataSerializer;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.EnumListenerEvent;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.internal.cache.tier.sockets.CacheServerHelper;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.ClientUpdateMessageImpl;
import org.apache.geode.internal.cache.tier.sockets.Message;

public class ClientDataSerializerMessage
extends ClientUpdateMessageImpl {
    private byte[][] serializedDataSerializer;
    private Class[][] supportedClasses;

    public ClientDataSerializerMessage(EnumListenerEvent operation, byte[][] dataSerializer, ClientProxyMembershipID memberId, EventID eventIdentifier, Class[][] supportedClasses) {
        super(operation, memberId, eventIdentifier);
        this.serializedDataSerializer = dataSerializer;
        this.supportedClasses = supportedClasses;
    }

    public ClientDataSerializerMessage() {
    }

    @Override
    public boolean shouldBeConflated() {
        return false;
    }

    @Override
    protected Message getMessage(CacheClientProxy proxy, byte[] latestValue) throws IOException {
        if (proxy.getVersion().compareTo(Version.GFE_6516) >= 0) {
            return this.getGFE6516Message(proxy.getVersion());
        }
        if (proxy.getVersion().compareTo(Version.GFE_57) >= 0) {
            return this.getGFEMessage(proxy.getVersion());
        }
        throw new IOException("Unsupported client version for server-to-client message creation: " + proxy.getVersion());
    }

    protected Message getGFEMessage(Version clientVersion) {
        Message message = null;
        int dataSerializerLength = this.serializedDataSerializer.length;
        message = new Message(dataSerializerLength + 1, clientVersion);
        message.setMessageType(67);
        for (int i = 0; i < dataSerializerLength; i += 2) {
            message.addBytesPart(this.serializedDataSerializer[i]);
            message.addBytesPart(this.serializedDataSerializer[i + 1]);
        }
        message.setTransactionId(0);
        message.addObjPart(this.getEventId());
        return message;
    }

    protected Message getGFE6516Message(Version clientVersion) {
        int i;
        int numOfDS;
        Message message = null;
        int dsLength = this.serializedDataSerializer.length;
        assert (dsLength % 2 == 0);
        int n = numOfDS = this.supportedClasses != null ? this.supportedClasses.length : 0;
        assert (dsLength / 2 == numOfDS);
        int numOfParts = dsLength + numOfDS;
        for (i = 0; i < numOfDS; ++i) {
            if (this.supportedClasses[i] == null) continue;
            numOfParts += this.supportedClasses[i].length;
        }
        message = new Message(++numOfParts, clientVersion);
        message.setMessageType(67);
        for (i = 0; i < dsLength; i += 2) {
            int j;
            message.addBytesPart(this.serializedDataSerializer[i]);
            message.addBytesPart(this.serializedDataSerializer[i + 1]);
            int numOfClasses = this.supportedClasses[i / 2].length;
            Object classBytes = new byte[numOfClasses][];
            try {
                for (j = 0; j < numOfClasses; ++j) {
                    classBytes[j] = CacheServerHelper.serialize(this.supportedClasses[i / 2][j].getName());
                }
            }
            catch (IOException ioe) {
                numOfClasses = 0;
                classBytes = null;
            }
            message.addIntPart(numOfClasses);
            for (j = 0; j < numOfClasses; ++j) {
                message.addBytesPart(classBytes[j]);
            }
        }
        message.setTransactionId(0);
        message.addObjPart(this.getEventId());
        return message;
    }

    @Override
    public int getDSFID() {
        return 2002;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeByte(this._operation.getEventCode());
        int dataSerializerCount = this.serializedDataSerializer.length;
        out.writeInt(dataSerializerCount);
        for (int i = 0; i < dataSerializerCount; ++i) {
            DataSerializer.writeByteArray(this.serializedDataSerializer[i], out);
        }
        DataSerializer.writeObject(this._membershipId, out);
        DataSerializer.writeObject(this._eventIdentifier, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this._operation = EnumListenerEvent.getEnumListenerEvent(in.readByte());
        int dataSerializerCount = in.readInt();
        this.serializedDataSerializer = new byte[dataSerializerCount][];
        for (int i = 0; i < dataSerializerCount; ++i) {
            this.serializedDataSerializer[i] = DataSerializer.readByteArray(in);
        }
        this._membershipId = ClientProxyMembershipID.readCanonicalized(in);
        this._eventIdentifier = (EventID)DataSerializer.readObject(in);
    }

    @Override
    public Object getKeyToConflate() {
        return null;
    }

    @Override
    public String getRegionToConflate() {
        return null;
    }

    @Override
    public Object getValueToConflate() {
        return null;
    }

    @Override
    public void setLatestValue(Object value) {
    }

    @Override
    public boolean isClientInterested(ClientProxyMembershipID clientId) {
        return true;
    }

    @Override
    public boolean needsNoAuthorizationCheck() {
        return true;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ClientDataSerializerMessage[").append(";value=").append(Arrays.toString((Object[])this.serializedDataSerializer)).append(";memberId=").append(this.getMembershipId()).append(";eventId=").append(this.getEventId()).append("]");
        return buffer.toString();
    }
}

