/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.persistence;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.persistence.DiskStoreID;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;
import org.apache.geode.internal.cache.persistence.PersistentMemberState;
import org.apache.geode.internal.cache.persistence.PersistentStateQueryResults;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class PersistentStateQueryMessage
extends HighPriorityDistributionMessage
implements MessageWithReply {
    private static final Logger logger = LogService.getLogger();
    private String regionPath;
    private PersistentMemberID id;
    private int processorId;
    private PersistentMemberID initializingId;

    public PersistentStateQueryMessage() {
    }

    public PersistentStateQueryMessage(String regionPath, PersistentMemberID id, PersistentMemberID initializingId, int processorId) {
        this.regionPath = regionPath;
        this.id = id;
        this.initializingId = initializingId;
        this.processorId = processorId;
    }

    public static PersistentStateQueryResults send(Set<InternalDistributedMember> members, DistributionManager dm, String regionPath, PersistentMemberID persistentId, PersistentMemberID initializingId) throws ReplyException {
        PersistentStateQueryReplyProcessor processor = new PersistentStateQueryReplyProcessor(dm, members);
        PersistentStateQueryMessage msg = new PersistentStateQueryMessage(regionPath, persistentId, initializingId, processor.getProcessorId());
        msg.setRecipients(members);
        dm.putOutgoing(msg);
        processor.waitForRepliesUninterruptibly();
        return processor.results;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected void process(ClusterDistributionManager dm) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public int getDSFID() {
        return 2102;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        boolean hasInitializingId;
        super.fromData(in);
        this.regionPath = DataSerializer.readString(in);
        this.processorId = in.readInt();
        boolean hasId = in.readBoolean();
        if (hasId) {
            this.id = new PersistentMemberID();
            this.id.fromData(in);
        }
        if (hasInitializingId = in.readBoolean()) {
            this.initializingId = new PersistentMemberID();
            this.initializingId.fromData(in);
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeString(this.regionPath, out);
        out.writeInt(this.processorId);
        out.writeBoolean(this.id != null);
        if (this.id != null) {
            this.id.toData(out);
        }
        out.writeBoolean(this.initializingId != null);
        if (this.initializingId != null) {
            this.initializingId.toData(out);
        }
    }

    @Override
    public String toString() {
        return super.toString() + ",id=" + this.id + ",regionPath=" + this.regionPath + ",initializingId=" + this.initializingId;
    }

    public static class PersistentStateQueryReplyMessage
    extends ReplyMessage {
        public HashSet<PersistentMemberID> onlineMembers;
        public DiskStoreID diskStoreId;
        private PersistentMemberState persistedStateOfPeer;
        private PersistentMemberID myId;
        private PersistentMemberID myInitializingId;

        @Override
        public int getDSFID() {
            return 2103;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            boolean hasOnlineMembers;
            boolean hasDiskStoreID;
            boolean hasInitializingId;
            boolean hasState;
            super.fromData(in);
            boolean hasId = in.readBoolean();
            if (hasId) {
                this.myId = new PersistentMemberID();
                this.myId.fromData(in);
            }
            if (hasState = in.readBoolean()) {
                this.persistedStateOfPeer = PersistentMemberState.fromData(in);
            }
            if (hasInitializingId = in.readBoolean()) {
                this.myInitializingId = new PersistentMemberID();
                this.myInitializingId.fromData(in);
            }
            if (hasDiskStoreID = in.readBoolean()) {
                this.diskStoreId = new DiskStoreID(in.readLong(), in.readLong());
            }
            if (hasOnlineMembers = in.readBoolean()) {
                this.onlineMembers = DataSerializer.readHashSet(in);
            }
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            if (this.myId == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this.myId.toData(out);
            }
            if (this.persistedStateOfPeer == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this.persistedStateOfPeer.toData(out);
            }
            if (this.myInitializingId == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this.myInitializingId.toData(out);
            }
            if (this.diskStoreId == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeLong(this.diskStoreId.getMostSignificantBits());
                out.writeLong(this.diskStoreId.getLeastSignificantBits());
            }
            if (this.onlineMembers == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                DataSerializer.writeHashSet(this.onlineMembers, out);
            }
        }

        @Override
        public String toString() {
            return super.toString() + ",myId=" + this.myId + ",myInitializingId=" + this.myInitializingId + ",persistedStateOfPeer=" + (Object)((Object)this.persistedStateOfPeer);
        }

        static /* synthetic */ PersistentMemberID access$002(PersistentStateQueryReplyMessage x0, PersistentMemberID x1) {
            x0.myId = x1;
            return x0.myId;
        }

        static /* synthetic */ PersistentMemberState access$102(PersistentStateQueryReplyMessage x0, PersistentMemberState x1) {
            x0.persistedStateOfPeer = x1;
            return x0.persistedStateOfPeer;
        }

        static /* synthetic */ PersistentMemberID access$202(PersistentStateQueryReplyMessage x0, PersistentMemberID x1) {
            x0.myInitializingId = x1;
            return x0.myInitializingId;
        }
    }

    private static class PersistentStateQueryReplyProcessor
    extends ReplyProcessor21 {
        PersistentStateQueryResults results = new PersistentStateQueryResults();

        public PersistentStateQueryReplyProcessor(DistributionManager dm, Collection initMembers) {
            super(dm, initMembers);
        }

        @Override
        public void process(DistributionMessage msg) {
            if (msg instanceof PersistentStateQueryReplyMessage) {
                PersistentStateQueryReplyMessage reply = (PersistentStateQueryReplyMessage)msg;
                this.results.addResult(reply.persistedStateOfPeer, reply.getSender(), reply.myId, reply.myInitializingId, reply.diskStoreId, reply.onlineMembers);
            }
            super.process(msg);
        }
    }
}

