/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionInvocationTargetException;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.internal.cache.execute.BucketMovedException;
import org.apache.geode.internal.cache.execute.FunctionStreamingResultCollector;
import org.apache.geode.internal.cache.execute.InternalFunctionException;
import org.apache.geode.internal.cache.execute.InternalFunctionInvocationTargetException;
import org.apache.geode.internal.cache.execute.LocalResultCollectorImpl;
import org.apache.geode.internal.cache.execute.PartitionedRegionFunctionExecutor;
import org.apache.geode.internal.cache.execute.PartitionedRegionFunctionResultWaiter;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class PRFunctionStreamingResultCollector
extends FunctionStreamingResultCollector
implements ResultCollector {
    private static final Logger logger = LogService.getLogger();
    private boolean hasResult = false;
    private final PartitionedRegionFunctionResultWaiter waiter;

    public PRFunctionStreamingResultCollector(PartitionedRegionFunctionResultWaiter partitionedRegionFunctionResultWaiter, InternalDistributedSystem system, Set<InternalDistributedMember> members, ResultCollector rc, Function functionObject, PartitionedRegion pr, AbstractExecution execution) {
        super(partitionedRegionFunctionResultWaiter, system, members, rc, functionObject, execution);
        this.waiter = partitionedRegionFunctionResultWaiter;
        this.hasResult = functionObject.hasResult();
    }

    @Override
    public void addResult(DistributedMember memId, Object resultOfSingleExecution) {
        if (!this.endResultRecieved) {
            if (!(this.userRC instanceof LocalResultCollectorImpl) && resultOfSingleExecution instanceof InternalFunctionException) {
                resultOfSingleExecution = ((InternalFunctionException)resultOfSingleExecution).getCause();
            }
            this.userRC.addResult(memId, resultOfSingleExecution);
        }
    }

    @Override
    public Object getResult() throws FunctionException {
        if (this.resultCollected) {
            throw new FunctionException("Result already collected");
        }
        this.resultCollected = true;
        if (this.hasResult) {
            try {
                this.waitForCacheOrFunctionException(0L);
                if (!this.execution.getFailedNodes().isEmpty() && !this.execution.isClientServerMode()) {
                    this.endResults();
                    this.clearResults();
                    this.execution = this.execution.setIsReExecute();
                    ResultCollector newRc = null;
                    newRc = this.execution.isFnSerializationReqd() ? this.execution.execute(this.fn) : this.execution.execute(this.fn.getId());
                    return newRc.getResult();
                }
                if (!this.execution.getWaitOnExceptionFlag() && this.fites.size() > 0) {
                    throw new FunctionException((Throwable)this.fites.get(0));
                }
            }
            catch (FunctionInvocationTargetException fite) {
                if (!this.execution.getWaitOnExceptionFlag()) {
                    if (!this.fn.isHA()) {
                        throw new FunctionException(fite);
                    }
                    if (this.execution.isClientServerMode()) {
                        this.clearResults();
                        InternalFunctionInvocationTargetException iFITE = new InternalFunctionInvocationTargetException(fite.getMessage(), this.execution.getFailedNodes());
                        throw new FunctionException(iFITE);
                    }
                    this.clearResults();
                    this.execution = this.execution.setIsReExecute();
                    ResultCollector newRc = null;
                    newRc = this.execution.isFnSerializationReqd() ? this.execution.execute(this.fn) : this.execution.execute(this.fn.getId());
                    return newRc.getResult();
                }
            }
            catch (BucketMovedException e) {
                if (!this.execution.getWaitOnExceptionFlag()) {
                    if (!this.fn.isHA()) {
                        FunctionInvocationTargetException fite = new FunctionInvocationTargetException(e.getMessage());
                        throw new FunctionException(fite);
                    }
                    if (this.execution.isClientServerMode()) {
                        this.clearResults();
                        InternalFunctionInvocationTargetException fite = new InternalFunctionInvocationTargetException(e.getMessage());
                        throw new FunctionException(fite);
                    }
                    this.clearResults();
                    this.execution = this.execution.setIsReExecute();
                    ResultCollector newRc = null;
                    newRc = this.execution.isFnSerializationReqd() ? this.execution.execute(this.fn) : this.execution.execute(this.fn.getId());
                    return newRc.getResult();
                }
            }
            catch (CacheClosedException e) {
                if (!this.execution.getWaitOnExceptionFlag()) {
                    if (!this.fn.isHA()) {
                        FunctionInvocationTargetException fite = new FunctionInvocationTargetException(e.getMessage());
                        throw new FunctionException(fite);
                    }
                    if (this.execution.isClientServerMode()) {
                        this.clearResults();
                        InternalFunctionInvocationTargetException fite = new InternalFunctionInvocationTargetException(e.getMessage(), this.execution.getFailedNodes());
                        throw new FunctionException(fite);
                    }
                    this.clearResults();
                    this.execution = this.execution.setIsReExecute();
                    ResultCollector newRc = null;
                    newRc = this.execution.isFnSerializationReqd() ? this.execution.execute(this.fn) : this.execution.execute(this.fn.getId());
                    return newRc.getResult();
                }
            }
            catch (CacheException e) {
                throw new FunctionException(e);
            }
            catch (ForceReattemptException e) {
                if (!this.fn.isHA()) {
                    throw new FunctionException(e);
                }
                if (this.execution.isClientServerMode()) {
                    this.clearResults();
                    InternalFunctionInvocationTargetException iFITE = new InternalFunctionInvocationTargetException(e.getMessage(), this.execution.getFailedNodes());
                    throw new FunctionException(iFITE);
                }
                this.clearResults();
                this.execution = this.execution.setIsReExecute();
                ResultCollector newRc = null;
                newRc = this.execution.isFnSerializationReqd() ? this.execution.execute(this.fn) : this.execution.execute(this.fn.getId());
                return newRc.getResult();
            }
        }
        return this.userRC.getResult();
    }

    @Override
    public Object getResult(long timeout, TimeUnit unit) throws FunctionException, InterruptedException {
        long timeoutInMillis = unit.toMillis(timeout);
        if (this.resultCollected) {
            throw new FunctionException("Result already collected");
        }
        this.resultCollected = true;
        if (this.hasResult) {
            try {
                long timeBefore = System.currentTimeMillis();
                if (!this.waitForCacheOrFunctionException(timeoutInMillis)) {
                    throw new FunctionException("All results not recieved in time provided.");
                }
                long timeAfter = System.currentTimeMillis();
                if ((timeoutInMillis -= timeAfter - timeBefore) < 0L) {
                    timeoutInMillis = 0L;
                }
                if (!this.execution.getFailedNodes().isEmpty() && !this.execution.isClientServerMode()) {
                    this.endResults();
                    this.clearResults();
                    this.execution = this.execution.setIsReExecute();
                    ResultCollector newRc = null;
                    newRc = this.execution.isFnSerializationReqd() ? this.execution.execute(this.fn) : this.execution.execute(this.fn.getId());
                    return newRc.getResult(timeoutInMillis, unit);
                }
                if (!this.execution.getWaitOnExceptionFlag() && this.fites.size() > 0) {
                    throw new FunctionException((Throwable)this.fites.get(0));
                }
            }
            catch (FunctionInvocationTargetException fite) {
                if (!this.fn.isHA()) {
                    throw new FunctionException(fite);
                }
                if (this.execution.isClientServerMode()) {
                    this.clearResults();
                    InternalFunctionInvocationTargetException fe = new InternalFunctionInvocationTargetException(fite.getMessage(), this.execution.getFailedNodes());
                    throw new FunctionException(fe);
                }
                this.clearResults();
                this.execution = this.execution.setIsReExecute();
                ResultCollector newRc = null;
                newRc = this.execution.isFnSerializationReqd() ? this.execution.execute(this.fn) : this.execution.execute(this.fn.getId());
                return newRc.getResult(timeoutInMillis, unit);
            }
            catch (BucketMovedException e) {
                if (!this.fn.isHA()) {
                    FunctionInvocationTargetException fite = new FunctionInvocationTargetException(e.getMessage());
                    throw new FunctionException(fite);
                }
                if (this.execution.isClientServerMode()) {
                    this.clearResults();
                    FunctionInvocationTargetException fite = new FunctionInvocationTargetException(e.getMessage());
                    throw new FunctionException(fite);
                }
                this.clearResults();
                this.execution = this.execution.setIsReExecute();
                ResultCollector newRc = null;
                newRc = this.execution.isFnSerializationReqd() ? this.execution.execute(this.fn) : this.execution.execute(this.fn.getId());
                return newRc.getResult(timeoutInMillis, unit);
            }
            catch (CacheClosedException e) {
                if (!this.fn.isHA()) {
                    FunctionInvocationTargetException fite = new FunctionInvocationTargetException(e.getMessage());
                    throw new FunctionException(fite);
                }
                if (this.execution.isClientServerMode()) {
                    this.clearResults();
                    InternalFunctionInvocationTargetException fite = new InternalFunctionInvocationTargetException(e.getMessage(), this.execution.getFailedNodes());
                    throw new FunctionException(fite);
                }
                this.clearResults();
                this.execution = this.execution.setIsReExecute();
                ResultCollector newRc = null;
                newRc = this.execution.isFnSerializationReqd() ? this.execution.execute(this.fn) : this.execution.execute(this.fn.getId());
                return newRc.getResult(timeoutInMillis, unit);
            }
            catch (CacheException e) {
                throw new FunctionException(e);
            }
            catch (ForceReattemptException e) {
                if (!this.fn.isHA()) {
                    throw new FunctionException(e);
                }
                if (this.execution.isClientServerMode()) {
                    this.clearResults();
                    InternalFunctionInvocationTargetException iFITE = new InternalFunctionInvocationTargetException(e.getMessage(), this.execution.getFailedNodes());
                    throw new FunctionException(iFITE);
                }
                this.clearResults();
                this.execution = this.execution.setIsReExecute();
                ResultCollector newRc = null;
                newRc = this.execution.isFnSerializationReqd() ? this.execution.execute(this.fn) : this.execution.execute(this.fn.getId());
                return newRc.getResult();
            }
        }
        return this.userRC.getResult(timeoutInMillis, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void memberDeparted(DistributionManager distributionManager, InternalDistributedMember id, boolean crashed) {
        if (id != null) {
            InternalDistributedMember[] internalDistributedMemberArray = this.members;
            synchronized (this.members) {
                if (this.removeMember(id, true)) {
                    FunctionInvocationTargetException fite;
                    if (!this.fn.isHA()) {
                        fite = new FunctionInvocationTargetException(LocalizedStrings.PartitionMessage_PARTITIONRESPONSE_GOT_MEMBERDEPARTED_EVENT_FOR_0_CRASHED_1.toLocalizedString(id, crashed), id);
                    } else {
                        fite = new InternalFunctionInvocationTargetException(LocalizedStrings.PartitionMessage_PARTITIONRESPONSE_GOT_MEMBERDEPARTED_EVENT_FOR_0_CRASHED_1.toLocalizedString(id, crashed), id);
                        this.execution.addFailedNode(id.getId());
                    }
                    this.fites.add(fite);
                }
                this.checkIfDone();
                // ** MonitorExit[var5_4] (shouldn't be in output)
            }
        } else {
            Exception e = new Exception(LocalizedStrings.PartitionMessage_MEMBERDEPARTED_GOT_NULL_MEMBERID.toLocalizedString());
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.PartitionMessage_MEMBERDEPARTED_GOT_NULL_MEMBERID_CRASHED_0, crashed), (Throwable)e);
        }
    }

    @Override
    protected synchronized void processException(DistributionMessage msg, ReplyException ex) {
        logger.debug("StreamingPartitionResponseWithResultCollector received exception {} from member {}", (Object)ex.getCause(), (Object)msg.getSender());
        if (this.execution.isForwardExceptions() || this.execution.getWaitOnExceptionFlag()) {
            return;
        }
        if (ex.getCause() instanceof CacheClosedException) {
            ((PartitionedRegionFunctionExecutor)this.execution).addFailedNode(msg.getSender().getId());
            this.exception = ex;
        } else if (ex.getCause() instanceof BucketMovedException) {
            this.exception = ex;
        } else if (!this.execution.getWaitOnExceptionFlag()) {
            this.exception = ex;
        }
    }
}

