/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DirectReplyProcessor;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.ReplySender;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.CachedDeserializableFactory;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.partitioned.PRLocallyDestroyedException;
import org.apache.geode.internal.cache.partitioned.PartitionMessage;
import org.apache.geode.internal.cache.partitioned.PartitionMessageWithDirectReply;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.util.BlobHelper;
import org.apache.logging.log4j.Logger;

public class GetMessage
extends PartitionMessageWithDirectReply {
    private static final Logger logger = LogService.getLogger();
    private Object key;
    private Object cbArg;
    private transient boolean forceUseOfPRExecutor;
    private ClientProxyMembershipID context;
    private boolean returnTombstones;
    protected static final int HAS_LOADER = 64;
    protected static final int CAN_START_TX = 128;
    private static final boolean ORDER_PR_GETS = Boolean.getBoolean("gemfire.order-pr-gets");

    public GetMessage() {
    }

    private GetMessage(InternalDistributedMember recipient, int regionId, DirectReplyProcessor processor, Object key, Object aCallbackArgument, ClientProxyMembershipID context, boolean returnTombstones) {
        super(recipient, regionId, processor);
        this.key = key;
        this.cbArg = aCallbackArgument;
        this.context = context;
        this.returnTombstones = returnTombstones;
    }

    @Override
    public int getProcessorType() {
        if (!(this.forceUseOfPRExecutor || ORDER_PR_GETS || this.isDirectAck())) {
            try {
                PartitionedRegion pr = PartitionedRegion.getPRFromId(this.regionId);
                if (pr.getAttributes().getDataPolicy().withPersistence() || !pr.getAttributes().getEvictionAttributes().getAlgorithm().isNone()) {
                    return 78;
                }
            }
            catch (PRLocallyDestroyedException pRLocallyDestroyedException) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        if (this.forceUseOfPRExecutor) {
            return 78;
        }
        if (ORDER_PR_GETS) {
            return 78;
        }
        return 74;
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected boolean operateOnPartitionedRegion(ClusterDistributionManager dm, PartitionedRegion r, long startTime) throws ForceReattemptException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected void appendFields(StringBuilder buff) {
        super.appendFields(buff);
        buff.append("; key=").append(this.key).append("; callback arg=").append(this.cbArg).append("; context=").append(this.context);
    }

    @Override
    public int getDSFID() {
        return 120;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.key = DataSerializer.readObject(in);
        this.cbArg = DataSerializer.readObject(in);
        this.context = (ClientProxyMembershipID)DataSerializer.readObject(in);
        this.returnTombstones = in.readBoolean();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.key, out);
        DataSerializer.writeObject(this.cbArg, out);
        DataSerializer.writeObject(this.context, out);
        out.writeBoolean(this.returnTombstones);
    }

    @Override
    protected short computeCompressedShort(short s) {
        s = super.computeCompressedShort(s);
        return s;
    }

    @Override
    protected void setBooleans(short s, DataInput in) throws ClassNotFoundException, IOException {
        super.setBooleans(s, in);
    }

    public void setKey(Object key) {
        this.key = key;
    }

    public static GetResponse send(InternalDistributedMember recipient, PartitionedRegion r, Object key, Object aCallbackArgument, ClientProxyMembershipID requestingClient, boolean returnTombstones) throws ForceReattemptException {
        Assert.assertTrue(recipient != null, "PRDistribuedGetReplyMessage NULL reply message");
        GetResponse p = new GetResponse(r.getSystem(), Collections.singleton(recipient), key);
        GetMessage m = new GetMessage(recipient, r.getPRId(), p, key, aCallbackArgument, requestingClient, returnTombstones);
        m.setTransactionDistributed(r.getCache().getTxManager().isDistributed());
        Set failures = r.getDistributionManager().putOutgoing(m);
        if (failures != null && failures.size() > 0) {
            throw new ForceReattemptException(LocalizedStrings.GetMessage_FAILED_SENDING_0.toLocalizedString(m));
        }
        return p;
    }

    public static class GetResponse
    extends PartitionMessage.PartitionResponse {
        private volatile GetReplyMessage getReply;
        private volatile boolean returnValueReceived;
        private volatile long start;
        final Object key;
        private VersionTag versionTag;

        public GetResponse(InternalDistributedSystem ds, Set recipients, Object key) {
            super(ds, recipients, false);
            this.key = key;
        }

        @Override
        public void process(DistributionMessage msg) {
            if (DistributionStats.enableClockStats) {
                this.start = DistributionStats.getStatTime();
            }
            if (msg instanceof GetReplyMessage) {
                GetReplyMessage reply = (GetReplyMessage)msg;
                if (reply.valueInBytes != null || reply.valueType == 3 || reply.valueType == 4) {
                    this.getReply = reply;
                }
                this.returnValueReceived = true;
                this.versionTag = reply.versionTag;
            }
            super.process(msg);
        }

        public Object getValue(boolean preferCD) throws ForceReattemptException {
            GetReplyMessage reply = this.getReply;
            try {
                if (reply != null) {
                    switch (reply.valueType) {
                        case 1: {
                            return reply.valueInBytes;
                        }
                        case 3: {
                            return Token.INVALID;
                        }
                        case 4: {
                            return Token.TOMBSTONE;
                        }
                    }
                    if (reply.valueInBytes != null) {
                        if (preferCD) {
                            return CachedDeserializableFactory.create(reply.valueInBytes, this.getDistributionManager().getCache());
                        }
                        return BlobHelper.deserializeBlob(reply.valueInBytes, reply.remoteVersion, null);
                    }
                    return null;
                }
                return null;
            }
            catch (IOException e) {
                throw new ForceReattemptException(LocalizedStrings.GetMessage_UNABLE_TO_DESERIALIZE_VALUE_IOEXCEPTION.toLocalizedString(), e);
            }
            catch (ClassNotFoundException e) {
                throw new ForceReattemptException(LocalizedStrings.GetMessage_UNABLE_TO_DESERIALIZE_VALUE_CLASSNOTFOUNDEXCEPTION.toLocalizedString(), e);
            }
        }

        public VersionTag getVersionTag() {
            return this.versionTag;
        }

        public Object waitForResponse(boolean preferCD) throws ForceReattemptException {
            try {
                this.waitForCacheException();
                if (DistributionStats.enableClockStats) {
                    this.getDistributionManager().getStats().incReplyHandOffTime(this.start);
                }
            }
            catch (ForceReattemptException e) {
                e.checkKey(this.key);
                String msg = "GetResponse got ForceReattemptException; rethrowing";
                logger.debug("GetResponse got ForceReattemptException; rethrowing", (Throwable)e);
                throw e;
            }
            if (!this.returnValueReceived) {
                throw new ForceReattemptException(LocalizedStrings.GetMessage_NO_RETURN_VALUE_RECEIVED.toLocalizedString());
            }
            return this.getValue(preferCD);
        }
    }

    public static class GetReplyMessage
    extends ReplyMessage {
        private transient BucketRegion.RawValue rawVal;
        byte valueType;
        static final byte VALUE_IS_SERIALIZED_OBJECT = 0;
        static final byte VALUE_IS_BYTES = 1;
        static final byte VALUE_IS_INVALID = 3;
        static final byte VALUE_IS_TOMBSTONE = 4;
        static final byte VALUE_HAS_VERSION_TAG = 8;
        public transient byte[] valueInBytes;
        public VersionTag versionTag;
        public transient Version remoteVersion;

        public GetReplyMessage() {
        }

        private GetReplyMessage(int processorId, BucketRegion.RawValue val, VersionTag versionTag) {
            this.setProcessorId(processorId);
            this.rawVal = val;
            Object rval = val.getRawValue();
            this.valueType = rval == Token.TOMBSTONE ? (byte)4 : (Token.isInvalid(rval) ? (byte)3 : (val.isValueByteArray() ? (byte)1 : 0));
            this.versionTag = versionTag;
        }

        @Override
        public boolean getInlineProcess() {
            return true;
        }

        public static void send(InternalDistributedMember recipient, int processorId, BucketRegion.RawValue val, ReplySender replySender, VersionTag versionTag) throws ForceReattemptException {
            Assert.assertTrue(recipient != null, "PRDistribuedGetReplyMessage NULL reply message");
            GetReplyMessage m = new GetReplyMessage(processorId, val, versionTag);
            m.setRecipient(recipient);
            replySender.putOutgoing(m);
        }

        @Override
        public void process(DistributionManager dm, ReplyProcessor21 processor) {
            boolean isDebugEnabled = logger.isTraceEnabled(LogMarker.DM_VERBOSE);
            long startTime = this.getTimestamp();
            if (isDebugEnabled) {
                logger.trace(LogMarker.DM_VERBOSE, "GetReplyMessage process invoking reply processor with processorId: {}", (Object)this.processorId);
            }
            if (processor == null) {
                if (isDebugEnabled) {
                    logger.debug("GetReplyMessage processor not found");
                }
                return;
            }
            if (this.versionTag != null) {
                this.versionTag.replaceNullIDs(this.getSender());
            }
            processor.process(this);
            if (isDebugEnabled) {
                logger.debug("{} Processed {}", (Object)processor, (Object)this);
            }
            dm.getStats().incReplyMessageTime(DistributionStats.getStatTime() - startTime);
        }

        @Override
        public int getDSFID() {
            return 125;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            boolean hasVersionTag = this.versionTag != null;
            byte flags = this.valueType;
            if (hasVersionTag) {
                flags = (byte)(flags | 8);
            }
            out.writeByte(flags);
            if (this.valueType == 1) {
                DataSerializer.writeByteArray((byte[])this.rawVal.getRawValue(), out);
            } else {
                this.rawVal.writeAsByteArray(out);
            }
            if (hasVersionTag) {
                DataSerializer.writeObject(this.versionTag, out);
            }
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            byte flags = in.readByte();
            boolean hasVersionTag = (flags & 8) != 0;
            if (hasVersionTag) {
                flags = (byte)(flags & 0xFFFFFFF7);
            }
            this.valueType = flags;
            this.valueInBytes = DataSerializer.readByteArray(in);
            if (flags != 1) {
                this.remoteVersion = InternalDataSerializer.getVersionForDataStreamOrNull(in);
            }
            if (hasVersionTag) {
                this.versionTag = (VersionTag)DataSerializer.readObject(in);
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("GetReplyMessage ").append("processorid=").append(this.processorId).append(" reply to sender ").append(this.getSender());
            if (this.valueType == 4) {
                sb.append(" returning tombstone token.");
            } else if (this.valueType == 3) {
                sb.append(" returning invalid token.");
            } else if (this.rawVal != null) {
                sb.append(" returning serialized value=").append(this.rawVal);
            } else if (this.valueInBytes == null) {
                sb.append(" returning null value");
            } else {
                sb.append(" returning serialized value of len=").append(this.valueInBytes.length);
            }
            if (this.versionTag != null) {
                sb.append(" version=").append(this.versionTag);
            }
            return sb.toString();
        }
    }
}

