/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.eviction;

import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.EvictionAlgorithm;
import org.apache.geode.cache.util.ObjectSizer;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.eviction.EvictionCounters;
import org.apache.geode.internal.cache.eviction.SizeLRUController;
import org.apache.geode.internal.cache.persistence.DiskRegionView;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class MemoryLRUController
extends SizeLRUController {
    private long limit;
    private final boolean isOffHeap;
    private static final long ONE_MEG = 0x100000L;

    public MemoryLRUController(EvictionCounters evictionCounters, int megabytes, ObjectSizer sizer, EvictionAction evictionAction, boolean isOffHeap, EvictionAlgorithm algorithm) {
        super(evictionCounters, evictionAction, sizer, algorithm);
        this.isOffHeap = isOffHeap;
        this.setMaximumMegabytes(megabytes);
    }

    private void setMaximumMegabytes(int megabytes) {
        if (megabytes <= 0) {
            throw new IllegalArgumentException(LocalizedStrings.MemLRUCapacityController_MEMLRUCONTROLLER_LIMIT_MUST_BE_POSTIVE_0.toLocalizedString(megabytes));
        }
        this.limit = (long)megabytes * 0x100000L;
        this.getCounters().setLimit(this.limit);
    }

    @Override
    public void setLimit(int maximum) {
        this.setMaximumMegabytes(maximum);
    }

    @Override
    public long getLimit() {
        return this.limit;
    }

    @Override
    public int entrySize(Object key, Object value) {
        if (value == Token.TOMBSTONE) {
            return 0;
        }
        int size = 0;
        int keySize = 0;
        if (!this.isOffHeap) {
            size += this.getPerEntryOverhead();
            keySize = this.sizeof(key);
        }
        int valueSize = this.sizeof(value);
        size += keySize;
        return size += valueSize;
    }

    @Override
    public boolean mustEvict(EvictionCounters counters, InternalRegion region, int delta) {
        return counters.getCounter() + (long)delta > counters.getLimit();
    }

    @Override
    public boolean lruLimitExceeded(EvictionCounters counters, DiskRegionView diskRegionView) {
        return counters.getCounter() > counters.getLimit();
    }

    @Override
    public String toString() {
        return "MemLRUCapacityController with a capacity of " + this.getLimit() + " megabytes and and eviction action " + this.getEvictionAction();
    }
}

