/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.entries;

import java.util.UUID;
import org.apache.geode.internal.cache.InlineKeyHelper;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.RegionEntryFactory;
import org.apache.geode.internal.cache.entries.VersionedThinRegionEntry;
import org.apache.geode.internal.cache.entries.VersionedThinRegionEntryHeapIntKey;
import org.apache.geode.internal.cache.entries.VersionedThinRegionEntryHeapLongKey;
import org.apache.geode.internal.cache.entries.VersionedThinRegionEntryHeapObjectKey;
import org.apache.geode.internal.cache.entries.VersionedThinRegionEntryHeapStringKey1;
import org.apache.geode.internal.cache.entries.VersionedThinRegionEntryHeapStringKey2;
import org.apache.geode.internal.cache.entries.VersionedThinRegionEntryHeapUUIDKey;

public abstract class VersionedThinRegionEntryHeap
extends VersionedThinRegionEntry {
    private static final VersionedThinRegionEntryHeapFactory factory = new VersionedThinRegionEntryHeapFactory();

    public VersionedThinRegionEntryHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VersionedThinRegionEntryHeapFactory
    implements RegionEntryFactory {
        private VersionedThinRegionEntryHeapFactory() {
        }

        @Override
        public RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VersionedThinRegionEntryHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VersionedThinRegionEntryHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VersionedThinRegionEntryHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VersionedThinRegionEntryHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VersionedThinRegionEntryHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VersionedThinRegionEntryHeapObjectKey(context, key, value);
        }

        @Override
        public Class getEntryClass() {
            return VersionedThinRegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return this;
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return this;
        }
    }
}

