/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.entries;

import java.util.UUID;
import org.apache.geode.internal.cache.InlineKeyHelper;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.RegionEntryFactory;
import org.apache.geode.internal.cache.entries.VersionedStatsLRURegionEntry;
import org.apache.geode.internal.cache.entries.VersionedStatsLRURegionEntryHeapIntKey;
import org.apache.geode.internal.cache.entries.VersionedStatsLRURegionEntryHeapLongKey;
import org.apache.geode.internal.cache.entries.VersionedStatsLRURegionEntryHeapObjectKey;
import org.apache.geode.internal.cache.entries.VersionedStatsLRURegionEntryHeapStringKey1;
import org.apache.geode.internal.cache.entries.VersionedStatsLRURegionEntryHeapStringKey2;
import org.apache.geode.internal.cache.entries.VersionedStatsLRURegionEntryHeapUUIDKey;

public abstract class VersionedStatsLRURegionEntryHeap
extends VersionedStatsLRURegionEntry {
    private static final VersionedStatsLRURegionEntryHeapFactory factory = new VersionedStatsLRURegionEntryHeapFactory();

    public VersionedStatsLRURegionEntryHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VersionedStatsLRURegionEntryHeapFactory
    implements RegionEntryFactory {
        private VersionedStatsLRURegionEntryHeapFactory() {
        }

        @Override
        public RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VersionedStatsLRURegionEntryHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VersionedStatsLRURegionEntryHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VersionedStatsLRURegionEntryHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VersionedStatsLRURegionEntryHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VersionedStatsLRURegionEntryHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VersionedStatsLRURegionEntryHeapObjectKey(context, key, value);
        }

        @Override
        public Class getEntryClass() {
            return VersionedStatsLRURegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return this;
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return this;
        }
    }
}

