/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.entries;

import java.util.UUID;
import org.apache.geode.internal.cache.InlineKeyHelper;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.RegionEntryFactory;
import org.apache.geode.internal.cache.entries.VersionedStatsDiskLRURegionEntry;
import org.apache.geode.internal.cache.entries.VersionedStatsDiskLRURegionEntryHeapIntKey;
import org.apache.geode.internal.cache.entries.VersionedStatsDiskLRURegionEntryHeapLongKey;
import org.apache.geode.internal.cache.entries.VersionedStatsDiskLRURegionEntryHeapObjectKey;
import org.apache.geode.internal.cache.entries.VersionedStatsDiskLRURegionEntryHeapStringKey1;
import org.apache.geode.internal.cache.entries.VersionedStatsDiskLRURegionEntryHeapStringKey2;
import org.apache.geode.internal.cache.entries.VersionedStatsDiskLRURegionEntryHeapUUIDKey;

public abstract class VersionedStatsDiskLRURegionEntryHeap
extends VersionedStatsDiskLRURegionEntry {
    private static final VersionedStatsDiskLRURegionEntryHeapFactory factory = new VersionedStatsDiskLRURegionEntryHeapFactory();

    public VersionedStatsDiskLRURegionEntryHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VersionedStatsDiskLRURegionEntryHeapFactory
    implements RegionEntryFactory {
        private VersionedStatsDiskLRURegionEntryHeapFactory() {
        }

        @Override
        public RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VersionedStatsDiskLRURegionEntryHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VersionedStatsDiskLRURegionEntryHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VersionedStatsDiskLRURegionEntryHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VersionedStatsDiskLRURegionEntryHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VersionedStatsDiskLRURegionEntryHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VersionedStatsDiskLRURegionEntryHeapObjectKey(context, key, value);
        }

        @Override
        public Class getEntryClass() {
            return VersionedStatsDiskLRURegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return this;
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return this;
        }
    }
}

