/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.client.protocol;

import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.geode.internal.cache.client.protocol.ClientProtocolService;
import org.apache.geode.internal.cache.client.protocol.exception.ServiceLoadingFailureException;

public class ClientProtocolServiceLoader {
    private final List<ClientProtocolService> clientProtocolServices = ClientProtocolServiceLoader.initializeProtocolServices();

    private static List<ClientProtocolService> initializeProtocolServices() {
        LinkedList<ClientProtocolService> resultList = new LinkedList<ClientProtocolService>();
        for (ClientProtocolService clientProtocolService : ServiceLoader.load(ClientProtocolService.class)) {
            resultList.add(clientProtocolService);
        }
        return resultList;
    }

    public ClientProtocolService lookupService() {
        if (this.clientProtocolServices.isEmpty()) {
            throw new ServiceLoadingFailureException("There is no ClientProtocolService implementation found in JVM");
        }
        if (this.clientProtocolServices.size() > 1) {
            throw new ServiceLoadingFailureException("There is more than one ClientProtocolService implementation found in JVM; aborting");
        }
        ClientProtocolService clientProtocolService = this.clientProtocolServices.get(0);
        return clientProtocolService;
    }
}

