/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.backup;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.cache.persistence.PersistentID;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.MembershipListener;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.Oplog;
import org.apache.geode.internal.cache.backup.BackupTask;
import org.apache.geode.internal.cache.backup.BackupWriter;
import org.apache.geode.internal.cache.backup.DiskStoreBackup;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LoggingThreadGroup;
import org.apache.logging.log4j.Logger;

public class BackupService {
    private static final Logger logger = LogService.getLogger();
    public static final String DATA_STORES_TEMPORARY_DIRECTORY = "backupTemp_";
    private final ExecutorService executor;
    private final MembershipListener membershipListener = new BackupMembershipListener();
    private final InternalCache cache;
    private transient Future<HashSet<PersistentID>> taskFuture;
    final AtomicReference<BackupTask> currentTask = new AtomicReference();

    public BackupService(InternalCache cache) {
        this.cache = cache;
        this.executor = this.createExecutor();
    }

    private ExecutorService createExecutor() {
        final LoggingThreadGroup group = LoggingThreadGroup.createThreadGroup("BackupService Thread", logger);
        ThreadFactory threadFactory = new ThreadFactory(){
            private final AtomicInteger threadId = new AtomicInteger();

            @Override
            public Thread newThread(Runnable command) {
                Thread thread = new Thread(group, command, "BackupServiceThread" + this.threadId.incrementAndGet());
                thread.setDaemon(true);
                return thread;
            }
        };
        return Executors.newSingleThreadExecutor(threadFactory);
    }

    public HashSet<PersistentID> prepareBackup(InternalDistributedMember sender, BackupWriter writer) throws IOException, InterruptedException {
        this.validateRequestingAdmin(sender);
        BackupTask backupTask = new BackupTask(this.cache, writer);
        if (!this.currentTask.compareAndSet(null, backupTask)) {
            throw new IOException("Another backup already in progress");
        }
        this.taskFuture = this.executor.submit(() -> backupTask.backup());
        return backupTask.getPreparedDiskStores();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<PersistentID> doBackup() throws IOException {
        HashSet<PersistentID> result;
        BackupTask task = this.currentTask.get();
        if (task == null) {
            throw new IOException("No backup currently in progress");
        }
        task.notifyOtherMembersReady();
        try {
            result = this.taskFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            result = new HashSet();
        }
        finally {
            this.cleanup();
        }
        return result;
    }

    public void waitForBackup() {
        BackupTask task = this.currentTask.get();
        if (task != null) {
            task.waitTillBackupFilesAreCopiedToTemporaryLocation();
        }
    }

    public DiskStoreBackup getBackupForDiskStore(DiskStoreImpl diskStore) {
        BackupTask task = this.currentTask.get();
        return task == null ? null : task.getBackupForDiskStore(diskStore);
    }

    void validateRequestingAdmin(InternalDistributedMember sender) {
        Set allIds = this.cache.getDistributionManager().addAllMembershipListenerAndGetAllIds(this.membershipListener);
        if (!allIds.contains(sender)) {
            this.cleanup();
            throw new IllegalStateException("The admin member requesting a backup has already departed");
        }
    }

    public boolean deferDrfDelete(DiskStoreImpl diskStore, Oplog oplog) {
        DiskStoreBackup diskStoreBackup = this.getBackupForDiskStore(diskStore);
        if (diskStoreBackup != null) {
            return diskStoreBackup.deferDrfDelete(oplog);
        }
        return false;
    }

    public boolean deferCrfDelete(DiskStoreImpl diskStore, Oplog oplog) {
        DiskStoreBackup diskStoreBackup = this.getBackupForDiskStore(diskStore);
        if (diskStoreBackup != null) {
            return diskStoreBackup.deferCrfDelete(oplog);
        }
        return false;
    }

    void cleanup() {
        this.cache.getDistributionManager().removeAllMembershipListener(this.membershipListener);
        this.currentTask.set(null);
    }

    public void abortBackup() {
        BackupTask task = this.currentTask.get();
        this.cleanup();
        if (task != null) {
            task.abort();
        }
    }

    private class BackupMembershipListener
    implements MembershipListener {
        private BackupMembershipListener() {
        }

        @Override
        public void memberDeparted(DistributionManager distributionManager, InternalDistributedMember id, boolean crashed) {
            BackupService.this.cleanup();
        }

        @Override
        public void memberJoined(DistributionManager distributionManager, InternalDistributedMember id) {
        }

        @Override
        public void quorumLost(DistributionManager distributionManager, Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
        }

        @Override
        public void memberSuspect(DistributionManager distributionManager, InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
        }
    }
}

