/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.backup;

import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.geode.cache.persistence.PersistentID;
import org.apache.geode.distributed.DistributedLockService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.backup.AbortBackupFactory;
import org.apache.geode.internal.cache.backup.AbortBackupOperation;
import org.apache.geode.internal.cache.backup.BackupDataStoreResult;
import org.apache.geode.internal.cache.backup.FinishBackupFactory;
import org.apache.geode.internal.cache.backup.FinishBackupOperation;
import org.apache.geode.internal.cache.backup.FlushToDiskFactory;
import org.apache.geode.internal.cache.backup.FlushToDiskOperation;
import org.apache.geode.internal.cache.backup.PrepareBackupFactory;
import org.apache.geode.internal.cache.backup.PrepareBackupOperation;

public class BackupDataStoreHelper {
    public static final String LOCK_SERVICE_NAME = BackupDataStoreHelper.class.getSimpleName();
    private static final String LOCK_NAME = LOCK_SERVICE_NAME + "_token";
    private static final Object LOCK_SYNC = new Object();
    private static final FlushToDiskFactory flushToDiskFactory = new FlushToDiskFactory();
    private static final PrepareBackupFactory prepareBackupFactory = new PrepareBackupFactory();
    private static final AbortBackupFactory abortBackupFactory = new AbortBackupFactory();
    private static final FinishBackupFactory finishBackupFactory = new FinishBackupFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BackupDataStoreResult backupAllMembers(DistributionManager dm, Set recipients, Properties properties) {
        Map<DistributedMember, Set<PersistentID>> successfulMembers;
        Map<DistributedMember, Set<PersistentID>> existingDataStores;
        new FlushToDiskOperation(dm, dm.getId(), dm.getCache(), recipients, flushToDiskFactory).send();
        boolean abort = true;
        try {
            existingDataStores = new PrepareBackupOperation(dm, dm.getId(), dm.getCache(), recipients, prepareBackupFactory, properties).send();
            abort = false;
        }
        finally {
            if (abort) {
                new AbortBackupOperation(dm, dm.getId(), dm.getCache(), recipients, abortBackupFactory).send();
                successfulMembers = Collections.emptyMap();
            } else {
                successfulMembers = new FinishBackupOperation(dm, dm.getId(), dm.getCache(), recipients, finishBackupFactory).send();
            }
        }
        return new BackupDataStoreResult(existingDataStores, successfulMembers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DistributedLockService getLockService(DistributionManager dm) {
        DistributedLockService dls = DistributedLockService.getServiceNamed(LOCK_SERVICE_NAME);
        if (dls == null) {
            Object object = LOCK_SYNC;
            synchronized (object) {
                dls = DistributedLockService.getServiceNamed(LOCK_SERVICE_NAME);
                if (dls == null) {
                    dls = DistributedLockService.create(LOCK_SERVICE_NAME, dm.getSystem());
                }
            }
        }
        Assert.assertTrue(dls != null);
        return dls;
    }

    public static boolean obtainLock(DistributionManager dm) {
        return BackupDataStoreHelper.getLockService(dm).lock(LOCK_NAME, 0L, -1L);
    }

    public static void releaseLock(DistributionManager dm) {
        BackupDataStoreHelper.getLockService(dm).unlock(LOCK_NAME);
    }
}

