/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.SerialDistributionMessage;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class StateFlushOperation {
    private static final Logger logger = LogService.getLogger();
    private DistributedRegion region;
    private DistributionManager dm;

    public static void flushTo(Set<InternalDistributedMember> targets, DistributedRegion region) {
        DistributionManager dm = region.getDistributionManager();
        boolean initialized = region.isInitialized();
        if (initialized) {
            region.getDistributionAdvisor().forceNewMembershipVersion();
            try {
                region.getDistributionAdvisor().waitForCurrentOperations();
            }
            catch (RegionDestroyedException ignore) {
                return;
            }
        }
        HashSet<ReplyProcessor21> processors = new HashSet<ReplyProcessor21>();
        for (InternalDistributedMember target : targets) {
            StateStabilizationMessage gr = new StateStabilizationMessage();
            gr.isSingleFlushTo = true;
            gr.requestingMember = dm.getDistributionManagerId();
            gr.setRecipient(target);
            ReplyProcessor21 processor = new ReplyProcessor21(dm, target);
            gr.processorId = processor.getProcessorId();
            gr.channelState = dm.getMembershipManager().getMessageState(target, false);
            if (logger.isTraceEnabled(LogMarker.STATE_FLUSH_OP_VERBOSE) && gr.channelState != null && gr.channelState.size() > 0) {
                logger.trace(LogMarker.STATE_FLUSH_OP_VERBOSE, "channel states: {}", (Object)gr.channelStateDescription(gr.channelState));
            }
            if (logger.isTraceEnabled(LogMarker.STATE_FLUSH_OP_VERBOSE)) {
                logger.trace(LogMarker.STATE_FLUSH_OP_VERBOSE, "Sending {}", (Object)gr);
            }
            dm.putOutgoing(gr);
            processors.add(processor);
        }
        if (region.getRegionMap().getARMLockTestHook() != null) {
            region.getRegionMap().getARMLockTestHook().beforeStateFlushWait();
        }
        for (ReplyProcessor21 processor : processors) {
            try {
                processor.waitForReplies();
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    public StateFlushOperation(DistributedRegion r) {
        this.region = r;
        this.dm = r.getDistributionManager();
    }

    public StateFlushOperation(DistributionManager dm) {
        this.dm = dm;
    }

    public boolean flush(Set recipients, DistributedMember target, int processorType, boolean flushNewOps) throws InterruptedException {
        Set failures;
        HashSet<DistributedMember> recips = recipients;
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        InternalDistributedMember myId = this.dm.getDistributionManagerId();
        if (!recips.contains(target) && !myId.equals(target)) {
            recips = new HashSet<DistributedMember>(recipients);
            recips.add(target);
        }
        StateMarkerMessage smm = new StateMarkerMessage();
        smm.relayRecipient = target;
        smm.processorType = processorType;
        smm.flushNewOps = flushNewOps;
        if (this.region == null) {
            smm.allRegions = true;
        } else {
            smm.regionPath = this.region.getFullPath();
        }
        smm.setRecipients(recips);
        StateFlushReplyProcessor gfprocessor = new StateFlushReplyProcessor(this.dm, recips, target);
        smm.processorId = gfprocessor.getProcessorId();
        if (this.region != null && this.region.isUsedForPartitionedRegionBucket() && this.region.getDistributionConfig().getAckSevereAlertThreshold() > 0) {
            smm.severeAlertEnabled = true;
            gfprocessor.enableSevereAlertProcessing();
        }
        if (logger.isTraceEnabled(LogMarker.STATE_FLUSH_OP_VERBOSE)) {
            logger.trace(LogMarker.STATE_FLUSH_OP_VERBOSE, "Sending {} with processor {}", (Object)smm, (Object)gfprocessor);
        }
        if ((failures = this.dm.putOutgoing(smm)) != null) {
            if (failures.contains(target)) {
                if (logger.isTraceEnabled(LogMarker.STATE_FLUSH_OP_VERBOSE)) {
                    logger.trace(LogMarker.STATE_FLUSH_OP_VERBOSE, "failed to send StateMarkerMessage to target {}; returning from flush without waiting for replies", (Object)target);
                }
                return false;
            }
            gfprocessor.messageNotSentTo(failures);
        }
        try {
            gfprocessor.waitForReplies();
            if (logger.isTraceEnabled(LogMarker.STATE_FLUSH_OP_VERBOSE)) {
                logger.trace(LogMarker.STATE_FLUSH_OP_VERBOSE, "Finished processing {}", (Object)smm);
            }
        }
        catch (ReplyException re) {
            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.StateFlushOperation_STATE_FLUSH_TERMINATED_WITH_EXCEPTION), (Throwable)re);
            return false;
        }
        return true;
    }

    public static class StateFlushReplyProcessor
    extends ReplyProcessor21 {
        InternalDistributedMember targetMember;
        int originalCount;
        boolean targetMemberHasLeft;

        public StateFlushReplyProcessor(DistributionManager manager, Set initMembers, DistributedMember target) {
            super(manager, (Collection)initMembers);
            this.targetMember = (InternalDistributedMember)target;
            this.originalCount = initMembers.size();
            this.targetMemberHasLeft = this.targetMemberHasLeft || !manager.isCurrentMember((InternalDistributedMember)target);
        }

        public void messageNotSentTo(Set failures) {
            Iterator it = failures.iterator();
            while (it.hasNext()) {
                this.memberDeparted(null, (InternalDistributedMember)it.next(), true);
            }
        }

        @Override
        public void memberDeparted(DistributionManager distributionManager, InternalDistributedMember id, boolean crashed) {
            super.memberDeparted(distributionManager, id, crashed);
        }

        @Override
        protected void processActiveMembers(Set activeMembers) {
            super.processActiveMembers(activeMembers);
            if (!activeMembers.contains(this.targetMember)) {
                this.targetMemberHasLeft = true;
            }
        }

        @Override
        protected boolean stillWaiting() {
            this.targetMemberHasLeft = this.targetMemberHasLeft || !this.getDistributionManager().isCurrentMember(this.targetMember);
            return super.stillWaiting() && !this.targetMemberHasLeft;
        }

        @Override
        public String toString() {
            return "<" + this.shortName() + " " + this.getProcessorId() + " targeting " + this.targetMember + " waiting for " + this.numMembers() + " replies out of " + this.originalCount + " " + (this.exception == null ? "" : " exception: " + this.exception) + " from " + this.membersToString() + ">";
        }
    }

    public static class StateStabilizedMessage
    extends ReplyMessage {
        protected DistributedMember sendingMember;

        @Override
        public InternalDistributedMember getSender() {
            return (InternalDistributedMember)this.sendingMember;
        }

        @Override
        public void process(DistributionManager dm, ReplyProcessor21 processor) {
            if (logger.isTraceEnabled(LogMarker.STATE_FLUSH_OP_VERBOSE)) {
                logger.trace(LogMarker.STATE_FLUSH_OP_VERBOSE, "Processing {}", (Object)this);
            }
            super.process(dm, processor);
        }

        @Override
        public void toData(DataOutput dout) throws IOException {
            super.toData(dout);
            DataSerializer.writeObject(this.sendingMember, dout);
        }

        @Override
        public int getDSFID() {
            return -78;
        }

        @Override
        public void fromData(DataInput din) throws IOException, ClassNotFoundException {
            super.fromData(din);
            this.sendingMember = (DistributedMember)DataSerializer.readObject(din);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("StateStabilizedMessage ");
            sb.append(this.processorId);
            if (super.getSender() != null) {
                sb.append(" from ");
                sb.append(super.getSender());
            }
            if (this.getRecipients().length > 0) {
                String recip = this.getRecipientsDescription();
                sb.append(" to ");
                sb.append(recip);
            }
            sb.append(" on behalf of ");
            sb.append(this.sendingMember);
            ReplyException ex = this.getException();
            if (ex != null) {
                sb.append(" with exception ");
                sb.append(ex);
            }
            return sb.toString();
        }
    }

    public static class StateStabilizationMessage
    extends SerialDistributionMessage {
        protected DistributedMember requestingMember;
        protected int processorId;
        protected Map channelState;
        protected boolean isSingleFlushTo;

        public String channelStateDescription(Object state) {
            if (!(state instanceof Map)) {
                return "unknown channelState content";
            }
            Map csmap = (Map)state;
            StringBuilder result = new StringBuilder(200);
            Iterator it = csmap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                result.append(entry.getKey()).append('=').append(entry.getValue());
                if (!it.hasNext()) continue;
                result.append(", ");
            }
            return result.toString();
        }

        @Override
        protected void process(final ClusterDistributionManager dm) {
            dm.getWaitingThreadPool().execute(new Runnable(){

                /*
                 * Exception decompiling
                 */
                @Override
                public void run() {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            });
        }

        @Override
        public void toData(DataOutput dout) throws IOException {
            super.toData(dout);
            dout.writeInt(this.processorId);
            DataSerializer.writeHashMap(this.channelState, dout);
            DataSerializer.writeObject(this.requestingMember, dout);
            dout.writeBoolean(this.isSingleFlushTo);
        }

        @Override
        public int getDSFID() {
            return -79;
        }

        @Override
        public void fromData(DataInput din) throws IOException, ClassNotFoundException {
            super.fromData(din);
            this.processorId = din.readInt();
            this.channelState = DataSerializer.readHashMap(din);
            this.requestingMember = (DistributedMember)DataSerializer.readObject(din);
            this.isSingleFlushTo = din.readBoolean();
        }

        @Override
        public String toString() {
            return "StateStabilizationMessage(recipients=" + this.getRecipientsDescription() + ",requestingMember=" + this.requestingMember + ",processorId=" + this.processorId + ")";
        }
    }

    public static class StateMarkerMessage
    extends DistributionMessage
    implements MessageWithReply {
        public boolean flushNewOps;
        protected DistributedMember relayRecipient;
        protected int processorId;
        protected int processorType;
        protected String regionPath;
        protected DistributedRegion region;
        protected transient boolean severeAlertEnabled;
        protected boolean allRegions;

        @Override
        public int getProcessorId() {
            return this.processorId;
        }

        @Override
        public int getProcessorType() {
            return this.processorType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DistributedRegion getRegion(ClusterDistributionManager dm) {
            if (this.region != null) {
                return this.region;
            }
            int oldLevel = LocalRegion.setThreadInitLevelRequirement(1);
            try {
                InternalCache gfc = dm.getExistingCache();
                InternalRegion r = gfc.getRegionByPathForProcessing(this.regionPath);
                if (r instanceof DistributedRegion) {
                    this.region = (DistributedRegion)r;
                }
            }
            finally {
                LocalRegion.setThreadInitLevelRequirement(oldLevel);
            }
            return this.region;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<DistributedRegion> getAllRegions(ClusterDistributionManager dm) {
            int oldLevel = LocalRegion.setThreadInitLevelRequirement(1);
            try {
                InternalCache cache = dm.getExistingCache();
                HashSet<DistributedRegion> result = new HashSet<DistributedRegion>();
                for (InternalRegion r : cache.getAllRegions()) {
                    if (!(r instanceof DistributedRegion) || ((LocalRegion)r).isDestroyed) continue;
                    result.add((DistributedRegion)r);
                }
                HashSet<DistributedRegion> hashSet = result;
                return hashSet;
            }
            finally {
                LocalRegion.setThreadInitLevelRequirement(oldLevel);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void process(ClusterDistributionManager dm) {
            block21: {
                block22: {
                    logger.trace(LogMarker.STATE_FLUSH_OP_VERBOSE, "Processing {}", (Object)this);
                    if (!dm.getDistributionManagerId().equals(this.relayRecipient)) break block22;
                    try {
                        Set<DistributedRegion> regions = this.getRegions(dm);
                        for (DistributedRegion r : regions) {
                            if (r == null || this.allRegions && r.doesNotDistribute()) continue;
                            this.waitForCurrentOperations(r, r.isInitialized());
                        }
                    }
                    catch (CancelException ga) {
                        StateStabilizedMessage ga2 = new StateStabilizedMessage();
                        ga2.sendingMember = this.relayRecipient;
                        ga2.setRecipient(this.getSender());
                        ga2.setProcessorId(this.processorId);
                        if (logger.isTraceEnabled(LogMarker.STATE_FLUSH_OP_VERBOSE)) {
                            logger.trace(LogMarker.STATE_FLUSH_OP_VERBOSE, "Sending {}", (Object)ga2);
                        }
                        dm.putOutgoing(ga2);
                        break block21;
                    }
                    catch (Exception e) {
                        StateStabilizedMessage ga;
                        try {
                            logger.fatal((Message)LocalizedMessage.create(LocalizedStrings.StateFlushOperation_0__EXCEPTION_CAUGHT_WHILE_DETERMINING_CHANNEL_STATE, this), (Throwable)e);
                            ga = new StateStabilizedMessage();
                            ga.sendingMember = this.relayRecipient;
                        }
                        catch (Throwable throwable) {
                            StateStabilizedMessage ga3 = new StateStabilizedMessage();
                            ga3.sendingMember = this.relayRecipient;
                            ga3.setRecipient(this.getSender());
                            ga3.setProcessorId(this.processorId);
                            if (logger.isTraceEnabled(LogMarker.STATE_FLUSH_OP_VERBOSE)) {
                                logger.trace(LogMarker.STATE_FLUSH_OP_VERBOSE, "Sending {}", (Object)ga3);
                            }
                            dm.putOutgoing(ga3);
                            throw throwable;
                        }
                        ga.setRecipient(this.getSender());
                        ga.setProcessorId(this.processorId);
                        if (logger.isTraceEnabled(LogMarker.STATE_FLUSH_OP_VERBOSE)) {
                            logger.trace(LogMarker.STATE_FLUSH_OP_VERBOSE, "Sending {}", (Object)ga);
                        }
                        dm.putOutgoing(ga);
                        break block21;
                    }
                    StateStabilizedMessage ga = new StateStabilizedMessage();
                    ga.sendingMember = this.relayRecipient;
                    ga.setRecipient(this.getSender());
                    ga.setProcessorId(this.processorId);
                    if (logger.isTraceEnabled(LogMarker.STATE_FLUSH_OP_VERBOSE)) {
                        logger.trace(LogMarker.STATE_FLUSH_OP_VERBOSE, "Sending {}", (Object)ga);
                    }
                    dm.putOutgoing(ga);
                    break block21;
                }
                StateStabilizationMessage gr = new StateStabilizationMessage();
                gr.setRecipient((InternalDistributedMember)this.relayRecipient);
                gr.requestingMember = this.getSender();
                gr.processorId = this.processorId;
                try {
                    Set<DistributedRegion> regions = this.getRegions(dm);
                    for (DistributedRegion r : regions) {
                        boolean useMulticast;
                        if (r == null && logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                            logger.trace(LogMarker.DM_VERBOSE, "Region not found - skipping channel state assessment");
                        }
                        if (r == null || this.allRegions && r.doesNotDistribute()) continue;
                        boolean initialized = r.isInitialized();
                        this.waitForCurrentOperations(r, initialized);
                        boolean bl = useMulticast = r.getMulticastEnabled() && r.getSystem().getConfig().getMcastPort() != 0;
                        if (!initialized) continue;
                        Map channelStates = dm.getMembershipManager().getMessageState(this.relayRecipient, useMulticast);
                        if (gr.channelState != null) {
                            gr.channelState.putAll(channelStates);
                        } else {
                            gr.channelState = channelStates;
                        }
                        if (!logger.isTraceEnabled(LogMarker.STATE_FLUSH_OP_VERBOSE) || gr.channelState == null || gr.channelState.size() <= 0) continue;
                        logger.trace(LogMarker.STATE_FLUSH_OP_VERBOSE, "channel states: {}", (Object)gr.channelStateDescription(gr.channelState));
                    }
                }
                catch (CancelException regions) {
                }
                catch (Exception e) {
                    logger.fatal((Message)LocalizedMessage.create(LocalizedStrings.StateFlushOperation_0__EXCEPTION_CAUGHT_WHILE_DETERMINING_CHANNEL_STATE, this), (Throwable)e);
                }
                finally {
                    if (logger.isTraceEnabled(LogMarker.STATE_FLUSH_OP_VERBOSE)) {
                        logger.trace(LogMarker.STATE_FLUSH_OP_VERBOSE, "Sending {}", (Object)gr);
                    }
                    dm.putOutgoing(gr);
                }
            }
        }

        private void waitForCurrentOperations(DistributedRegion r, boolean initialized) {
            if (initialized) {
                if (this.flushNewOps) {
                    r.getDistributionAdvisor().forceNewMembershipVersion();
                }
                try {
                    r.getDistributionAdvisor().waitForCurrentOperations();
                }
                catch (RegionDestroyedException regionDestroyedException) {
                    // empty catch block
                }
            }
        }

        private Set<DistributedRegion> getRegions(ClusterDistributionManager dm) {
            Set<DistributedRegion> regions = this.allRegions ? this.getAllRegions(dm) : Collections.singleton(this.getRegion(dm));
            return regions;
        }

        @Override
        public void toData(DataOutput dout) throws IOException {
            super.toData(dout);
            DataSerializer.writeObject(this.relayRecipient, dout);
            dout.writeInt(this.processorId);
            dout.writeInt(this.processorType);
            dout.writeBoolean(this.allRegions);
            if (!this.allRegions) {
                DataSerializer.writeString(this.regionPath, dout);
            }
        }

        @Override
        public int getDSFID() {
            return -80;
        }

        @Override
        public void fromData(DataInput din) throws IOException, ClassNotFoundException {
            super.fromData(din);
            this.relayRecipient = (DistributedMember)DataSerializer.readObject(din);
            this.processorId = din.readInt();
            this.processorType = din.readInt();
            this.allRegions = din.readBoolean();
            if (!this.allRegions) {
                this.regionPath = DataSerializer.readString(din);
            }
        }

        @Override
        public String toString() {
            return "StateMarkerMessage(requestingMember=" + this.getSender() + ",processorId=" + this.processorId + ",target=" + this.relayRecipient + ",region=" + this.regionPath + ")";
        }

        @Override
        public boolean isSevereAlertCompatible() {
            return this.severeAlertEnabled;
        }
    }
}

