/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionEvent;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.DSFIDFactory;
import org.apache.geode.internal.DataSerializableFixedID;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.EnumListenerEvent;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.FilterRoutingInfo;
import org.apache.geode.internal.cache.InternalCacheEvent;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.WrappedCallbackArgument;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class RegionEventImpl
implements RegionEvent,
InternalCacheEvent,
Cloneable,
DataSerializableFixedID {
    transient LocalRegion region;
    String regionPath;
    Object callbackArgument = null;
    boolean originRemote = false;
    Operation op;
    DistributedMember distributedMember;
    private EventID eventId = null;
    private EnumListenerEvent eventType;
    private FilterRoutingInfo.FilterInfo filterInfo;
    private VersionTag<?> versionTag;

    public RegionEventImpl() {
    }

    public RegionEventImpl(Region region, Operation op, Object callbackArgument, boolean originRemote, DistributedMember distributedMember) {
        this(region, op, callbackArgument, originRemote, distributedMember, false);
    }

    public RegionEventImpl(Region region, Operation op, Object callbackArgument, boolean originRemote, DistributedMember distributedMember, boolean generateEventID) {
        this.region = (LocalRegion)region;
        this.regionPath = region.getFullPath();
        this.op = op;
        this.callbackArgument = callbackArgument;
        this.originRemote = originRemote;
        this.distributedMember = distributedMember;
        DistributedSystem sys = ((LocalRegion)region).getCache().getDistributedSystem();
        if (generateEventID) {
            this.eventId = new EventID(sys);
        }
    }

    public RegionEventImpl(Region region, Operation op, Object callbackArgument, boolean originRemote, DistributedMember distributedMember, EventID eventID) {
        this.region = (LocalRegion)region;
        this.regionPath = region.getFullPath();
        this.op = op;
        this.callbackArgument = callbackArgument;
        this.originRemote = originRemote;
        this.distributedMember = distributedMember;
        Assert.assertTrue(eventID != null);
        this.eventId = eventID;
    }

    public Region getRegion() {
        return this.region;
    }

    @Override
    public Operation getOperation() {
        return this.op;
    }

    public void setOperation(Operation newOp) {
        this.op = newOp;
    }

    public void setVersionTag(VersionTag<?> tag) {
        this.versionTag = tag;
    }

    @Override
    public VersionTag getVersionTag() {
        return this.versionTag;
    }

    @Override
    public Object getCallbackArgument() {
        Object result = this.callbackArgument;
        while (result instanceof WrappedCallbackArgument) {
            WrappedCallbackArgument wca = (WrappedCallbackArgument)result;
            result = wca.getOriginalCallbackArg();
        }
        if (result == Token.NOT_AVAILABLE) {
            result = null;
        }
        return result;
    }

    @Override
    public boolean isCallbackArgumentAvailable() {
        return this.callbackArgument != Token.NOT_AVAILABLE;
    }

    public Object getRawCallbackArgument() {
        return this.callbackArgument;
    }

    @Override
    public boolean isOriginRemote() {
        return this.originRemote;
    }

    @Override
    public DistributedMember getDistributedMember() {
        return this.distributedMember;
    }

    @Override
    public boolean isGenerateCallbacks() {
        return true;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(LocalizedStrings.RegionEventImpl_CLONE_IS_SUPPORTED.toLocalizedString());
        }
    }

    @Override
    public int getDSFID() {
        return 108;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString(this.regionPath, out);
        DataSerializer.writeObject(this.callbackArgument, out);
        out.writeByte(this.op.ordinal);
        out.writeBoolean(this.originRemote);
        InternalDataSerializer.invokeToData((InternalDistributedMember)this.distributedMember, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.regionPath = DataSerializer.readString(in);
        this.callbackArgument = DataSerializer.readObject(in);
        this.op = Operation.fromOrdinal(in.readByte());
        this.originRemote = in.readBoolean();
        this.distributedMember = DSFIDFactory.readInternalDistributedMember(in);
    }

    @Override
    public boolean isReinitializing() {
        return this.op == Operation.REGION_LOAD_SNAPSHOT || this.op == Operation.REGION_REINITIALIZE;
    }

    @Override
    public EventID getEventId() {
        return this.eventId;
    }

    public void setEventID(EventID eventID) {
        this.eventId = eventID;
    }

    public void setCallbackArgument(Object callbackArgument) {
        this.callbackArgument = callbackArgument;
    }

    @Override
    public EnumListenerEvent getEventType() {
        return this.eventType;
    }

    @Override
    public void setEventType(EnumListenerEvent eventType) {
        this.eventType = eventType;
    }

    @Override
    public ClientProxyMembershipID getContext() {
        return null;
    }

    @Override
    public void setLocalFilterInfo(FilterRoutingInfo.FilterInfo info) {
        this.filterInfo = info;
    }

    @Override
    public FilterRoutingInfo.FilterInfo getLocalFilterInfo() {
        return this.filterInfo;
    }

    @Override
    public boolean isBridgeEvent() {
        return this.hasClientOrigin();
    }

    @Override
    public boolean hasClientOrigin() {
        return this.getContext() != null;
    }

    String getShortClassName() {
        String cname = this.getClass().getName();
        return cname.substring(this.getClass().getPackage().getName().length() + 1);
    }

    public String toString() {
        return new StringBuffer().append(this.getShortClassName()).append("[").append("region=").append(this.getRegion()).append(";op=").append(this.getOperation()).append(";isReinitializing=").append(this.isReinitializing()).append(";callbackArg=").append(this.getCallbackArgument()).append(";originRemote=").append(this.isOriginRemote()).append(";originMember=").append(this.getDistributedMember()).append(";tag=").append(this.versionTag).append("]").toString();
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }
}

