/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.CacheEvent;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.CacheDistributionAdvisor;
import org.apache.geode.internal.cache.ClientRegionEventImpl;
import org.apache.geode.internal.cache.DistributedCacheOperation;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalCacheEvent;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegionException;
import org.apache.geode.internal.cache.PartitionedRegionHelper;
import org.apache.geode.internal.cache.RegionEventImpl;
import org.apache.geode.internal.cache.partitioned.Bucket;
import org.apache.geode.internal.cache.partitioned.PRLocallyDestroyedException;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class DestroyRegionOperation
extends DistributedCacheOperation {
    private static final Logger logger = LogService.getLogger();
    private final boolean notifyOfRegionDeparture;
    private static final ThreadLocal regionDepartureNotificationDisabled = new ThreadLocal();

    @Override
    public boolean supportsDirectAck() {
        return false;
    }

    @Override
    protected boolean supportsAdjunctMessaging() {
        return false;
    }

    @Override
    public boolean canBeSentDuringShutdown() {
        return true;
    }

    public static boolean isRegionDepartureNotificationOk() {
        return regionDepartureNotificationDisabled.get() != Boolean.TRUE;
    }

    public DestroyRegionOperation(RegionEventImpl event, boolean notifyOfRegionDeparture) {
        super(event);
        this.notifyOfRegionDeparture = notifyOfRegionDeparture;
    }

    @Override
    protected Set getRecipients() {
        CacheDistributionAdvisor advisor = this.getRegion().getCacheDistributionAdvisor();
        return advisor.adviseDestroyRegion();
    }

    @Override
    protected boolean shouldAck() {
        return true;
    }

    @Override
    protected DistributedCacheOperation.CacheOperationMessage createMessage() {
        DestroyRegionMessage mssg;
        if (this.event instanceof ClientRegionEventImpl) {
            mssg = new DestroyRegionWithContextMessage();
            mssg.context = ((ClientRegionEventImpl)this.event).getContext();
        } else {
            mssg = new DestroyRegionMessage();
        }
        mssg.notifyOfRegionDeparture = this.notifyOfRegionDeparture;
        DistributedRegion rgn = this.getRegion();
        mssg.serialNum = rgn.getSerialNumber();
        Assert.assertTrue(mssg.serialNum != -1);
        mssg.subregionSerialNumbers = rgn.getDestroyedSubregionSerialNumbers();
        RegionEventImpl rei = (RegionEventImpl)this.event;
        mssg.eventID = rei.getEventId();
        return mssg;
    }

    public static class DestroyRegionWithContextMessage
    extends DestroyRegionMessage {
        protected transient Object context;

        @Override
        public RegionEventImpl createRegionEvent(DistributedRegion rgn) {
            return new ClientRegionEventImpl(rgn, this.getOperation(), this.callbackArg, true, (DistributedMember)this.getSender(), (ClientProxyMembershipID)this.context);
        }

        @Override
        protected void appendFields(StringBuilder buff) {
            super.appendFields(buff);
            buff.append("; context=").append(this.context);
        }

        @Override
        public int getDSFID() {
            return -85;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.context = DataSerializer.readObject(in);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeObject(this.context, out);
        }
    }

    public static class DestroyRegionMessage
    extends DistributedCacheOperation.CacheOperationMessage {
        protected EventID eventID;
        protected int serialNum;
        protected HashMap subregionSerialNumbers;
        protected boolean notifyOfRegionDeparture;
        protected transient LocalRegion lockRoot = null;

        @Override
        protected InternalCacheEvent createEvent(DistributedRegion rgn) throws EntryNotFoundException {
            RegionEventImpl event = this.createRegionEvent(rgn);
            if (this.filterRouting != null) {
                event.setLocalFilterInfo(this.filterRouting.getFilterInfo(rgn.getMyId()));
            }
            event.setEventID(this.eventID);
            return event;
        }

        protected RegionEventImpl createRegionEvent(DistributedRegion rgn) {
            return new RegionEventImpl(rgn, this.getOperation(), this.callbackArg, true, this.getSender());
        }

        private Runnable destroyOp(final ClusterDistributionManager dm, final LocalRegion lclRgn, final boolean sendReply) {
            return new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int oldLevel = LocalRegion.setThreadInitLevelRequirement(1);
                    Throwable thr = null;
                    try {
                        if (lclRgn == null) {
                            Bucket advisee;
                            block34: {
                                boolean waitForBucketInitializationToComplete = true;
                                advisee = null;
                                try {
                                    advisee = PartitionedRegionHelper.getProxyBucketRegion(dm.getCache(), regionPath, waitForBucketInitializationToComplete);
                                }
                                catch (PRLocallyDestroyedException pRLocallyDestroyedException) {
                                }
                                catch (RegionDestroyedException regionDestroyedException) {
                                }
                                catch (PartitionedRegionException e) {
                                    if (e.getMessage().contains("destroyed")) break block34;
                                    throw e;
                                }
                            }
                            if (advisee != null) {
                                boolean isDestroy = op.isRegionDestroy() && !op.isClose();
                                advisee.getDistributionAdvisor().removeIdWithSerial(this.getSender(), serialNum, isDestroy);
                            } else if (logger.isDebugEnabled()) {
                                logger.debug("{} region not found, nothing to do", (Object)this);
                            }
                            return;
                        }
                        LocalRegion lr = this.getRegionFromPath(dm, lclRgn.getFullPath());
                        if (lr == null) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("{} region not found, nothing to do", (Object)this);
                            }
                            return;
                        }
                        if (!(lr instanceof DistributedRegion)) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("{} local scope region, nothing to do", (Object)this);
                            }
                            return;
                        }
                        DistributedRegion rgn = (DistributedRegion)lr;
                        InternalCacheEvent event = this.createEvent(rgn);
                        if (needsRouting && lclRgn.cache.getCacheServers().size() > 0) {
                            lclRgn.generateLocalFilterRouting(event);
                        }
                        this.doRegionDestroy(event);
                    }
                    catch (RegionDestroyedException ignore) {
                        logger.debug("{} Region destroyed: nothing to do", (Object)this);
                    }
                    catch (CancelException ignore) {
                        logger.debug("{} Cancelled: nothing to do", (Object)this);
                    }
                    catch (EntryNotFoundException ignore) {
                        logger.debug("{} Entry not found, nothing to do", (Object)this);
                    }
                    catch (VirtualMachineError err) {
                        SystemFailure.initiateFailure(err);
                        throw err;
                    }
                    catch (Throwable t) {
                        SystemFailure.checkFailure();
                        thr = t;
                    }
                    finally {
                        LocalRegion.setThreadInitLevelRequirement(oldLevel);
                        if (lockRoot != null) {
                            lockRoot.releaseDestroyLock();
                        }
                        if (sendReply) {
                            if (processorId != 0) {
                                ReplyException rex = null;
                                if (thr != null) {
                                    rex = new ReplyException(thr);
                                }
                                this.sendReply(this.getSender(), processorId, rex, this.getReplySender(dm));
                            }
                        } else if (thr != null) {
                            logger.error((Message)LocalizedMessage.create(LocalizedStrings.DestroyRegionOperation_EXCEPTION_WHILE_PROCESSING__0_, this), thr);
                        }
                    }
                }
            };
        }

        @Override
        protected void basicProcess(ClusterDistributionManager dm, LocalRegion lclRgn) {
            Assert.assertTrue(this.serialNum != -1);
            try {
                this.lockRoot = null;
                boolean sendReply = true;
                dm.getWaitingThreadPool().execute(this.destroyOp(dm, lclRgn, true));
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }

        protected LocalRegion getRegionFromPath(ClusterDistributionManager dm, String path) {
            InternalCache cache = dm.getExistingCache();
            if (this.getOperation().isDistributed()) {
                String rootName = GemFireCacheImpl.parsePath(path)[0];
                this.lockRoot = (LocalRegion)cache.getRegion(rootName);
                if (this.lockRoot == null) {
                    return null;
                }
                this.lockRoot.acquireDestroyLock();
            }
            return (LocalRegion)cache.getRegion(path);
        }

        private void disableRegionDepartureNotification() {
            if (!this.notifyOfRegionDeparture) {
                regionDepartureNotificationDisabled.set(Boolean.TRUE);
            }
        }

        private void enableRegionDepartureNotification() {
            if (!this.notifyOfRegionDeparture) {
                regionDepartureNotificationDisabled.remove();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean doRegionDestroy(CacheEvent event) throws EntryNotFoundException {
            this.appliedOperation = true;
            RegionEventImpl ev = (RegionEventImpl)event;
            final DistributedRegion rgn = (DistributedRegion)ev.region;
            if (this.getOperation().isLocal()) {
                Assert.assertTrue(this.serialNum != -1);
                this.disableRegionDepartureNotification();
                try {
                    rgn.handleRemoteLocalRegionDestroyOrClose(this.getSender(), this.serialNum, this.subregionSerialNumbers, !this.getOperation().isClose());
                }
                finally {
                    this.enableRegionDepartureNotification();
                }
                return true;
            }
            try {
                String fullPath = null;
                if (logger.isDebugEnabled()) {
                    fullPath = rgn.getFullPath();
                    StringBuffer subregionNames = new StringBuffer();
                    Iterator itr = rgn.debugGetSubregionNames().iterator();
                    while (itr.hasNext()) {
                        subregionNames.append(itr.next());
                        subregionNames.append(", ");
                    }
                    logger.debug("Processing DestroyRegionOperation, about to destroy {}, has immediate subregions: {}", (Object)fullPath, (Object)subregionNames);
                }
                if (this.getOperation() == Operation.REGION_LOAD_SNAPSHOT) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Processing DestroyRegionOperation, calling reinitialize_destroy: {}", (Object)fullPath);
                    }
                    rgn.reinitialize_destroy(ev);
                    final LocalRegion loc_lockRoot = this.lockRoot;
                    this.lockRoot = null;
                    rgn.getDistributionManager().getWaitingThreadPool().execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                rgn.reinitializeFromImageTarget(this.getSender());
                            }
                            catch (TimeoutException e) {
                                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.DestroyRegionOperation_GOT_TIMEOUT_WHEN_TRYING_TO_RECREATE_REGION_DURING_REINITIALIZATION_1, rgn.getFullPath()), (Throwable)e);
                            }
                            catch (IOException e) {
                                InternalGemFireError assErr = new InternalGemFireError(LocalizedStrings.UNEXPECTED_EXCEPTION.toLocalizedString());
                                assErr.initCause(e);
                                throw assErr;
                            }
                            catch (ClassNotFoundException e) {
                                InternalGemFireError assErr = new InternalGemFireError(LocalizedStrings.UNEXPECTED_EXCEPTION.toLocalizedString());
                                assErr.initCause(e);
                                throw assErr;
                            }
                            finally {
                                if (loc_lockRoot != null) {
                                    loc_lockRoot.releaseDestroyLock();
                                }
                            }
                        }
                    });
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Processing DestroyRegionOperation, calling basicDestroyRegion: {}", (Object)fullPath);
                    }
                    rgn.basicDestroyRegion(ev, false, false, true);
                }
            }
            catch (CacheWriterException ignore) {
                throw new Error(LocalizedStrings.DestroyRegionOperation_CACHEWRITER_SHOULD_NOT_HAVE_BEEN_CALLED.toLocalizedString());
            }
            catch (TimeoutException ignore) {
                throw new Error(LocalizedStrings.DestroyRegionOperation_DISTRIBUTEDLOCK_SHOULD_NOT_HAVE_BEEN_ACQUIRED.toLocalizedString());
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
            return true;
        }

        @Override
        protected boolean operateOnRegion(CacheEvent event, ClusterDistributionManager dm) throws EntryNotFoundException {
            Assert.assertTrue(false, LocalizedStrings.DestroyRegionOperation_REGION_DESTRUCTION_MESSAGE_IMPLEMENTATION_IS_IN_BASICPROCESS__NOT_THIS_METHOD.toLocalizedString());
            return false;
        }

        @Override
        protected void appendFields(StringBuilder buff) {
            super.appendFields(buff);
            buff.append("; eventID=").append(this.eventID).append("; serialNum=").append(this.serialNum).append("; subregionSerialNumbers=").append(this.subregionSerialNumbers).append("; notifyOfRegionDeparture=").append(this.notifyOfRegionDeparture);
        }

        @Override
        public int getDSFID() {
            return 99;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.eventID = (EventID)DataSerializer.readObject(in);
            this.serialNum = DataSerializer.readPrimitiveInt(in);
            this.notifyOfRegionDeparture = DataSerializer.readPrimitiveBoolean(in);
            this.subregionSerialNumbers = DataSerializer.readHashMap(in);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeObject(this.eventID, out);
            DataSerializer.writePrimitiveInt(this.serialNum, out);
            DataSerializer.writePrimitiveBoolean(this.notifyOfRegionDeparture, out);
            DataSerializer.writeHashMap(this.subregionSerialNumbers, out);
        }
    }
}

