/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import org.apache.geode.internal.admin.remote.EntryValueNodeImpl;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class CacheDisplay {
    public static Object getCachedObjectDisplay(Object obj, int inspectionType) {
        switch (inspectionType) {
            case 100: {
                if (obj == null) {
                    return "null";
                }
                String toString = obj.toString();
                Class<?> clazz = obj.getClass();
                String name = null;
                if (clazz.isArray()) {
                    return CacheDisplay.getArrayDisplayName(obj);
                }
                name = CacheDisplay.getClassName(clazz);
                return name + " \"" + toString + "\"";
            }
            case 300: {
                EntryValueNodeImpl physicalVal = EntryValueNodeImpl.createFromValueRoot(obj, false);
                return physicalVal == null ? "null" : physicalVal;
            }
            case 200: {
                EntryValueNodeImpl logicalVal = EntryValueNodeImpl.createFromValueRoot(obj, true);
                return logicalVal == null ? "null" : logicalVal;
            }
        }
        throw new IllegalArgumentException(LocalizedStrings.CacheDisplay_INVALID_INSPECTIONTYPE_PASSED_TO_CACHEDISPLAYGETCACHEDOBJECTDISPLAY.toLocalizedString());
    }

    private static String getArrayDisplayName(Object instance) {
        if (instance instanceof Object[]) {
            String className = instance.getClass().getName();
            return "an array of " + CacheDisplay.getClassName(className.substring(2, className.length() - 1)) + " with " + ((Object[])instance).length + " elements";
        }
        if (instance instanceof int[]) {
            return "an array of int with " + ((int[])instance).length + " elements";
        }
        if (instance instanceof double[]) {
            return "an array of double with " + ((double[])instance).length + " elements";
        }
        if (instance instanceof char[]) {
            return "an array of char with " + ((char[])instance).length + " elements";
        }
        if (instance instanceof byte[]) {
            return "an array of byte with " + ((byte[])instance).length + " elements";
        }
        if (instance instanceof boolean[]) {
            return "an array of boolean with " + ((boolean[])instance).length + " elements";
        }
        if (instance instanceof long[]) {
            return "an array of long with " + ((long[])instance).length + " elements";
        }
        if (instance instanceof float[]) {
            return "an array of float with " + ((float[])instance).length + " elements";
        }
        if (instance instanceof short[]) {
            return "an array of short with " + ((short[])instance).length + " elements";
        }
        return null;
    }

    private static String getClassName(Class clazz) {
        return CacheDisplay.getClassName(clazz.getName());
    }

    private static String getClassName(String name) {
        return name.length() > 64 ? name.substring(name.lastIndexOf(".") + 1) : name;
    }
}

