/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin;

import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.util.CacheListenerAdapter;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class ClientHealthMonitoringRegion {
    static final String ADMIN_REGION_NAME = "__ADMIN_CLIENT_HEALTH_MONITORING__";
    static final int ADMIN_REGION_EXPIRY_INTERVAL = 20;
    private static Region currentInstance;

    public static synchronized Region getInstance(InternalCache cache) {
        if (currentInstance != null && currentInstance.getCache() == cache && !cache.isClosed()) {
            return currentInstance;
        }
        if (cache == null || cache.isClosed()) {
            return null;
        }
        ClientHealthMonitoringRegion.initialize(cache);
        return currentInstance;
    }

    private static void initialize(InternalCache cache) {
        try {
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.LOCAL);
            factory.setEntryTimeToLive(new ExpirationAttributes(20, ExpirationAction.DESTROY));
            cache.getLogger().fine("ClientHealthMonitoringRegion, setting TTL for entry....");
            factory.addCacheListener(ClientHealthMonitoringRegion.prepareCacheListener());
            factory.setStatisticsEnabled(true);
            RegionAttributes regionAttrs = factory.create();
            InternalRegionArguments internalArgs = new InternalRegionArguments();
            internalArgs.setIsUsedForMetaRegion(true);
            internalArgs.setIsUsedForPartitionedRegionAdmin(false);
            currentInstance = cache.createVMRegion(ADMIN_REGION_NAME, regionAttrs, internalArgs);
        }
        catch (Exception ex) {
            cache.getLoggerI18n().error(LocalizedStrings.ClientHealthMonitoringRegion_ERROR_WHILE_CREATING_AN_ADMIN_REGION, ex);
        }
    }

    private static CacheListener prepareCacheListener() {
        return new CacheListenerAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() {
                Class<ClientHealthMonitoringRegion> clazz = ClientHealthMonitoringRegion.class;
                synchronized (ClientHealthMonitoringRegion.class) {
                    currentInstance = null;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        };
    }
}

