/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.membership;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.GemFireConfigException;
import org.apache.geode.SystemConnectException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.Locator;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.distributed.internal.membership.NetMember;
import org.apache.geode.distributed.internal.membership.NetView;
import org.apache.geode.distributed.internal.membership.gms.GMSMember;
import org.apache.geode.distributed.internal.membership.gms.GMSUtil;
import org.apache.geode.distributed.internal.membership.gms.ServiceConfig;
import org.apache.geode.distributed.internal.membership.gms.Services;
import org.apache.geode.distributed.internal.membership.gms.interfaces.JoinLeave;
import org.apache.geode.distributed.internal.membership.gms.interfaces.MessageHandler;
import org.apache.geode.distributed.internal.membership.gms.locator.FindCoordinatorRequest;
import org.apache.geode.distributed.internal.membership.gms.locator.FindCoordinatorResponse;
import org.apache.geode.distributed.internal.membership.gms.membership.HostAddress;
import org.apache.geode.distributed.internal.membership.gms.messages.HasMemberID;
import org.apache.geode.distributed.internal.membership.gms.messages.InstallViewMessage;
import org.apache.geode.distributed.internal.membership.gms.messages.JoinRequestMessage;
import org.apache.geode.distributed.internal.membership.gms.messages.JoinResponseMessage;
import org.apache.geode.distributed.internal.membership.gms.messages.LeaveRequestMessage;
import org.apache.geode.distributed.internal.membership.gms.messages.NetworkPartitionMessage;
import org.apache.geode.distributed.internal.membership.gms.messages.RemoveMemberMessage;
import org.apache.geode.distributed.internal.membership.gms.messages.ViewAckMessage;
import org.apache.geode.distributed.internal.tcpserver.TcpClient;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.security.AuthenticationRequiredException;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.logging.log4j.Logger;

public class GMSJoinLeave
implements JoinLeave,
MessageHandler {
    public static final String BYPASS_DISCOVERY_PROPERTY = "gemfire.bypass-discovery";
    private static final int DISCOVERY_TIMEOUT = Integer.getInteger("gemfire.discovery-timeout", 3000);
    private static final int JOIN_RETRY_SLEEP = Integer.getInteger("gemfire.join-retry-sleep", 1000);
    private static final long BROADCAST_MESSAGE_SLEEP_TIME = Long.getLong("gemfire.broadcast-message-sleep-time", 1000L);
    private static final int MAX_DISCOVERY_NODES = Integer.getInteger("gemfire.max-discovery-nodes", 30);
    private static final long VIEW_BROADCAST_INTERVAL = Long.getLong("gemfire.view-broadcast-interval", 60000L);
    private static final Logger logger = Services.getLogger();
    private static final boolean ALLOW_OLD_VERSION_FOR_TESTING = Boolean.getBoolean("gemfire.allow_old_members_to_join_for_testing");
    private int birthViewId;
    private InternalDistributedMember localAddress;
    private Services services;
    private volatile boolean isJoined;
    private volatile boolean isCoordinator;
    private final Object viewInstallationLock = new Object();
    private volatile NetView currentView;
    private volatile NetView previousView;
    private final Set<InternalDistributedMember> removedMembers = new HashSet<InternalDistributedMember>();
    private final Set<InternalDistributedMember> leftMembers = new HashSet<InternalDistributedMember>();
    private volatile NetView preparedView;
    private NetView lastConflictingView;
    private List<HostAddress> locators;
    private final List<DistributionMessage> viewRequests = new LinkedList<DistributionMessage>();
    long requestCollectionInterval = ServiceConfig.MEMBER_REQUEST_COLLECTION_INTERVAL;
    private final JoinResponseMessage[] joinResponse = new JoinResponseMessage[1];
    ViewReplyProcessor viewProcessor = new ViewReplyProcessor(false);
    ViewReplyProcessor prepareProcessor = new ViewReplyProcessor(true);
    private boolean quorumRequired = false;
    private int viewAckTimeout;
    private ViewCreator viewCreator;
    private volatile boolean isStopping;
    final SearchState searchState = new SearchState();
    Set<String> unitTesting = new HashSet<String>();
    private volatile boolean playingDead;
    NetView quorumLostView;
    private TcpClientWrapper tcpClientWrapper = new TcpClientWrapper();

    Object getViewInstallationLock() {
        return this.viewInstallationLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean join() {
        try {
            if (Boolean.getBoolean(BYPASS_DISCOVERY_PROPERTY)) {
                Object object = this.viewInstallationLock;
                synchronized (object) {
                    this.becomeCoordinator();
                }
                boolean bl = true;
                return bl;
            }
            SearchState state = this.searchState;
            long locatorWaitTime = (long)this.services.getConfig().getLocatorWaitTime() * 1000L;
            long timeout = this.services.getConfig().getJoinTimeout();
            logger.debug("join timeout is set to {}", (Object)timeout);
            long retrySleep = JOIN_RETRY_SLEEP;
            long startTime = System.currentTimeMillis();
            long locatorGiveUpTime = startTime + locatorWaitTime;
            long giveupTime = startTime + timeout;
            int tries = 0;
            while (!this.isJoined && !this.isStopping) {
                logger.debug("searching for the membership coordinator");
                boolean found = this.findCoordinator();
                logger.debug("state after looking for membership coordinator is {}", (Object)state);
                if (found) {
                    logger.debug("found possible coordinator {}", (Object)state.possibleCoordinator);
                    if (this.localAddress.getNetMember().preferredForCoordinator() && state.possibleCoordinator.equals(this.localAddress)) {
                        if (tries > 2 || System.currentTimeMillis() < giveupTime) {
                            Object object = this.viewInstallationLock;
                            synchronized (object) {
                                this.becomeCoordinator();
                            }
                            boolean bl = true;
                            return bl;
                        }
                    } else {
                        if (this.attemptToJoin()) {
                            boolean bl = true;
                            return bl;
                        }
                        if (!state.possibleCoordinator.equals(this.localAddress)) {
                            state.alreadyTried.add(state.possibleCoordinator);
                        }
                        if (System.currentTimeMillis() > giveupTime) {
                            break;
                        }
                    }
                } else {
                    long now = System.currentTimeMillis();
                    if (state.locatorsContacted <= 0) {
                        if (now > locatorGiveUpTime) break;
                        tries = 0;
                        giveupTime = now + timeout;
                    } else if (now > giveupTime) break;
                }
                try {
                    if (found && !state.hasContactedAJoinedLocator) {
                        if (state.possibleCoordinator.getVmViewId() < 0) {
                            logger.debug("sleeping for {} before making another attempt to find the coordinator", (Object)retrySleep);
                            Thread.sleep(retrySleep);
                        }
                        tries = 0;
                        giveupTime = System.currentTimeMillis() + timeout;
                    }
                }
                catch (InterruptedException e) {
                    logger.debug("retry sleep interrupted - giving up on joining the distributed system");
                    boolean bl = false;
                    if (this.isJoined) {
                        InternalDistributedMember internalDistributedMember = this.localAddress;
                        synchronized (internalDistributedMember) {
                            this.localAddress.notifyAll();
                        }
                    }
                    this.searchState.cleanup();
                    return bl;
                }
                ++tries;
            }
            if (!this.isJoined) {
                logger.debug("giving up attempting to join the distributed system after " + (System.currentTimeMillis() - startTime) + "ms");
            }
            if (!this.isJoined && state.hasContactedAJoinedLocator) {
                throw new SystemConnectException("Unable to join the distributed system in " + (System.currentTimeMillis() - startTime) + "ms");
            }
            boolean bl = this.isJoined;
            return bl;
        }
        finally {
            if (this.isJoined) {
                InternalDistributedMember internalDistributedMember = this.localAddress;
                synchronized (internalDistributedMember) {
                    this.localAddress.notifyAll();
                }
            }
            this.searchState.cleanup();
        }
    }

    @SuppressWarnings(value={"WA_NOT_IN_LOOP"})
    boolean attemptToJoin() {
        JoinResponseMessage response;
        SearchState state = this.searchState;
        InternalDistributedMember coord = state.possibleCoordinator;
        if (state.alreadyTried.contains(coord)) {
            logger.info("Probable coordinator is still {} - waiting for a join-response", (Object)coord);
        } else {
            logger.info("Attempting to join the distributed system through coordinator " + coord + " using address " + this.localAddress);
            int port = this.services.getHealthMonitor().getFailureDetectionPort();
            JoinRequestMessage req = new JoinRequestMessage(coord, this.localAddress, this.services.getAuthenticator().getCredentials(coord), port, this.services.getMessenger().getRequestId());
            this.services.getMessenger().send(req);
        }
        try {
            response = this.waitForJoinResponse();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        if (response == null) {
            if (!this.isJoined) {
                logger.debug("received no join response");
            }
            return this.isJoined;
        }
        logger.debug("received join response {}", (Object)response);
        this.joinResponse[0] = null;
        String failReason = response.getRejectionMessage();
        if (failReason != null) {
            if (failReason.contains("Rejecting the attempt of a member using an older version") || failReason.contains("15806")) {
                throw new SystemConnectException(failReason);
            }
            if (failReason.contains("Failed to find credentials")) {
                throw new AuthenticationRequiredException(failReason);
            }
            throw new GemFireSecurityException(failReason);
        }
        throw new RuntimeException("Join Request Failed with response " + this.joinResponse[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JoinResponseMessage waitForJoinResponse() throws InterruptedException {
        JoinResponseMessage[] joinResponseMessageArray = this.joinResponse;
        synchronized (this.joinResponse) {
            JoinResponseMessage response;
            if (this.joinResponse[0] == null && !this.isJoined) {
                long timeout = Math.max(this.services.getConfig().getMemberTimeout(), this.services.getConfig().getJoinTimeout() / 5L);
                this.joinResponse.wait(timeout);
            }
            if ((response = this.joinResponse[0]) != null && response.getCurrentView() != null && !this.isJoined) {
                this.joinResponse[0] = null;
                NetView v = response.getCurrentView();
                InternalDistributedMember coord = v.getCoordinator();
                if (this.searchState.alreadyTried.contains(coord)) {
                    this.searchState.view = response.getCurrentView();
                    long timeout = Math.max(this.services.getConfig().getMemberTimeout(), this.services.getConfig().getJoinTimeout() / 5L);
                    this.joinResponse.wait(timeout);
                    response = this.joinResponse[0];
                } else {
                    this.searchState.view = response.getCurrentView();
                    response = null;
                }
                this.searchState.view = v;
            }
            if (this.isJoined) {
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMemberLeaving(DistributedMember mbr) {
        if (this.getPendingRequestIDs(-152).contains(mbr) || this.getPendingRequestIDs(-153).contains(mbr) || !this.currentView.contains(mbr)) {
            return true;
        }
        Set<InternalDistributedMember> set = this.removedMembers;
        synchronized (set) {
            if (this.removedMembers.contains(mbr)) {
                return true;
            }
        }
        set = this.leftMembers;
        synchronized (set) {
            if (this.leftMembers.contains(mbr)) {
                return true;
            }
        }
        return false;
    }

    private void processJoinRequest(JoinRequestMessage incomingRequest) {
        String rejection;
        logger.info("Received a join request from {}", (Object)incomingRequest.getMemberID());
        if (!ALLOW_OLD_VERSION_FOR_TESTING && incomingRequest.getMemberID().getVersionObject().compareTo(Version.CURRENT) < 0) {
            logger.warn("detected an attempt to start a peer using an older version of the product {}", (Object)incomingRequest.getMemberID());
            JoinResponseMessage m = new JoinResponseMessage("Rejecting the attempt of a member using an older version of the product to join the distributed system", incomingRequest.getRequestId());
            m.setRecipient(incomingRequest.getMemberID());
            this.services.getMessenger().send(m);
            return;
        }
        Object creds = incomingRequest.getCredentials();
        try {
            rejection = this.services.getAuthenticator().authenticate(incomingRequest.getMemberID(), (Properties)creds);
        }
        catch (Exception e) {
            rejection = e.getMessage();
        }
        if (rejection != null && rejection.length() > 0) {
            JoinResponseMessage m = new JoinResponseMessage(rejection, 0);
            m.setRecipient(incomingRequest.getMemberID());
            this.services.getMessenger().send(m);
            return;
        }
        this.recordViewRequest(incomingRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLeaveRequest(LeaveRequestMessage incomingRequest) {
        logger.info("received leave request from {} for {}", (Object)incomingRequest.getSender(), (Object)incomingRequest.getMemberID());
        NetView v = this.currentView;
        if (v == null) {
            this.recordViewRequest(incomingRequest);
            return;
        }
        InternalDistributedMember mbr = incomingRequest.getMemberID();
        if (logger.isDebugEnabled()) {
            logger.debug("JoinLeave.processLeaveRequest invoked.  isCoordinator=" + this.isCoordinator + "; isStopping=" + this.isStopping + "; cancelInProgress=" + this.services.getCancelCriterion().isCancelInProgress());
        }
        if (!v.contains(mbr) && mbr.getVmViewId() < v.getViewId()) {
            logger.debug("ignoring leave request from old member");
            return;
        }
        if (incomingRequest.getMemberID().equals(this.localAddress)) {
            logger.info("I am being told to leave the distributed system by {}", (Object)incomingRequest.getSender());
            this.forceDisconnect(incomingRequest.getReason());
            return;
        }
        if (!(this.isCoordinator || this.isStopping || this.services.getCancelCriterion().isCancelInProgress())) {
            logger.debug("Checking to see if I should become coordinator");
            NetView check = new NetView(v, v.getViewId() + 1);
            check.remove(incomingRequest.getMemberID());
            Object object = this.removedMembers;
            synchronized (object) {
                check.removeAll(this.removedMembers);
                check.addCrashedMembers(this.removedMembers);
            }
            object = this.leftMembers;
            synchronized (object) {
                this.leftMembers.add(mbr);
                check.removeAll(this.leftMembers);
            }
            if (check.getCoordinator().equals(this.localAddress)) {
                object = this.viewInstallationLock;
                synchronized (object) {
                    this.becomeCoordinator(incomingRequest.getMemberID());
                }
            }
        } else if (!this.isStopping && !this.services.getCancelCriterion().isCancelInProgress()) {
            this.recordViewRequest(incomingRequest);
            this.viewProcessor.processLeaveRequest(incomingRequest.getMemberID());
            this.prepareProcessor.processLeaveRequest(incomingRequest.getMemberID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRemoveRequest(RemoveMemberMessage incomingRequest) {
        NetView v = this.currentView;
        boolean fromMe = incomingRequest.getSender() == null || incomingRequest.getSender().equals(this.localAddress);
        InternalDistributedMember mbr = incomingRequest.getMemberID();
        if (v != null && !v.contains(incomingRequest.getSender())) {
            logger.info("Membership ignoring removal request for " + mbr + " from non-member " + incomingRequest.getSender());
            return;
        }
        if (v == null) {
            return;
        }
        if (!fromMe) {
            logger.info("Membership received a request to remove " + mbr + " from " + incomingRequest.getSender() + " reason=" + incomingRequest.getReason());
        }
        if (mbr.equals(this.localAddress)) {
            this.forceDisconnect(incomingRequest.getReason());
            return;
        }
        if (this.getPendingRequestIDs(-153).contains(mbr)) {
            logger.debug("ignoring removal request as I already have a removal request for this member");
            return;
        }
        if (!(this.isCoordinator || this.isStopping || this.services.getCancelCriterion().isCancelInProgress())) {
            logger.debug("Checking to see if I should become coordinator");
            NetView check = new NetView(v, v.getViewId() + 1);
            Object object = this.removedMembers;
            synchronized (object) {
                this.removedMembers.add(mbr);
                check.addCrashedMembers(this.removedMembers);
                check.removeAll(this.removedMembers);
            }
            object = this.leftMembers;
            synchronized (object) {
                check.removeAll(this.leftMembers);
            }
            if (check.getCoordinator().equals(this.localAddress)) {
                object = this.viewInstallationLock;
                synchronized (object) {
                    this.becomeCoordinator(mbr);
                }
            }
        } else if (!(this.isStopping || this.services.getCancelCriterion().isCancelInProgress() || this.getPendingRequestIDs(-152).contains(mbr))) {
            this.recordViewRequest(incomingRequest);
            this.viewProcessor.processRemoveRequest(mbr);
            this.prepareProcessor.processRemoveRequest(mbr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordViewRequest(DistributionMessage request) {
        try {
            List<DistributionMessage> list = this.viewRequests;
            synchronized (list) {
                if (request instanceof JoinRequestMessage && this.isCoordinator && !this.services.getConfig().getDistributionConfig().getSecurityUDPDHAlgo().isEmpty()) {
                    this.services.getMessenger().initClusterKey();
                    JoinRequestMessage jreq = (JoinRequestMessage)request;
                    JoinResponseMessage response = new JoinResponseMessage(jreq.getSender(), this.services.getMessenger().getClusterSecretKey(), jreq.getRequestId());
                    this.services.getMessenger().send(response);
                }
                logger.debug("Recording the request to be processed in the next membership view");
                this.viewRequests.add(request);
                this.viewRequests.notifyAll();
            }
        }
        catch (Error | RuntimeException t) {
            logger.warn("unable to record a membership view request due to this exception", t);
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDHKeys() {
        if (this.isCoordinator && !this.services.getConfig().getDistributionConfig().getSecurityUDPDHAlgo().isEmpty()) {
            List<DistributionMessage> list = this.viewRequests;
            synchronized (list) {
                for (DistributionMessage request : this.viewRequests) {
                    if (!(request instanceof JoinRequestMessage)) continue;
                    this.services.getMessenger().initClusterKey();
                    JoinRequestMessage jreq = (JoinRequestMessage)request;
                    JoinResponseMessage response = new JoinResponseMessage(jreq.getSender(), this.services.getMessenger().getClusterSecretKey(), jreq.getRequestId());
                    this.services.getMessenger().send(response);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<DistributionMessage> getViewRequests() {
        List<DistributionMessage> list = this.viewRequests;
        synchronized (list) {
            return new LinkedList<DistributionMessage>(this.viewRequests);
        }
    }

    ViewCreator getViewCreator() {
        return this.viewCreator;
    }

    void becomeCoordinator() {
        this.becomeCoordinator(null);
    }

    public void delayViewCreationForTest(int millis) {
        this.requestCollectionInterval = millis;
    }

    private void becomeCoordinator(InternalDistributedMember oldCoordinator) {
        assert (Thread.holdsLock(this.viewInstallationLock));
        if (this.isCoordinator) {
            return;
        }
        logger.info("This member is becoming the membership coordinator with address {}", (Object)this.localAddress);
        this.isCoordinator = true;
        org.apache.geode.distributed.internal.membership.gms.interfaces.Locator locator = this.services.getLocator();
        if (locator != null) {
            locator.setIsCoordinator(true);
        }
        this.sendDHKeys();
        if (this.currentView == null) {
            NetView newView = new NetView(this.localAddress);
            newView.setFailureDetectionPort(this.localAddress, this.services.getHealthMonitor().getFailureDetectionPort());
            this.localAddress.setVmViewId(0);
            this.installView(newView);
            this.isJoined = true;
            this.createAndStartViewCreator(newView);
            this.startViewBroadcaster();
        } else {
            NetView newView = this.copyCurrentViewAndAddMyAddress(oldCoordinator);
            this.createAndStartViewCreator(newView);
            this.startViewBroadcaster();
        }
    }

    private void createAndStartViewCreator(NetView newView) {
        if (this.viewCreator == null || this.viewCreator.isShutdown()) {
            this.services.getMessenger().initClusterKey();
            this.viewCreator = new ViewCreator("Geode Membership View Creator", Services.getThreadGroup());
            if (newView != null) {
                this.viewCreator.setInitialView(newView, newView.getNewMembers(), newView.getShutdownMembers(), newView.getCrashedMembers());
            }
            this.viewCreator.setDaemon(true);
            logger.info("ViewCreator starting on:" + this.localAddress);
            this.viewCreator.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetView copyCurrentViewAndAddMyAddress(InternalDistributedMember oldCoordinator) {
        NetView newView;
        boolean testing = this.unitTesting.contains("noRandomViewChange");
        HashSet<InternalDistributedMember> leaving = new HashSet<InternalDistributedMember>();
        Object object = this.viewInstallationLock;
        synchronized (object) {
            HashSet<InternalDistributedMember> removals;
            ArrayList<InternalDistributedMember> mbrs;
            int rand = testing ? 0 : NetView.RANDOM.nextInt(10);
            int viewNumber = this.currentView.getViewId() + 5 + rand;
            if (this.localAddress.getVmViewId() < 0) {
                this.localAddress.setVmViewId(viewNumber);
            }
            if (!(mbrs = new ArrayList<InternalDistributedMember>(this.currentView.getMembers())).contains(this.localAddress)) {
                mbrs.add(this.localAddress);
            }
            Set<InternalDistributedMember> set = this.removedMembers;
            synchronized (set) {
                removals = new HashSet<InternalDistributedMember>(this.removedMembers);
            }
            set = this.leftMembers;
            synchronized (set) {
                leaving.addAll(this.leftMembers);
            }
            if (oldCoordinator != null && !removals.contains(oldCoordinator)) {
                leaving.add(oldCoordinator);
            }
            mbrs.removeAll(removals);
            mbrs.removeAll(leaving);
            newView = new NetView(this.localAddress, viewNumber, mbrs, leaving, removals);
            newView.setFailureDetectionPorts(this.currentView);
            newView.setPublicKeys(this.currentView);
            newView.setFailureDetectionPort(this.localAddress, this.services.getHealthMonitor().getFailureDetectionPort());
        }
        return newView;
    }

    private void sendRemoveMessages(List<InternalDistributedMember> removals, List<String> reasons, Set<InternalDistributedMember> oldIds) {
        Iterator<String> reason = reasons.iterator();
        for (InternalDistributedMember mbr : removals) {
            if (!oldIds.contains(mbr)) {
                RemoveMemberMessage response = new RemoveMemberMessage(mbr, mbr, reason.next());
                this.services.getMessenger().send(response);
                continue;
            }
            reason.next();
        }
    }

    boolean isShuttingDown() {
        return this.services.getCancelCriterion().isCancelInProgress() || this.services.getManager().shutdownInProgress() || this.services.getManager().isShutdownStarted();
    }

    boolean prepareView(NetView view, List<InternalDistributedMember> newMembers) throws InterruptedException {
        if (this.isShuttingDown()) {
            throw new InterruptedException("shutting down");
        }
        return this.sendView(view, true, this.prepareProcessor);
    }

    void sendView(NetView view, List<InternalDistributedMember> newMembers) throws InterruptedException {
        if (this.isShuttingDown()) {
            throw new InterruptedException("shutting down");
        }
        this.sendView(view, false, this.viewProcessor);
    }

    private boolean sendView(NetView view, boolean preparing, ViewReplyProcessor viewReplyProcessor) throws InterruptedException {
        int id = view.getViewId();
        InstallViewMessage msg = new InstallViewMessage(view, this.services.getAuthenticator().getCredentials(this.localAddress), preparing);
        HashSet<InternalDistributedMember> recips = new HashSet<InternalDistributedMember>(view.getMembers());
        recips.remove(this.localAddress);
        HashSet<InternalDistributedMember> responders = recips;
        if (!view.getCrashedMembers().isEmpty()) {
            recips = new HashSet<InternalDistributedMember>(recips);
            recips.addAll(view.getCrashedMembers());
        }
        if (preparing) {
            this.preparedView = view;
        } else {
            if (this.isCoordinator && !this.localAddress.equals(view.getCoordinator()) && this.getViewCreator() != null) {
                this.getViewCreator().markViewCreatorForShutdown();
                this.isCoordinator = false;
            }
            this.installView(view);
        }
        if (recips.isEmpty()) {
            if (!preparing) {
                logger.info("no recipients for new view aside from myself");
            }
            return true;
        }
        logger.info((preparing ? "preparing" : "sending") + " new view " + view);
        msg.setRecipients(recips);
        Set<InternalDistributedMember> pendingLeaves = this.getPendingRequestIDs(-152);
        Set<InternalDistributedMember> pendingRemovals = this.getPendingRequestIDs(-153);
        pendingRemovals.removeAll(view.getCrashedMembers());
        viewReplyProcessor.initialize(id, responders);
        viewReplyProcessor.processPendingRequests(pendingLeaves, pendingRemovals);
        this.addPublicKeysToView(view);
        this.services.getMessenger().send(msg, view);
        if (preparing) {
            logger.debug("waiting for view responses");
            Set<InternalDistributedMember> failedToRespond = viewReplyProcessor.waitForResponses();
            logger.info("finished waiting for responses to view preparation");
            InternalDistributedMember conflictingViewSender = viewReplyProcessor.getConflictingViewSender();
            NetView conflictingView = viewReplyProcessor.getConflictingView();
            if (conflictingView != null) {
                logger.warn("received a conflicting membership view from " + conflictingViewSender + " during preparation: " + conflictingView);
                return false;
            }
            if (!failedToRespond.isEmpty() && !this.services.getCancelCriterion().isCancelInProgress()) {
                logger.warn("these members failed to respond to the view change: " + failedToRespond);
                return false;
            }
        }
        return true;
    }

    private void addPublicKeysToView(NetView view) {
        String sDHAlgo = this.services.getConfig().getDistributionConfig().getSecurityUDPDHAlgo();
        if (sDHAlgo != null && !sDHAlgo.isEmpty()) {
            for (InternalDistributedMember mbr : view.getMembers()) {
                if (!Objects.isNull(view.getPublicKey(mbr))) continue;
                byte[] pk = this.services.getMessenger().getPublicKey(mbr);
                view.setPublicKey(mbr, pk);
            }
        }
    }

    private void processViewMessage(InstallViewMessage m) {
        NetView view = m.getView();
        if (!(this.currentView == null || this.currentView.contains(m.getSender()) || this.preparedView != null && this.preparedView.contains(m.getSender()))) {
            logger.info("Ignoring the view {} from member {}, which is not in my current view {} ", (Object)view, (Object)m.getSender(), (Object)this.currentView);
            return;
        }
        if (this.currentView != null && view.getViewId() < this.currentView.getViewId()) {
            this.ackView(m);
            return;
        }
        boolean viewContainsMyUnjoinedAddress = false;
        if (!this.isJoined) {
            for (InternalDistributedMember mbr : view.getMembers()) {
                if (this.localAddress.compareTo(mbr) != 0) continue;
                viewContainsMyUnjoinedAddress = true;
                break;
            }
        }
        if (m.isPreparing()) {
            if (this.preparedView != null && this.preparedView.getViewId() >= view.getViewId()) {
                this.services.getMessenger().send(new ViewAckMessage(view.getViewId(), m.getSender(), this.preparedView));
            } else {
                this.preparedView = view;
                if (viewContainsMyUnjoinedAddress) {
                    this.installView(view);
                }
                this.ackView(m);
            }
        } else if (this.isJoined && this.currentView != null && !view.contains(this.localAddress)) {
            logger.fatal("This member is no longer in the membership view.  My ID is {} and the new view is {}", (Object)this.localAddress, (Object)view);
            this.forceDisconnect("This node is no longer in the membership view");
        } else {
            if (this.isJoined || viewContainsMyUnjoinedAddress) {
                this.installView(view);
            }
            if (!m.isRebroadcast()) {
                this.ackView(m);
            }
        }
    }

    private void forceDisconnect(String reason) {
        this.isStopping = true;
        this.services.getManager().forceDisconnect(reason);
    }

    private void ackView(InstallViewMessage m) {
        if (!this.playingDead && m.getView().contains(m.getView().getCreator())) {
            this.services.getMessenger().send(new ViewAckMessage(m.getSender(), m.getView().getViewId(), m.isPreparing()));
        }
    }

    private void processViewAckMessage(ViewAckMessage m) {
        if (m.isPrepareAck()) {
            this.prepareProcessor.processViewResponse(m.getViewId(), m.getSender(), m.getAlternateView());
        } else {
            this.viewProcessor.processViewResponse(m.getViewId(), m.getSender(), m.getAlternateView());
        }
    }

    void setTcpClientWrapper(TcpClientWrapper tcpClientWrapper) {
        this.tcpClientWrapper = tcpClientWrapper;
    }

    boolean findCoordinator() {
        SearchState state = this.searchState;
        assert (this.localAddress != null);
        if (!state.hasContactedAJoinedLocator && state.registrants.size() >= this.locators.size() && state.view != null) {
            return this.findCoordinatorFromView();
        }
        String dhalgo = this.services.getConfig().getDistributionConfig().getSecurityUDPDHAlgo();
        FindCoordinatorRequest request = new FindCoordinatorRequest(this.localAddress, state.alreadyTried, state.viewId, this.services.getMessenger().getPublicKey(this.localAddress), this.services.getMessenger().getRequestId(), dhalgo);
        HashSet<InternalDistributedMember> possibleCoordinators = new HashSet<InternalDistributedMember>();
        HashSet<InternalDistributedMember> coordinatorsWithView = new HashSet<InternalDistributedMember>();
        long giveUpTime = System.currentTimeMillis() + (long)this.services.getConfig().getLocatorWaitTime() * 1000L;
        int connectTimeout = (int)this.services.getConfig().getMemberTimeout() * 2;
        boolean anyResponses = false;
        logger.debug("sending {} to {}", (Object)request, this.locators);
        state.hasContactedAJoinedLocator = false;
        state.locatorsContacted = 0;
        do {
            for (HostAddress laddr : this.locators) {
                try {
                    int viewId;
                    InetSocketAddress addr = laddr.getSocketInetAddress();
                    Object o = this.tcpClientWrapper.sendCoordinatorFindRequest(addr, request, connectTimeout);
                    FindCoordinatorResponse response = o instanceof FindCoordinatorResponse ? (FindCoordinatorResponse)o : null;
                    if (response == null) continue;
                    if (response.getRejectionMessage() != null) {
                        throw new GemFireConfigException(response.getRejectionMessage());
                    }
                    this.setCoordinatorPublicKey(response);
                    ++state.locatorsContacted;
                    if (response.getRegistrants() != null) {
                        state.registrants.addAll(response.getRegistrants());
                    }
                    if (!state.hasContactedAJoinedLocator && response.getSenderId() != null && response.getSenderId().getVmViewId() >= 0) {
                        logger.debug("Locator's address indicates it is part of a distributed system so I will not become membership coordinator on this attempt to join");
                        state.hasContactedAJoinedLocator = true;
                    }
                    if (response.getCoordinator() == null) continue;
                    anyResponses = true;
                    NetView v = response.getView();
                    int n = viewId = v == null ? -1 : v.getViewId();
                    if (viewId > state.viewId) {
                        state.viewId = viewId;
                        state.view = v;
                        state.registrants.clear();
                    }
                    if (viewId > -1) {
                        coordinatorsWithView.add(response.getCoordinator());
                    }
                    possibleCoordinators.add(response.getCoordinator());
                }
                catch (IOException | ClassNotFoundException problem) {
                    logger.debug("EOFException IOException ", (Throwable)problem);
                }
            }
        } while (!anyResponses && System.currentTimeMillis() < giveUpTime);
        if (possibleCoordinators.isEmpty()) {
            return false;
        }
        if (coordinatorsWithView.size() > 0) {
            possibleCoordinators = coordinatorsWithView;
        }
        Iterator it = possibleCoordinators.iterator();
        if (possibleCoordinators.size() == 1) {
            state.possibleCoordinator = (InternalDistributedMember)it.next();
        } else {
            InternalDistributedMember oldest = (InternalDistributedMember)it.next();
            while (it.hasNext()) {
                InternalDistributedMember candidate = (InternalDistributedMember)it.next();
                if (oldest.compareTo(candidate) <= 0) continue;
                oldest = candidate;
            }
            state.possibleCoordinator = oldest;
        }
        InternalDistributedMember coord = null;
        boolean coordIsNoob = true;
        while (it.hasNext()) {
            boolean mbrIsNoob;
            InternalDistributedMember mbr = (InternalDistributedMember)it.next();
            if (state.alreadyTried.contains(mbr)) continue;
            boolean bl = mbrIsNoob = mbr.getVmViewId() < 0;
            if (mbrIsNoob) {
                if (!coordIsNoob || coord != null && coord.compareTo(mbr) <= 0) continue;
                coord = mbr;
                continue;
            }
            if (!coordIsNoob && mbr.getVmViewId() <= coord.getVmViewId()) continue;
            coord = mbr;
            coordIsNoob = false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"WA_NOT_IN_LOOP"})
    boolean findCoordinatorFromView() {
        ArrayList<FindCoordinatorResponse> result;
        SearchState state = this.searchState;
        NetView v = state.view;
        List<InternalDistributedMember> recipients = new ArrayList<InternalDistributedMember>(v.getMembers());
        logger.debug("searching for coordinator in findCoordinatorFromView");
        if (recipients.size() > MAX_DISCOVERY_NODES && MAX_DISCOVERY_NODES > 0) {
            recipients = recipients.subList(0, MAX_DISCOVERY_NODES);
        }
        if (state.registrants != null) {
            recipients.addAll(state.registrants);
        }
        recipients.remove(this.localAddress);
        boolean testing = this.unitTesting.contains("findCoordinatorFromView");
        Set<FindCoordinatorResponse> set = state.responses;
        synchronized (set) {
            String dhalgo;
            if (!testing) {
                state.responses.clear();
            }
            if (!(dhalgo = this.services.getConfig().getDistributionConfig().getSecurityUDPDHAlgo()).isEmpty()) {
                for (InternalDistributedMember mbr : recipients) {
                    HashSet<InternalDistributedMember> r = new HashSet<InternalDistributedMember>();
                    r.add(mbr);
                    FindCoordinatorRequest req = new FindCoordinatorRequest(this.localAddress, state.alreadyTried, state.viewId, this.services.getMessenger().getPublicKey(this.localAddress), this.services.getMessenger().getRequestId(), dhalgo);
                    req.setRecipients(r);
                    this.services.getMessenger().send(req, v);
                }
            } else {
                FindCoordinatorRequest req = new FindCoordinatorRequest(this.localAddress, state.alreadyTried, state.viewId, this.services.getMessenger().getPublicKey(this.localAddress), this.services.getMessenger().getRequestId(), dhalgo);
                req.setRecipients(recipients);
                this.services.getMessenger().send(req, v);
            }
            try {
                if (!testing) {
                    state.responses.wait(DISCOVERY_TIMEOUT);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
            result = new ArrayList<FindCoordinatorResponse>(state.responses);
            state.responses.clear();
        }
        InternalDistributedMember coord = null;
        if (this.localAddress.getNetMember().preferredForCoordinator()) {
            coord = this.localAddress;
        }
        boolean coordIsNoob = true;
        for (FindCoordinatorResponse resp : result) {
            boolean mbrIsNoob;
            InternalDistributedMember mbr = resp.getCoordinator();
            if (state.alreadyTried.contains(mbr)) continue;
            boolean bl = mbrIsNoob = mbr.getVmViewId() < 0;
            if (mbrIsNoob) {
                if (!coordIsNoob || coord != null && coord.compareTo(mbr, false) <= 0) continue;
                coord = mbr;
                continue;
            }
            if (!coordIsNoob && mbr.getVmViewId() <= coord.getVmViewId()) continue;
            coord = mbr;
            coordIsNoob = false;
        }
        state.possibleCoordinator = coord;
        return coord != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processJoinResponse(JoinResponseMessage rsp) {
        JoinResponseMessage[] joinResponseMessageArray = this.joinResponse;
        synchronized (this.joinResponse) {
            if (!this.isJoined) {
                if (rsp.getRejectionMessage() != null || rsp.getCurrentView() != null) {
                    this.joinResponse[0] = rsp;
                    this.joinResponse.notifyAll();
                } else {
                    this.services.getMessenger().setClusterSecretKey(rsp.getSecretPk());
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    JoinResponseMessage[] getJoinResponseMessage() {
        return this.joinResponse;
    }

    void setJoinResponseMessage(JoinResponseMessage jrm) {
        this.joinResponse[0] = jrm;
    }

    private void processFindCoordinatorRequest(FindCoordinatorRequest req) {
        FindCoordinatorResponse resp;
        if (this.isJoined) {
            NetView v = this.currentView;
            resp = new FindCoordinatorResponse(v.getCoordinator(), this.localAddress, this.services.getMessenger().getPublicKey(v.getCoordinator()), req.getRequestId());
        } else {
            resp = new FindCoordinatorResponse(this.localAddress, this.localAddress, this.services.getMessenger().getPublicKey(this.localAddress), req.getRequestId());
        }
        resp.setRecipient(req.getMemberID());
        this.services.getMessenger().send(resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFindCoordinatorResponse(FindCoordinatorResponse resp) {
        Set<FindCoordinatorResponse> set = this.searchState.responses;
        synchronized (set) {
            this.searchState.responses.add(resp);
            this.searchState.responses.notifyAll();
        }
        this.setCoordinatorPublicKey(resp);
    }

    private void setCoordinatorPublicKey(FindCoordinatorResponse response) {
        if (response.getCoordinator() != null && response.getCoordinatorPublicKey() != null) {
            this.services.getMessenger().setPublicKey(response.getCoordinatorPublicKey(), response.getCoordinator());
        }
    }

    private void processNetworkPartitionMessage(NetworkPartitionMessage msg) {
        String str = "Membership coordinator " + msg.getSender() + " has declared that a network partition has occurred";
        this.forceDisconnect(str);
    }

    @Override
    public NetView getView() {
        return this.currentView;
    }

    @Override
    public NetView getPreviousView() {
        return this.previousView;
    }

    @Override
    public InternalDistributedMember getMemberID() {
        return this.localAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void installView(NetView newView) {
        Set<InternalDistributedMember> set = this.viewInstallationLock;
        // MONITORENTER : set
        if (this.currentView != null && this.currentView.getViewId() >= newView.getViewId()) {
            // MONITOREXIT : set
            return;
        }
        logger.info("received new view: {}\nold view is: {}", (Object)newView, (Object)this.currentView);
        if (this.currentView == null && !this.isJoined) {
            boolean found = false;
            for (InternalDistributedMember mbr : newView.getMembers()) {
                if (!this.localAddress.equals(mbr)) continue;
                found = true;
                this.birthViewId = mbr.getVmViewId();
                this.localAddress.setVmViewId(this.birthViewId);
                GMSMember me = (GMSMember)this.localAddress.getNetMember();
                me.setBirthViewId(this.birthViewId);
                break;
            }
            if (!found) {
                logger.info("rejecting view (not yet joined)");
                // MONITOREXIT : set
                return;
            }
        }
        if (this.isJoined && this.isNetworkPartition(newView, true) && this.quorumRequired) {
            Set<InternalDistributedMember> crashes = newView.getActualCrashedMembers(this.currentView);
            this.forceDisconnect(LocalizedStrings.Network_partition_detected.toLocalizedString(crashes.size(), crashes));
            // MONITOREXIT : set
            return;
        }
        this.previousView = this.currentView;
        this.currentView = newView;
        this.preparedView = null;
        this.lastConflictingView = null;
        this.services.installView(newView);
        if (!this.isJoined) {
            logger.debug("notifying join thread");
            this.isJoined = true;
            JoinResponseMessage[] joinResponseMessageArray = this.joinResponse;
            // MONITORENTER : this.joinResponse
            this.joinResponse.notifyAll();
            // MONITOREXIT : joinResponseMessageArray
        }
        if (!newView.getCreator().equals(this.localAddress)) {
            if (newView.shouldBeCoordinator(this.localAddress)) {
                this.becomeCoordinator();
            } else if (this.isCoordinator) {
                this.stopCoordinatorServices();
                this.isCoordinator = false;
            }
        }
        if (!this.isCoordinator) {
            List<DistributionMessage> list = this.viewRequests;
            // MONITORENTER : list
            Iterator<DistributionMessage> it = this.viewRequests.iterator();
            while (it.hasNext()) {
                DistributionMessage m = it.next();
                if (m instanceof JoinRequestMessage) {
                    if (!this.currentView.contains(((JoinRequestMessage)m).getMemberID())) continue;
                    it.remove();
                    continue;
                }
                if (m instanceof LeaveRequestMessage) {
                    if (this.currentView.contains(((LeaveRequestMessage)m).getMemberID())) continue;
                    it.remove();
                    continue;
                }
                if (!(m instanceof RemoveMemberMessage) || this.currentView.contains(((RemoveMemberMessage)m).getMemberID())) continue;
                it.remove();
            }
            // MONITOREXIT : list
        }
        // MONITOREXIT : set
        set = this.removedMembers;
        // MONITORENTER : set
        this.removeMembersFromCollectionIfNotInView(this.removedMembers, this.currentView);
        // MONITOREXIT : set
        set = this.leftMembers;
        // MONITORENTER : set
        this.removeMembersFromCollectionIfNotInView(this.leftMembers, this.currentView);
        // MONITOREXIT : set
    }

    private void removeMembersFromCollectionIfNotInView(Collection<InternalDistributedMember> members, NetView currentView) {
        Iterator<InternalDistributedMember> iterator = members.iterator();
        while (iterator.hasNext()) {
            if (currentView.contains(iterator.next())) continue;
            iterator.remove();
        }
    }

    void sendNetworkPartitionMessage(NetView view) {
        ArrayList<InternalDistributedMember> recipients = new ArrayList<InternalDistributedMember>(view.getMembers());
        recipients.remove(this.localAddress);
        NetworkPartitionMessage msg = new NetworkPartitionMessage(recipients);
        try {
            this.services.getMessenger().send(msg);
        }
        catch (RuntimeException e) {
            logger.debug("unable to send network partition message - continuing", (Throwable)e);
        }
    }

    public boolean isCoordinator() {
        return this.isCoordinator;
    }

    public boolean isStopping() {
        return this.isStopping;
    }

    public NetView getPreparedView() {
        return this.preparedView;
    }

    private boolean isNetworkPartition(NetView newView, boolean logWeights) {
        if (this.currentView == null) {
            return false;
        }
        int oldWeight = this.currentView.memberWeight();
        int failedWeight = newView.getCrashedMemberWeight(this.currentView);
        if (failedWeight > 0 && logWeights) {
            int failurePoint;
            if (logger.isInfoEnabled() && newView.getCreator().equals(this.localAddress)) {
                newView.logCrashedMemberWeights(this.currentView, logger);
            }
            if (failedWeight > (failurePoint = (int)((double)Math.round(51.0 * (double)oldWeight) / 100.0)) && this.quorumLostView != newView) {
                this.quorumLostView = newView;
                logger.warn("total weight lost in this view change is {} of {}.  Quorum has been lost!", (Object)failedWeight, (Object)oldWeight);
                this.services.getManager().quorumLost(newView.getActualCrashedMembers(this.currentView), this.currentView);
                return true;
            }
        }
        return false;
    }

    private void stopCoordinatorServices() {
        if (this.viewCreator != null && !this.viewCreator.isShutdown()) {
            logger.debug("Shutting down ViewCreator");
            this.viewCreator.shutdown();
            try {
                this.viewCreator.join(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void startViewBroadcaster() {
        this.services.getTimer().schedule((TimerTask)new ViewBroadcaster(), VIEW_BROADCAST_INTERVAL, VIEW_BROADCAST_INTERVAL);
    }

    public static void loadEmergencyClasses() {
    }

    @Override
    public void emergencyClose() {
        this.isStopping = true;
        this.isJoined = false;
        this.stopCoordinatorServices();
        this.isCoordinator = false;
    }

    @Override
    public void beSick() {
    }

    @Override
    public void playDead() {
        this.playingDead = true;
    }

    @Override
    public void beHealthy() {
        this.playingDead = false;
    }

    @Override
    public void start() {
    }

    @Override
    public void started() {
        this.localAddress = this.services.getMessenger().getMemberID();
        GMSMember mbr = (GMSMember)this.localAddress.getNetMember();
        if (this.services.getConfig().areLocatorsPreferredAsCoordinators()) {
            boolean preferred = false;
            if (this.services.getLocator() != null || Locator.hasLocator() || !this.services.getConfig().getDistributionConfig().getStartLocator().isEmpty() || this.localAddress.getVmKind() == 11) {
                logger.info("This member is hosting a locator will be preferred as a membership coordinator");
                preferred = true;
            }
            mbr.setPreferredForCoordinator(preferred);
        } else {
            mbr.setPreferredForCoordinator(true);
        }
    }

    @Override
    public void stop() {
        logger.debug("JoinLeave stopping");
        this.leave();
    }

    @Override
    public void stopped() {
    }

    @Override
    public void memberSuspected(InternalDistributedMember initiator, InternalDistributedMember suspect, String reason) {
        this.prepareProcessor.memberSuspected(suspect);
        this.viewProcessor.memberSuspected(suspect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void leave() {
        Object object = this.viewInstallationLock;
        synchronized (object) {
            NetView view = this.currentView;
            this.isStopping = true;
            this.stopCoordinatorServices();
            if (view != null && view.size() > 1) {
                List<InternalDistributedMember> coords = view.getPreferredCoordinators(Collections.emptySet(), this.localAddress, 5);
                logger.debug("Sending my leave request to {}", coords);
                LeaveRequestMessage m = new LeaveRequestMessage(coords, this.localAddress, "this member is shutting down");
                this.services.getMessenger().send(m);
            }
        }
    }

    @Override
    public void remove(InternalDistributedMember m, String reason) {
        NetView v = this.currentView;
        this.services.getCancelCriterion().checkCancelInProgress(null);
        if (v != null && v.contains(m)) {
            HashSet<InternalDistributedMember> filter = new HashSet<InternalDistributedMember>();
            filter.add(m);
            RemoveMemberMessage msg = new RemoveMemberMessage(v.getPreferredCoordinators(filter, this.getMemberID(), 5), m, reason);
            msg.setSender(this.localAddress);
            this.processRemoveRequest(msg);
            if (!this.isCoordinator) {
                msg.resetRecipients();
                msg.setRecipients(v.getPreferredCoordinators(Collections.emptySet(), this.localAddress, 10));
                this.services.getMessenger().send(msg);
            }
        } else {
            RemoveMemberMessage msg = new RemoveMemberMessage(m, m, reason);
            this.services.getMessenger().send(msg);
        }
    }

    @Override
    public void memberShutdown(DistributedMember mbr, String reason) {
        LeaveRequestMessage msg = new LeaveRequestMessage(Collections.singleton(this.localAddress), (InternalDistributedMember)mbr, reason);
        msg.setSender((InternalDistributedMember)mbr);
        this.processLeaveRequest(msg);
    }

    boolean checkIfAvailable(InternalDistributedMember fmbr) {
        logger.info("checking state of member " + fmbr);
        if (this.services.getHealthMonitor().checkIfAvailable(fmbr, "Member failed to acknowledge a membership view", false)) {
            logger.info("member " + fmbr + " passed availability check");
            return true;
        }
        logger.info("member " + fmbr + " failed availability check");
        return false;
    }

    private InternalDistributedMember getMemId(NetMember jgId, List<InternalDistributedMember> members) {
        for (InternalDistributedMember m : members) {
            if (!((GMSMember)m.getNetMember()).equals(jgId)) continue;
            return m;
        }
        return null;
    }

    @Override
    public InternalDistributedMember getMemberID(NetMember jgId) {
        NetView v = this.currentView;
        InternalDistributedMember ret = null;
        if (v != null) {
            ret = this.getMemId(jgId, v.getMembers());
        }
        if (ret == null && (v = this.preparedView) != null) {
            ret = this.getMemId(jgId, v.getMembers());
        }
        if (ret == null) {
            return new InternalDistributedMember(jgId);
        }
        return ret;
    }

    @Override
    public void disableDisconnectOnQuorumLossForTesting() {
        this.quorumRequired = false;
    }

    @Override
    public void init(Services s) {
        this.services = s;
        DistributionConfig dc = this.services.getConfig().getDistributionConfig();
        if (dc.getMcastPort() != 0 && StringUtils.isBlank((String)dc.getLocators()) && StringUtils.isBlank((String)dc.getStartLocator())) {
            throw new GemFireConfigException("Multicast cannot be configured for a non-distributed cache.  Please configure the locator services for this cache using locators or start-locator.");
        }
        this.services.getMessenger().addHandler(JoinRequestMessage.class, this);
        this.services.getMessenger().addHandler(JoinResponseMessage.class, this);
        this.services.getMessenger().addHandler(InstallViewMessage.class, this);
        this.services.getMessenger().addHandler(ViewAckMessage.class, this);
        this.services.getMessenger().addHandler(LeaveRequestMessage.class, this);
        this.services.getMessenger().addHandler(RemoveMemberMessage.class, this);
        this.services.getMessenger().addHandler(FindCoordinatorRequest.class, this);
        this.services.getMessenger().addHandler(FindCoordinatorResponse.class, this);
        this.services.getMessenger().addHandler(NetworkPartitionMessage.class, this);
        int ackCollectionTimeout = dc.getMemberTimeout() * 2 * 12437 / 10000;
        if (ackCollectionTimeout < 1500) {
            ackCollectionTimeout = 1500;
        } else if (ackCollectionTimeout > 12437) {
            ackCollectionTimeout = 12437;
        }
        this.viewAckTimeout = ackCollectionTimeout = Integer.getInteger("gemfire.VIEW_ACK_TIMEOUT", ackCollectionTimeout).intValue();
        this.quorumRequired = this.services.getConfig().getDistributionConfig().getEnableNetworkPartitionDetection();
        DistributionConfig dconfig = this.services.getConfig().getDistributionConfig();
        String bindAddr = dconfig.getBindAddress();
        this.locators = GMSUtil.parseLocators(dconfig.getLocators(), bindAddr);
    }

    @Override
    public void processMessage(DistributionMessage m) {
        if (this.isStopping) {
            return;
        }
        logger.debug("processing {}", (Object)m);
        switch (m.getDSFID()) {
            case -142: {
                assert (m instanceof JoinRequestMessage);
                this.processJoinRequest((JoinRequestMessage)m);
                break;
            }
            case -143: {
                assert (m instanceof JoinResponseMessage);
                this.processJoinResponse((JoinResponseMessage)m);
                break;
            }
            case -150: {
                assert (m instanceof InstallViewMessage);
                this.processViewMessage((InstallViewMessage)m);
                break;
            }
            case -151: {
                assert (m instanceof ViewAckMessage);
                this.processViewAckMessage((ViewAckMessage)m);
                break;
            }
            case -152: {
                assert (m instanceof LeaveRequestMessage);
                this.processLeaveRequest((LeaveRequestMessage)m);
                break;
            }
            case -153: {
                assert (m instanceof RemoveMemberMessage);
                this.processRemoveRequest((RemoveMemberMessage)m);
                break;
            }
            case -145: {
                assert (m instanceof FindCoordinatorRequest);
                this.processFindCoordinatorRequest((FindCoordinatorRequest)m);
                break;
            }
            case -144: {
                assert (m instanceof FindCoordinatorResponse);
                this.processFindCoordinatorResponse((FindCoordinatorResponse)m);
                break;
            }
            case -157: {
                assert (m instanceof NetworkPartitionMessage);
                this.processNetworkPartitionMessage((NetworkPartitionMessage)m);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown message type: " + m);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<InternalDistributedMember> getPendingRequestIDs(int theDSFID) {
        HashSet<InternalDistributedMember> result = new HashSet<InternalDistributedMember>();
        List<DistributionMessage> list = this.viewRequests;
        synchronized (list) {
            for (DistributionMessage msg : this.viewRequests) {
                if (msg.getDSFID() != theDSFID) continue;
                result.add(((HasMemberID)((Object)msg)).getMemberID());
            }
        }
        return result;
    }

    protected ViewReplyProcessor getPrepareViewReplyProcessor() {
        return this.prepareProcessor;
    }

    protected boolean testPrepareProcessorWaiting() {
        return this.prepareProcessor.isWaiting();
    }

    static class ViewAbandonedException
    extends Exception {
        ViewAbandonedException() {
        }
    }

    class ViewCreator
    extends Thread {
        volatile boolean shutdown;
        volatile boolean waiting;
        volatile boolean testFlagForRemovalRequest;
        volatile int abandonedViews;
        private boolean markViewCreatorForShutdown;
        NetView initialView;
        List<InternalDistributedMember> initialJoins;
        Set<InternalDistributedMember> initialLeaving;
        Set<InternalDistributedMember> initialRemovals;

        ViewCreator(String name, ThreadGroup tg) {
            super(tg, name);
            this.shutdown = false;
            this.waiting = false;
            this.testFlagForRemovalRequest = false;
            this.abandonedViews = 0;
            this.markViewCreatorForShutdown = false;
            this.initialJoins = Collections.emptyList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void shutdown() {
            this.setShutdownFlag();
            List list = GMSJoinLeave.this.viewRequests;
            synchronized (list) {
                GMSJoinLeave.this.viewRequests.notifyAll();
                this.interrupt();
            }
        }

        boolean isShutdown() {
            return this.shutdown;
        }

        boolean isWaiting() {
            return this.waiting;
        }

        int getAbandonedViewCount() {
            return this.abandonedViews;
        }

        synchronized void setInitialView(NetView newView, List<InternalDistributedMember> newMembers, Set<InternalDistributedMember> leaving, Set<InternalDistributedMember> removals) {
            this.initialView = newView;
            this.initialJoins = newMembers;
            this.initialLeaving = leaving;
            this.initialRemovals = removals;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendInitialView() {
            boolean retry;
            do {
                retry = false;
                try {
                    if (this.initialView == null) {
                        return;
                    }
                    NetView v = GMSJoinLeave.this.preparedView;
                    if (v != null) {
                        this.processPreparedView(v);
                    }
                    try {
                        Set<InternalDistributedMember> iRemoves;
                        Set<InternalDistributedMember> iLeaves;
                        List<InternalDistributedMember> iJoins;
                        NetView iView;
                        ViewCreator viewCreator = this;
                        synchronized (viewCreator) {
                            iView = this.initialView;
                            iJoins = this.initialJoins;
                            iLeaves = this.initialLeaving;
                            iRemoves = this.initialRemovals;
                        }
                        if (iView != null) {
                            this.prepareAndSendView(iView, iJoins, iLeaves, iRemoves);
                        }
                    }
                    finally {
                        this.setInitialView(null, null, null, null);
                    }
                }
                catch (ViewAbandonedException e) {
                    retry = true;
                    try {
                        ViewCreator.sleep(GMSJoinLeave.this.services.getConfig().getMemberTimeout());
                    }
                    catch (InterruptedException e2) {
                        this.setShutdownFlag();
                        retry = false;
                    }
                }
                catch (InterruptedException e) {
                    this.setShutdownFlag();
                }
                catch (DistributedSystemDisconnectedException e) {
                    this.setShutdownFlag();
                }
            } while (retry);
        }

        private void setShutdownFlag() {
            this.shutdown = true;
        }

        private void markViewCreatorForShutdown() {
            this.markViewCreatorForShutdown = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processPreparedView(NetView v) {
            assert (this.initialView != null);
            if (GMSJoinLeave.this.currentView == null || GMSJoinLeave.this.currentView.getViewId() < v.getViewId()) {
                int viewId = Math.max(this.initialView.getViewId(), v.getViewId());
                NetView newView = new NetView(this.initialView, ++viewId);
                List<InternalDistributedMember> newMembers = GMSJoinLeave.this.currentView != null ? v.getNewMembers(GMSJoinLeave.this.currentView) : v.getMembers();
                for (InternalDistributedMember newMember : newMembers) {
                    newView.add(newMember);
                    newView.setFailureDetectionPort(newMember, v.getFailureDetectionPort(newMember));
                    newView.setPublicKey(newMember, v.getPublicKey(newMember));
                }
                ViewCreator viewCreator = this;
                synchronized (viewCreator) {
                    this.setInitialView(newView, newMembers, this.initialLeaving, this.initialRemovals);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            requests = null;
            GMSJoinLeave.access$100().info("View Creator thread is starting");
            this.sendInitialView();
            okayToCreateView = System.currentTimeMillis() + GMSJoinLeave.this.requestCollectionInterval;
            while (true) {
                var4_3 = GMSJoinLeave.access$800(GMSJoinLeave.this);
                synchronized (var4_3) {
                    if (!this.shutdown) ** break block35
                }
                this.setShutdownFlag();
                this.informToPendingJoinRequests();
                break;
            }
            {
                catch (Throwable var10_14) {
                    this.setShutdownFlag();
                    this.informToPendingJoinRequests();
                    locator = GMSJoinLeave.access$300(GMSJoinLeave.this).getLocator();
                    if (locator != null) {
                        locator.setIsCoordinator(false);
                    }
                    throw var10_14;
                }
            }
            {
                locator = GMSJoinLeave.access$300(GMSJoinLeave.this).getLocator();
                if (locator != null) {
                    locator.setIsCoordinator(false);
                }
                return;
                {
                    block38: {
                        block37: {
                            block36: {
                                if (!GMSJoinLeave.access$800(GMSJoinLeave.this).isEmpty()) ** GOTO lbl60
                                try {
                                    GMSJoinLeave.access$100().debug("View Creator is waiting for requests");
                                    this.waiting = true;
                                    GMSJoinLeave.access$800(GMSJoinLeave.this).wait();
                                    this.waiting = false;
                                }
                                catch (InterruptedException e) {
                                    this.waiting = false;
                                    // MONITOREXIT @DISABLED, blocks:[16, 24, 14] lbl27 : MonitorExitStatement: MONITOREXIT : var4_3
                                    this.setShutdownFlag();
                                    this.informToPendingJoinRequests();
                                    locator = GMSJoinLeave.access$300(GMSJoinLeave.this).getLocator();
                                    if (locator != null) {
                                        locator.setIsCoordinator(false);
                                    }
                                    return;
                                    catch (Throwable var7_13) {
                                        this.waiting = false;
                                        throw var7_13;
                                    }
                                }
                                if (this.shutdown || Thread.currentThread().isInterrupted()) {
                                    // MONITOREXIT @DISABLED, blocks:[24, 14, 31] lbl39 : MonitorExitStatement: MONITOREXIT : var4_3
                                    this.setShutdownFlag();
                                    this.informToPendingJoinRequests();
                                    locator = GMSJoinLeave.access$300(GMSJoinLeave.this).getLocator();
                                    if (locator != null) {
                                        locator.setIsCoordinator(false);
                                    }
                                    return;
                                }
                                if (GMSJoinLeave.access$800(GMSJoinLeave.this).size() == 1) {
                                    okayToCreateView = System.currentTimeMillis() + GMSJoinLeave.this.requestCollectionInterval;
                                    continue;
                                }
                                ** GOTO lbl82
lbl60:
                                // 1 sources

                                if (System.currentTimeMillis() >= okayToCreateView) break block36;
                                try {
                                    GMSJoinLeave.access$800(GMSJoinLeave.this).wait(100L);
                                    continue;
                                }
                                catch (InterruptedException e) {
                                    // MONITOREXIT @DISABLED, blocks:[18, 6, 24, 14] lbl59 : MonitorExitStatement: MONITOREXIT : var4_3
                                    this.setShutdownFlag();
                                    this.informToPendingJoinRequests();
                                    locator = GMSJoinLeave.access$300(GMSJoinLeave.this).getLocator();
                                    if (locator != null) {
                                        locator.setIsCoordinator(false);
                                    }
                                    return;
                                }
                            }
                            if (requests == null) {
                                requests = new ArrayList<DistributionMessage>(GMSJoinLeave.access$800(GMSJoinLeave.this));
                            } else {
                                requests.addAll(GMSJoinLeave.access$800(GMSJoinLeave.this));
                            }
                            GMSJoinLeave.access$800(GMSJoinLeave.this).clear();
                            okayToCreateView = System.currentTimeMillis() + GMSJoinLeave.this.requestCollectionInterval;
lbl82:
                            // 2 sources

                            // MONITOREXIT @DISABLED, blocks:[8, 24, 14] lbl75 : MonitorExitStatement: MONITOREXIT : var4_3
                            if (requests == null || requests.isEmpty()) continue;
                            GMSJoinLeave.access$100().info("View Creator is processing {} requests for the next membership view", (Object)requests.size());
                            this.createAndSendView(requests);
                            if (!this.shutdown) break block37;
                            this.setShutdownFlag();
                            this.informToPendingJoinRequests();
                            locator = GMSJoinLeave.access$300(GMSJoinLeave.this).getLocator();
                            if (locator != null) {
                                locator.setIsCoordinator(false);
                            }
                            return;
                        }
                        break block38;
                        catch (ViewAbandonedException e) {
                            e = GMSJoinLeave.access$800(GMSJoinLeave.this);
                            synchronized (e) {
                                GMSJoinLeave.access$800(GMSJoinLeave.this).addAll(requests);
                            }
                            try {
                                ViewCreator.sleep(GMSJoinLeave.access$300(GMSJoinLeave.this).getConfig().getMemberTimeout());
                            }
                            catch (InterruptedException e2) {
                                this.setShutdownFlag();
                            }
                        }
                        catch (DistributedSystemDisconnectedException e) {
                            this.setShutdownFlag();
                        }
                        catch (InterruptedException e) {
                            GMSJoinLeave.access$100().info("View Creator thread interrupted");
                            this.setShutdownFlag();
                        }
                    }
                    requests = null;
                    continue;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized boolean informToPendingJoinRequests() {
            if (!this.shutdown) {
                return false;
            }
            NetView v = GMSJoinLeave.this.currentView;
            if (v.getCoordinator().equals(GMSJoinLeave.this.localAddress)) {
                return false;
            }
            ArrayList<JoinRequestMessage> requests = new ArrayList<JoinRequestMessage>();
            List list = GMSJoinLeave.this.viewRequests;
            synchronized (list) {
                if (GMSJoinLeave.this.viewRequests.isEmpty()) {
                    return false;
                }
                for (DistributionMessage msg : GMSJoinLeave.this.viewRequests) {
                    switch (msg.getDSFID()) {
                        case -142: {
                            requests.add((JoinRequestMessage)msg);
                            break;
                        }
                    }
                }
            }
            if (requests.isEmpty()) {
                return false;
            }
            for (JoinRequestMessage msg : requests) {
                logger.debug("Sending coordinator to pending join request from {} myid {} coord {}", (Object)msg.getSender(), (Object)GMSJoinLeave.this.localAddress, (Object)v.getCoordinator());
                JoinResponseMessage jrm = new JoinResponseMessage(msg.getMemberID(), v, msg.getRequestId());
                GMSJoinLeave.this.services.getMessenger().send(jrm);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void createAndSendView(List<DistributionMessage> requests) throws InterruptedException, ViewAbandonedException {
            NetView newView;
            InternalDistributedMember mbr;
            ArrayList<InternalDistributedMember> joinReqs = new ArrayList<InternalDistributedMember>(10);
            HashMap<InternalDistributedMember, Integer> joinPorts = new HashMap<InternalDistributedMember, Integer>(10);
            HashSet<InternalDistributedMember> leaveReqs = new HashSet<InternalDistributedMember>(10);
            ArrayList<InternalDistributedMember> removalReqs = new ArrayList<InternalDistributedMember>(10);
            ArrayList<String> removalReasons = new ArrayList<String>(10);
            NetView oldView = GMSJoinLeave.this.currentView;
            List<Object> oldMembers = oldView != null ? new ArrayList<InternalDistributedMember>(oldView.getMembers()) : Collections.emptyList();
            HashSet<InternalDistributedMember> oldIDs = new HashSet<InternalDistributedMember>();
            block11: for (DistributionMessage msg : requests) {
                logger.debug("processing request {}", (Object)msg);
                switch (msg.getDSFID()) {
                    case -142: {
                        JoinRequestMessage jmsg = (JoinRequestMessage)msg;
                        mbr = jmsg.getMemberID();
                        int port = jmsg.getFailureDetectionPort();
                        for (InternalDistributedMember m : oldMembers) {
                            if (mbr.compareTo(m, false) != 0) continue;
                            oldIDs.add(m);
                            break;
                        }
                        if (joinReqs.contains(mbr)) continue block11;
                        joinReqs.add(mbr);
                        joinPorts.put(mbr, port);
                        continue block11;
                    }
                    case -152: {
                        mbr = ((LeaveRequestMessage)msg).getMemberID();
                        if (!oldMembers.contains(mbr) || leaveReqs.contains(mbr)) continue block11;
                        leaveReqs.add(mbr);
                        continue block11;
                    }
                    case -153: {
                        continue block11;
                    }
                }
                logger.warn("Unknown membership request encountered: {}", (Object)msg);
            }
            for (DistributionMessage msg : requests) {
                switch (msg.getDSFID()) {
                    case -153: {
                        mbr = ((RemoveMemberMessage)msg).getMemberID();
                        if (leaveReqs.contains(mbr)) break;
                        if (oldMembers.contains(mbr) && !removalReqs.contains(mbr)) {
                            removalReqs.add(mbr);
                            removalReasons.add(((RemoveMemberMessage)msg).getReason());
                            break;
                        }
                        GMSJoinLeave.this.sendRemoveMessages(Collections.singletonList(mbr), Collections.singletonList(((RemoveMemberMessage)msg).getReason()), new HashSet());
                        break;
                    }
                }
            }
            for (InternalDistributedMember mbr2 : oldIDs) {
                if (leaveReqs.contains(mbr2) || removalReqs.contains(mbr2)) continue;
                removalReqs.add(mbr2);
                removalReasons.add("Removal of old ID that has been reused");
            }
            if (removalReqs.isEmpty() && leaveReqs.isEmpty() && joinReqs.isEmpty()) {
                return;
            }
            Iterator iterator = GMSJoinLeave.this.viewInstallationLock;
            synchronized (iterator) {
                ArrayList<Object> mbrs;
                int viewNumber = 0;
                if (GMSJoinLeave.this.currentView == null) {
                    mbrs = new ArrayList();
                } else {
                    viewNumber = GMSJoinLeave.this.currentView.getViewId() + 1;
                    mbrs = new ArrayList(oldMembers);
                }
                mbrs.removeAll(leaveReqs);
                mbrs.removeAll(removalReqs);
                mbrs.addAll(joinReqs);
                newView = new NetView(GMSJoinLeave.this.localAddress, viewNumber, mbrs, leaveReqs, new HashSet<InternalDistributedMember>(removalReqs));
                for (InternalDistributedMember mbr3 : joinReqs) {
                    if (!mbrs.contains(mbr3)) continue;
                    newView.setFailureDetectionPort(mbr3, (Integer)joinPorts.get(mbr3));
                }
                if (GMSJoinLeave.this.currentView != null) {
                    newView.setFailureDetectionPorts(GMSJoinLeave.this.currentView);
                    newView.setPublicKeys(GMSJoinLeave.this.currentView);
                }
            }
            if (joinReqs.isEmpty() && newView.getMembers().equals(GMSJoinLeave.this.currentView.getMembers())) {
                logger.info("membership hasn't changed - aborting new view {}", (Object)newView);
                return;
            }
            for (InternalDistributedMember mbr4 : joinReqs) {
                mbr4.setVmViewId(newView.getViewId());
            }
            if (this.isShutdown()) {
                return;
            }
            GMSJoinLeave.this.sendRemoveMessages(removalReqs, removalReasons, oldIDs);
            this.prepareAndSendView(newView, joinReqs, leaveReqs, newView.getCrashedMembers());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void prepareAndSendView(NetView newView, List<InternalDistributedMember> joinReqs, Set<InternalDistributedMember> leaveReqs, Set<InternalDistributedMember> removalReqs) throws InterruptedException, ViewAbandonedException {
            boolean prepared;
            do {
                boolean conflictingViewNotFromMe;
                if (this.shutdown || Thread.currentThread().isInterrupted()) {
                    return;
                }
                if (GMSJoinLeave.this.quorumRequired && GMSJoinLeave.this.isNetworkPartition(newView, true)) {
                    GMSJoinLeave.this.sendNetworkPartitionMessage(newView);
                    Thread.sleep(BROADCAST_MESSAGE_SLEEP_TIME);
                    Set<InternalDistributedMember> crashes = newView.getActualCrashedMembers(GMSJoinLeave.this.currentView);
                    GMSJoinLeave.this.forceDisconnect(LocalizedStrings.Network_partition_detected.toLocalizedString(crashes.size(), crashes));
                    this.setShutdownFlag();
                    return;
                }
                prepared = GMSJoinLeave.this.prepareView(newView, joinReqs);
                logger.debug("view preparation phase completed.  prepared={}", (Object)prepared);
                NetView conflictingView = GMSJoinLeave.this.prepareProcessor.getConflictingView();
                if (conflictingView == null) {
                    conflictingView = GMSJoinLeave.this.preparedView;
                }
                if (prepared) break;
                Set<InternalDistributedMember> unresponsive = GMSJoinLeave.this.prepareProcessor.getUnresponsiveMembers();
                unresponsive.removeAll(removalReqs);
                unresponsive.removeAll(leaveReqs);
                if (!unresponsive.isEmpty()) {
                    this.removeHealthyMembers(unresponsive);
                    List list = GMSJoinLeave.this.viewRequests;
                    synchronized (list) {
                        unresponsive = new HashSet<InternalDistributedMember>(unresponsive);
                    }
                }
                logger.debug("unresponsive members that could not be reached: {}", unresponsive);
                ArrayList<InternalDistributedMember> failures = new ArrayList<InternalDistributedMember>(GMSJoinLeave.this.currentView.getCrashedMembers().size() + unresponsive.size());
                boolean bl = conflictingViewNotFromMe = conflictingView != null && !conflictingView.getCreator().equals(GMSJoinLeave.this.localAddress) && conflictingView.getViewId() > newView.getViewId();
                if (conflictingViewNotFromMe) {
                    boolean conflictingViewIsMostRecent;
                    boolean bl2 = conflictingViewIsMostRecent = GMSJoinLeave.this.lastConflictingView == null || conflictingView.getViewId() > GMSJoinLeave.this.lastConflictingView.getViewId();
                    if (conflictingViewIsMostRecent) {
                        GMSJoinLeave.this.lastConflictingView = conflictingView;
                        if (GMSJoinLeave.this.localAddress.getVmKind() != 11 && conflictingView.getCreator().getVmKind() == 11) {
                            logger.info("View preparation interrupted - a locator is taking over as membership coordinator in this view: {}", (Object)conflictingView);
                            ++this.abandonedViews;
                            throw new ViewAbandonedException();
                        }
                        logger.info("adding these crashed members from a conflicting view to the crash-set for the next view: {}\nconflicting view: {}", unresponsive, (Object)conflictingView);
                        failures.addAll(conflictingView.getCrashedMembers());
                        if (failures.contains(GMSJoinLeave.this.localAddress)) {
                            GMSJoinLeave.this.forceDisconnect("I am no longer a member of the distributed system");
                            this.setShutdownFlag();
                            return;
                        }
                        List<InternalDistributedMember> newMembers = conflictingView.getNewMembers();
                        if (!newMembers.isEmpty()) {
                            logger.info("adding these new members from a conflicting view to the new view: {}", newMembers);
                            for (InternalDistributedMember mbr : newMembers) {
                                int port = conflictingView.getFailureDetectionPort(mbr);
                                newView.add(mbr);
                                newView.setFailureDetectionPort(mbr, port);
                                joinReqs.add(mbr);
                            }
                        }
                        if (conflictingView.getViewId() >= newView.getViewId()) {
                            newView = new NetView(newView, conflictingView.getViewId() + 1);
                        }
                    }
                }
                if (!unresponsive.isEmpty()) {
                    logger.info("adding these unresponsive members to the crash-set for the next view: {}", unresponsive);
                    failures.addAll(unresponsive);
                }
                failures.removeAll(removalReqs);
                failures.removeAll(leaveReqs);
                prepared = failures.isEmpty();
                if (!prepared) {
                    removalReqs.addAll(failures);
                    ArrayList<InternalDistributedMember> newMembers = new ArrayList<InternalDistributedMember>(newView.getMembers());
                    newMembers.removeAll(removalReqs);
                    NetView tempView = new NetView(GMSJoinLeave.this.localAddress, newView.getViewId() + 1, newMembers, leaveReqs, removalReqs);
                    for (InternalDistributedMember mbr : newView.getMembers()) {
                        if (!tempView.contains(mbr)) continue;
                        tempView.setFailureDetectionPort(mbr, newView.getFailureDetectionPort(mbr));
                    }
                    newView = tempView;
                    int size = failures.size();
                    ArrayList<String> reasons = new ArrayList<String>(size);
                    for (int i = 0; i < size; ++i) {
                        reasons.add("Failed to acknowledge a new membership view and then failed tcp/ip connection attempt");
                    }
                    GMSJoinLeave.this.sendRemoveMessages(failures, reasons, new HashSet());
                }
                if (conflictingView != null) continue;
                prepared = true;
            } while (!prepared);
            GMSJoinLeave.this.lastConflictingView = null;
            GMSJoinLeave.this.sendView(newView, joinReqs);
            if (this.markViewCreatorForShutdown && GMSJoinLeave.this.getViewCreator() != null) {
                this.setShutdownFlag();
            }
            if (GMSJoinLeave.this.isStopping()) {
                this.setShutdownFlag();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeHealthyMembers(final Set<InternalDistributedMember> suspects) throws InterruptedException {
            ArrayList<1> checkers = new ArrayList<1>(suspects.size());
            HashSet<InternalDistributedMember> newRemovals = new HashSet<InternalDistributedMember>();
            HashSet<InternalDistributedMember> newLeaves = new HashSet<InternalDistributedMember>();
            this.filterMembers(suspects, newRemovals, (short)-153);
            this.filterMembers(suspects, newLeaves, (short)-152);
            newRemovals.removeAll(newLeaves);
            suspects.removeAll(newLeaves);
            for (final InternalDistributedMember mbr : suspects) {
                if (newRemovals.contains(mbr) || newLeaves.contains(mbr)) continue;
                checkers.add(new Callable<InternalDistributedMember>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public InternalDistributedMember call() throws Exception {
                        boolean available = GMSJoinLeave.this.checkIfAvailable(mbr);
                        List list = GMSJoinLeave.this.viewRequests;
                        synchronized (list) {
                            if (available) {
                                suspects.remove(mbr);
                            }
                            GMSJoinLeave.this.viewRequests.notifyAll();
                        }
                        return mbr;
                    }

                    public String toString() {
                        return mbr.toString();
                    }
                });
            }
            if (checkers.isEmpty()) {
                logger.debug("all unresponsive members are already scheduled to be removed");
                return;
            }
            logger.debug("checking availability of these members: {}", checkers);
            ExecutorService svc = Executors.newFixedThreadPool(suspects.size(), new ThreadFactory(){
                AtomicInteger i = new AtomicInteger();

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(Services.getThreadGroup(), r, "Geode View Creator verification thread " + this.i.incrementAndGet());
                }
            });
            try {
                long giveUpTime = System.currentTimeMillis() + (long)GMSJoinLeave.this.viewAckTimeout;
                this.submitAll(svc, checkers);
                long waitTime = giveUpTime - System.currentTimeMillis();
                List list = GMSJoinLeave.this.viewRequests;
                synchronized (list) {
                    while (waitTime > 0L) {
                        logger.debug("removeHealthyMembers: mbrs" + suspects.size());
                        this.filterMembers(suspects, newRemovals, (short)-153);
                        this.filterMembers(suspects, newLeaves, (short)-152);
                        newRemovals.removeAll(newLeaves);
                        suspects.removeAll(newLeaves);
                        if (suspects.isEmpty() || newRemovals.containsAll(suspects)) break;
                        GMSJoinLeave.this.viewRequests.wait(waitTime);
                        waitTime = giveUpTime - System.currentTimeMillis();
                    }
                }
            }
            finally {
                svc.shutdownNow();
            }
        }

        protected void filterMembers(Collection<InternalDistributedMember> mbrs, Set<InternalDistributedMember> matchingMembers, short requestType) {
            Set<InternalDistributedMember> requests = GMSJoinLeave.this.getPendingRequestIDs(requestType);
            if (!requests.isEmpty()) {
                logger.debug("filterMembers: processing " + requests.size() + " requests for type " + requestType);
                for (InternalDistributedMember memberID : requests) {
                    if (!mbrs.contains(memberID)) continue;
                    this.testFlagForRemovalRequest = true;
                    matchingMembers.add(memberID);
                }
            }
        }

        private <T> List<Future<T>> submitAll(ExecutorService executor, Collection<? extends Callable<T>> tasks) {
            ArrayList<Future<T>> result = new ArrayList<Future<T>>(tasks.size());
            for (Callable<T> task : tasks) {
                result.add(executor.submit(task));
            }
            return result;
        }

        boolean getTestFlagForRemovalRequest() {
            return this.testFlagForRemovalRequest;
        }
    }

    class ViewBroadcaster
    extends TimerTask {
        ViewBroadcaster() {
        }

        @Override
        public void run() {
            if (!GMSJoinLeave.this.isCoordinator || GMSJoinLeave.this.isStopping) {
                this.cancel();
            } else {
                this.sendCurrentView();
            }
        }

        void sendCurrentView() {
            NetView v = GMSJoinLeave.this.currentView;
            if (v != null) {
                InstallViewMessage msg = new InstallViewMessage(v, GMSJoinLeave.this.services.getAuthenticator().getCredentials(GMSJoinLeave.this.localAddress), false);
                ArrayList<InternalDistributedMember> recips = new ArrayList<InternalDistributedMember>(v.size() + v.getCrashedMembers().size());
                recips.addAll(v.getMembers());
                recips.remove(GMSJoinLeave.this.localAddress);
                recips.addAll(v.getCrashedMembers());
                msg.setRecipients(recips);
                GMSJoinLeave.this.services.getMessenger().sendUnreliably(msg);
            }
        }
    }

    class ViewReplyProcessor {
        volatile int viewId = -1;
        final Set<InternalDistributedMember> notRepliedYet = new HashSet<InternalDistributedMember>();
        NetView conflictingView;
        InternalDistributedMember conflictingViewSender;
        volatile boolean waiting;
        final boolean isPrepareViewProcessor;
        final Set<InternalDistributedMember> pendingRemovals = new HashSet<InternalDistributedMember>();

        ViewReplyProcessor(boolean forPreparation) {
            this.isPrepareViewProcessor = forPreparation;
        }

        synchronized void initialize(int viewId, Set<InternalDistributedMember> recips) {
            this.waiting = true;
            this.viewId = viewId;
            this.notRepliedYet.clear();
            this.notRepliedYet.addAll(recips);
            this.conflictingView = null;
            this.pendingRemovals.clear();
        }

        boolean isWaiting() {
            return this.waiting;
        }

        synchronized void processPendingRequests(Set<InternalDistributedMember> pendingLeaves, Set<InternalDistributedMember> pendingRemovals) {
            for (InternalDistributedMember mbr : pendingLeaves) {
                this.notRepliedYet.remove(mbr);
            }
            for (InternalDistributedMember mbr : pendingRemovals) {
                if (!this.notRepliedYet.contains(mbr)) continue;
                this.pendingRemovals.add(mbr);
            }
        }

        synchronized void memberSuspected(InternalDistributedMember suspect) {
            if (this.waiting) {
                logger.debug("view response processor recording suspect status for {}", (Object)suspect);
                if (this.notRepliedYet.contains(suspect) && !this.pendingRemovals.contains(suspect)) {
                    this.pendingRemovals.add(suspect);
                    this.checkIfDone();
                }
            }
        }

        synchronized void processLeaveRequest(InternalDistributedMember mbr) {
            if (this.waiting) {
                logger.debug("view response processor recording leave request for {}", (Object)mbr);
                this.stopWaitingFor(mbr);
            }
        }

        synchronized void processRemoveRequest(InternalDistributedMember mbr) {
            if (this.waiting) {
                logger.debug("view response processor recording remove request for {}", (Object)mbr);
                this.pendingRemovals.add(mbr);
                this.checkIfDone();
            }
        }

        synchronized void processViewResponse(int viewId, InternalDistributedMember sender, NetView conflictingView) {
            if (!this.waiting) {
                return;
            }
            if (viewId == this.viewId) {
                if (conflictingView != null) {
                    this.conflictingViewSender = sender;
                    this.conflictingView = conflictingView;
                }
                logger.debug("view response processor recording response for {}", (Object)sender);
                this.stopWaitingFor(sender);
            }
        }

        private void stopWaitingFor(InternalDistributedMember mbr) {
            this.notRepliedYet.remove(mbr);
            this.checkIfDone();
        }

        private void checkIfDone() {
            if (this.notRepliedYet.isEmpty() || this.pendingRemovals != null && this.pendingRemovals.containsAll(this.notRepliedYet)) {
                logger.debug("All anticipated view responses received - notifying waiting thread");
                this.waiting = false;
                this.notifyAll();
            } else {
                logger.debug("Still waiting for these view replies: {}", this.notRepliedYet);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Set<InternalDistributedMember> waitForResponses() throws InterruptedException {
            HashSet<InternalDistributedMember> result;
            ViewReplyProcessor viewReplyProcessor;
            long endOfWait = System.currentTimeMillis() + (long)GMSJoinLeave.this.viewAckTimeout;
            try {
                while (System.currentTimeMillis() < endOfWait && !GMSJoinLeave.this.services.getCancelCriterion().isCancelInProgress()) {
                    try {
                        viewReplyProcessor = this;
                        synchronized (viewReplyProcessor) {
                            if (!this.waiting || this.notRepliedYet.isEmpty() || this.conflictingView != null) {
                                return result;
                            }
                            this.wait(1000L);
                        }
                    }
                    catch (InterruptedException e) {
                        logger.debug("Interrupted while waiting for view responses");
                        throw e;
                        return result;
                    }
                }
            }
            finally {
                viewReplyProcessor = this;
                synchronized (viewReplyProcessor) {
                    if (!this.waiting) {
                        result = new HashSet<InternalDistributedMember>(this.pendingRemovals);
                    } else {
                        result = new HashSet<InternalDistributedMember>(this.notRepliedYet);
                        result.addAll(this.pendingRemovals);
                        this.waiting = false;
                    }
                }
            }
        }

        NetView getConflictingView() {
            return this.conflictingView;
        }

        InternalDistributedMember getConflictingViewSender() {
            return this.conflictingViewSender;
        }

        synchronized Set<InternalDistributedMember> getUnresponsiveMembers() {
            return new HashSet<InternalDistributedMember>(this.notRepliedYet);
        }
    }

    protected class TcpClientWrapper {
        protected TcpClientWrapper() {
        }

        protected Object sendCoordinatorFindRequest(InetSocketAddress addr, FindCoordinatorRequest request, int connectTimeout) throws ClassNotFoundException, IOException {
            TcpClient client = new TcpClient();
            return client.requestToServer(addr, request, connectTimeout, true);
        }
    }

    static class SearchState {
        Set<InternalDistributedMember> alreadyTried = new HashSet<InternalDistributedMember>();
        Set<InternalDistributedMember> registrants = new HashSet<InternalDistributedMember>();
        InternalDistributedMember possibleCoordinator;
        int viewId = -100;
        int locatorsContacted = 0;
        boolean hasContactedAJoinedLocator;
        NetView view;
        final Set<FindCoordinatorResponse> responses = new HashSet<FindCoordinatorResponse>();

        SearchState() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cleanup() {
            this.alreadyTried.clear();
            this.possibleCoordinator = null;
            this.view = null;
            Set<FindCoordinatorResponse> set = this.responses;
            synchronized (set) {
                this.responses.clear();
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(200);
            sb.append("SearchState(locatorsContacted=").append(this.locatorsContacted).append("; alreadyTried=").append(this.alreadyTried).append("; registrants=").append(this.registrants).append("; possibleCoordinator=").append(this.possibleCoordinator).append("; viewId=").append(this.viewId).append("; hasContactedAJoinedLocator=").append(this.hasContactedAJoinedLocator).append("; view=").append(this.view).append("; responses=").append(this.responses).append(")");
            return sb.toString();
        }
    }
}

