/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import org.apache.geode.security.PostProcessor;
import org.apache.geode.security.SecurityManager;

public class SecurityConfig {
    private static final ThreadLocal<SecurityConfig> THREAD_LOCAL = new ThreadLocal();
    private final SecurityManager securityManager;
    private final PostProcessor postProcessor;

    public static void set(SecurityManager securityManager, PostProcessor postProcessor) {
        THREAD_LOCAL.set(new SecurityConfig(securityManager, postProcessor));
    }

    public static SecurityConfig get() {
        return THREAD_LOCAL.get();
    }

    public static void remove() {
        THREAD_LOCAL.remove();
    }

    public SecurityConfig(SecurityManager securityManager, PostProcessor postProcessor) {
        this.securityManager = securityManager;
        this.postProcessor = postProcessor;
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public PostProcessor getPostProcessor() {
        return this.postProcessor;
    }
}

