/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed;

import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.CacheElement;
import org.apache.geode.cache.configuration.RegionConfig;
import org.apache.geode.lang.Identifiable;
import org.apache.geode.management.internal.cli.exceptions.EntityNotFoundException;

@Experimental
public interface ClusterConfigurationService {
    public void registerBindClassWithSchema(Class var1, String var2);

    default public void registerBindClass(Class clazz) {
        this.registerBindClassWithSchema(clazz, null);
    }

    public CacheConfig getCacheConfig(String var1);

    public void updateCacheConfig(String var1, UnaryOperator<CacheConfig> var2);

    default public <T extends CacheElement> T getCustomCacheElement(String group, String id, Class<T> classT) {
        CacheConfig cacheConfig = this.getCacheConfig(group);
        return this.findCustomCacheElement(cacheConfig, id, classT);
    }

    default public void saveCustomCacheElement(String group, CacheElement element) {
        this.registerBindClass(element.getClass());
        this.updateCacheConfig(group, cacheConfig -> {
            Object foundElement = this.findCustomCacheElement((CacheConfig)cacheConfig, (String)element.getId(), element.getClass());
            if (foundElement != null) {
                cacheConfig.getCustomCacheElements().remove(foundElement);
            }
            cacheConfig.getCustomCacheElements().add(element);
            return cacheConfig;
        });
    }

    default public void deleteCustomCacheElement(String group, String id, Class<? extends CacheElement> classT) {
        this.registerBindClass(classT);
        this.updateCacheConfig(group, config -> {
            Object cacheElement = this.findCustomCacheElement((CacheConfig)config, id, classT);
            if (cacheElement == null) {
                return null;
            }
            config.getCustomCacheElements().remove(cacheElement);
            return config;
        });
    }

    default public <T extends CacheElement> T getCustomRegionElement(String group, String regionPath, String id, Class<T> classT) {
        this.registerBindClass(classT);
        CacheConfig cacheConfig = this.getCacheConfig(group);
        return this.findCustomRegionElement(cacheConfig, regionPath, id, classT);
    }

    default public void saveCustomRegionElement(String group, String regionPath, CacheElement element) {
        this.registerBindClass(element.getClass());
        this.updateCacheConfig(group, cacheConfig -> {
            RegionConfig regionConfig = this.findRegionConfiguration((CacheConfig)cacheConfig, regionPath);
            if (regionConfig == null) {
                throw new EntityNotFoundException(String.format("region %s does not exist in group %s", regionPath, group));
            }
            Object oldElement = this.findCustomRegionElement((CacheConfig)cacheConfig, regionPath, (String)element.getId(), element.getClass());
            if (oldElement != null) {
                regionConfig.getCustomRegionElements().remove(oldElement);
            }
            regionConfig.getCustomRegionElements().add(element);
            return cacheConfig;
        });
    }

    default public void deleteCustomRegionElement(String group, String regionPath, String id, Class<? extends CacheElement> classT) {
        this.registerBindClass(classT);
        this.updateCacheConfig(group, cacheConfig -> {
            RegionConfig regionConfig = this.findRegionConfiguration((CacheConfig)cacheConfig, regionPath);
            if (regionConfig == null) {
                throw new EntityNotFoundException(String.format("region %s does not exist in group %s", regionPath, group));
            }
            Object element = this.findCustomRegionElement((CacheConfig)cacheConfig, regionPath, id, classT);
            if (element == null) {
                return null;
            }
            regionConfig.getCustomRegionElements().remove(element);
            return cacheConfig;
        });
    }

    default public <T extends Identifiable<String>> T findIdentifiable(List<T> list, String id) {
        return (T)((Identifiable)list.stream().filter(o -> ((String)o.getId()).equals(id)).findFirst().orElse(null));
    }

    default public RegionConfig findRegionConfiguration(CacheConfig cacheConfig, String regionPath) {
        return this.findIdentifiable(cacheConfig.getRegion(), regionPath);
    }

    default public <T extends CacheElement> List<T> findCustomCacheElements(CacheConfig cacheConfig, Class<T> classT) {
        ArrayList<T> newList = new ArrayList<T>();
        for (CacheElement element : cacheConfig.getCustomCacheElements()) {
            if (!classT.isInstance(element)) continue;
            newList.add(classT.cast(element));
        }
        return newList;
    }

    default public <T extends CacheElement> T findCustomCacheElement(CacheConfig cacheConfig, String elementId, Class<T> classT) {
        return (T)((CacheElement)this.findIdentifiable(this.findCustomCacheElements(cacheConfig, classT), elementId));
    }

    default public <T extends CacheElement> List<T> findCustomRegionElements(CacheConfig cacheConfig, String regionPath, Class<T> classT) {
        ArrayList<T> newList = new ArrayList<T>();
        RegionConfig regionConfig = this.findRegionConfiguration(cacheConfig, regionPath);
        if (regionConfig == null) {
            return newList;
        }
        for (CacheElement element : regionConfig.getCustomRegionElements()) {
            if (!classT.isInstance(element)) continue;
            newList.add(classT.cast(element));
        }
        return newList;
    }

    default public <T extends CacheElement> T findCustomRegionElement(CacheConfig cacheConfig, String regionPath, String elementId, Class<T> classT) {
        return (T)((CacheElement)this.findIdentifiable(this.findCustomRegionElements(cacheConfig, regionPath, classT), elementId));
    }
}

