/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.query.AmbiguousNameException;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.Index;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.AbstractCompiledValue;
import org.apache.geode.cache.query.internal.AbstractGroupOrRangeJunction;
import org.apache.geode.cache.query.internal.CompiledComparison;
import org.apache.geode.cache.query.internal.CompiledLiteral;
import org.apache.geode.cache.query.internal.CompiledSortCriterion;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.Filter;
import org.apache.geode.cache.query.internal.IndexInfo;
import org.apache.geode.cache.query.internal.Indexable;
import org.apache.geode.cache.query.internal.LinkedResultSet;
import org.apache.geode.cache.query.internal.LinkedStructSet;
import org.apache.geode.cache.query.internal.OrganizedOperands;
import org.apache.geode.cache.query.internal.PlanInfo;
import org.apache.geode.cache.query.internal.QueryExecutionContext;
import org.apache.geode.cache.query.internal.QueryObserver;
import org.apache.geode.cache.query.internal.QueryObserverHolder;
import org.apache.geode.cache.query.internal.QueryUtils;
import org.apache.geode.cache.query.internal.RuntimeIterator;
import org.apache.geode.cache.query.internal.SortedResultsBag;
import org.apache.geode.cache.query.internal.Support;
import org.apache.geode.cache.query.internal.types.StructTypeImpl;
import org.apache.geode.cache.query.internal.types.TypeUtils;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.cache.query.types.StructType;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class RangeJunction
extends AbstractGroupOrRangeJunction {
    private static final int RANGE_SIZE_ESTIMATE = 3;

    RangeJunction(int operator, RuntimeIterator[] indpndntItr, boolean isCompleteExpansion, CompiledValue[] operands) {
        super(operator, indpndntItr, isCompleteExpansion, operands);
    }

    @Override
    void addUnevaluatedFilterOperands(List unevaluatedFilterOps) {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    private RangeJunction(AbstractGroupOrRangeJunction oldGJ, boolean completeExpansion, RuntimeIterator[] indpnds, CompiledValue iterOp) {
        super(oldGJ, completeExpansion, indpnds, iterOp);
    }

    @Override
    AbstractGroupOrRangeJunction recreateFromOld(boolean completeExpansion, RuntimeIterator[] indpnds, CompiledValue iterOp) {
        return new RangeJunction(this, completeExpansion, indpnds, iterOp);
    }

    @Override
    AbstractGroupOrRangeJunction createNewOfSameType(int operator, RuntimeIterator[] indpndntItr, boolean isCompleteExpansion, CompiledValue[] operands) {
        return new RangeJunction(operator, indpndntItr, isCompleteExpansion, operands);
    }

    @Override
    public PlanInfo getPlanInfo(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        return this._operands[0].getPlanInfo(context);
    }

    @Override
    public boolean isConditioningNeededForIndex(RuntimeIterator independentIter, ExecutionContext context, boolean completeExpnsNeeded) throws AmbiguousNameException, TypeMismatchException, NameResolutionException {
        return true;
    }

    @Override
    public int getOperator() {
        return 91;
    }

    @Override
    public boolean isBetterFilter(Filter comparedTo, ExecutionContext context, int thisSize) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        boolean isThisBetter = true;
        if (context instanceof QueryExecutionContext && ((QueryExecutionContext)context).hasHints()) {
            return thisSize <= comparedTo.getSizeEstimate(context);
        }
        int thatOperator = comparedTo.getOperator();
        switch (thatOperator) {
            case 13: {
                isThisBetter = false;
                break;
            }
            case 20: 
            case 21: {
                break;
            }
            case 91: {
                break;
            }
            case 18: 
            case 19: 
            case 22: 
            case 23: {
                break;
            }
            default: {
                throw new IllegalArgumentException("The operator type =" + thatOperator + " is unknown");
            }
        }
        return isThisBetter;
    }

    @Override
    OrganizedOperands organizeOperands(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (this.getOperator() == 91) {
            return this.organizeOperandsForAndJunction(context);
        }
        throw new IllegalStateException(LocalizedStrings.RangeJunction_IN_THE_CASE_OF_AN_OR_JUNCTION_A_RANGEJUNCTION_SHOULD_NOT_BE_FORMED_FOR_NOW.toLocalizedString());
    }

    private OrganizedOperands organizeOperandsForAndJunction(ExecutionContext context) throws AmbiguousNameException, FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        ArrayList<Object> evalOperands = new ArrayList<Object>(this._operands.length);
        int evalCount = 0;
        int lessCondnOp = -1;
        int greaterCondnOp = -1;
        CompiledComparison lessCondnOperand = null;
        CompiledComparison greaterCondnOperand = null;
        Filter equalCondnOperand = null;
        Object equalCondKey = null;
        Object lessCondnKey = null;
        Object greaterCondnKey = null;
        boolean emptyResults = false;
        HashSet<Object> notEqualTypeKeys = null;
        boolean possibleRangeFilter = false;
        IndexInfo indxInfo = null;
        for (int i = 0; i < this._operands.length; ++i) {
            CompiledValue operand = this._operands[i];
            if (operand.getPlanInfo((ExecutionContext)context).evalAsFilter) {
                Indexable cc = (Indexable)((Object)operand);
                if (indxInfo == null) {
                    indxInfo = cc.getIndexInfo(context)[0];
                }
                if (!cc.isRangeEvaluatable()) {
                    ++evalCount;
                    evalOperands.add(0, this._operands[i]);
                    continue;
                }
                CompiledValue ccKey = ((CompiledComparison)cc).getKey(context);
                Object evaluatedCCKey = ccKey.evaluate(context);
                int operator = ((CompiledComparison)cc).reflectOnOperator(ccKey);
                if (evaluatedCCKey == null) {
                    ++evalCount;
                    evalOperands.add(0, this._operands[i]);
                    continue;
                }
                if (equalCondnOperand != null) {
                    boolean bl = emptyResults = !this.isConditionSatisfied(equalCondKey, evaluatedCCKey, operator);
                    if (!emptyResults) continue;
                    break;
                }
                switch (operator) {
                    case 13: {
                        possibleRangeFilter = false;
                        equalCondnOperand = (CompiledComparison)cc;
                        equalCondKey = evaluatedCCKey;
                        break;
                    }
                    case 20: 
                    case 21: {
                        possibleRangeFilter = true;
                        if (notEqualTypeKeys == null) {
                            notEqualTypeKeys = new HashSet<Object>(this._operands.length);
                        }
                        evaluatedCCKey = TypeUtils.indexKeyFor(evaluatedCCKey);
                        notEqualTypeKeys.add(evaluatedCCKey);
                        break;
                    }
                    case 19: 
                    case 23: {
                        possibleRangeFilter = true;
                        if (greaterCondnOperand == null) {
                            greaterCondnOperand = (CompiledComparison)cc;
                            greaterCondnKey = evaluatedCCKey;
                            greaterCondnOp = operator;
                            break;
                        }
                        if (!this.isConditionSatisfied(evaluatedCCKey, greaterCondnKey, greaterCondnOp)) break;
                        greaterCondnKey = evaluatedCCKey;
                        greaterCondnOperand = (CompiledComparison)cc;
                        greaterCondnOp = operator;
                        break;
                    }
                    case 18: 
                    case 22: {
                        possibleRangeFilter = true;
                        if (lessCondnOperand == null) {
                            lessCondnOperand = (CompiledComparison)cc;
                            lessCondnKey = evaluatedCCKey;
                            lessCondnOp = operator;
                            break;
                        }
                        if (!this.isConditionSatisfied(evaluatedCCKey, lessCondnKey, lessCondnOp)) break;
                        lessCondnKey = evaluatedCCKey;
                        lessCondnOperand = (CompiledComparison)cc;
                        lessCondnOp = operator;
                    }
                }
                continue;
            }
            if (!this._operands[i].isDependentOnCurrentScope(context)) {
                Support.assertionFailed("An independentoperand should not ever be present as operand inside a GroupJunction as it should always be present only in CompiledJunction");
                continue;
            }
            evalOperands.add(this._operands[i]);
        }
        if (!emptyResults) {
            Filter filter = null;
            if (equalCondnOperand != null) {
                if (lessCondnOperand != null && !this.isConditionSatisfied(equalCondKey, lessCondnKey, lessCondnOp)) {
                    emptyResults = true;
                } else if (greaterCondnOperand != null && !this.isConditionSatisfied(equalCondKey, greaterCondnKey, greaterCondnOp)) {
                    emptyResults = true;
                } else if (notEqualTypeKeys != null) {
                    Iterator itr = notEqualTypeKeys.iterator();
                    while (itr.hasNext() && !emptyResults) {
                        emptyResults = !this.isConditionSatisfied(equalCondKey, itr.next(), 20);
                    }
                }
                if (!emptyResults) {
                    filter = equalCondnOperand;
                }
            } else if (possibleRangeFilter) {
                if (lessCondnOperand != null && greaterCondnOperand != null) {
                    boolean bl = emptyResults = !this.checkForRangeBoundednessAndTrimNotEqualKeyset(notEqualTypeKeys, lessCondnKey, lessCondnOp, greaterCondnKey, greaterCondnOp);
                    if (!emptyResults) {
                        filter = new DoubleCondnRangeJunctionEvaluator(lessCondnOp, lessCondnKey, greaterCondnOp, greaterCondnKey, notEqualTypeKeys == null || notEqualTypeKeys.isEmpty() ? null : notEqualTypeKeys, indxInfo);
                    }
                } else if (greaterCondnOperand != null) {
                    filter = this.generateSingleCondnEvaluatorIfRequired(notEqualTypeKeys, greaterCondnOperand, greaterCondnOp, greaterCondnKey, indxInfo);
                } else if (lessCondnOperand != null) {
                    filter = this.generateSingleCondnEvaluatorIfRequired(notEqualTypeKeys, lessCondnOperand, lessCondnOp, lessCondnKey, indxInfo);
                } else {
                    assert (notEqualTypeKeys != null && !notEqualTypeKeys.isEmpty());
                    filter = new NotEqualConditionEvaluator(notEqualTypeKeys, indxInfo);
                }
            }
            if (emptyResults) {
                evalOperands.clear();
                evalCount = 1;
                evalOperands.add(new CompiledLiteral(Boolean.FALSE));
            } else if (filter != null) {
                ++evalCount;
                evalOperands.add(0, filter);
            }
        } else {
            evalOperands.clear();
            evalCount = 1;
            evalOperands.add(new CompiledLiteral(Boolean.FALSE));
        }
        if (!(context instanceof QueryExecutionContext && ((QueryExecutionContext)context).hasMultiHints() || this.getIterOperands() == null)) {
            evalOperands.add(this.getIterOperands());
        }
        return this.createOrganizedOperandsObject(evalCount, evalOperands);
    }

    private boolean isConditionSatisfied(Object key1, Object key2, int operator) throws TypeMismatchException {
        return (Boolean)TypeUtils.compare(key1, key2, operator);
    }

    private boolean checkForRangeBoundednessAndTrimNotEqualKeyset(Set notEqualKeys, Object lessCondnKey, int lessOperator, Object greaterCondnKey, int greaterCondnOp) throws TypeMismatchException {
        if (this.isConditionSatisfied(greaterCondnKey, lessCondnKey, lessOperator) && this.isConditionSatisfied(lessCondnKey, greaterCondnKey, greaterCondnOp)) {
            if (notEqualKeys != null) {
                Iterator itr = notEqualKeys.iterator();
                Object neKey = null;
                while (itr.hasNext()) {
                    neKey = itr.next();
                    if (this.isConditionSatisfied(neKey, greaterCondnKey, greaterCondnOp) && this.isConditionSatisfied(neKey, lessCondnKey, lessOperator)) continue;
                    itr.remove();
                }
            }
            return true;
        }
        return false;
    }

    private Filter generateSingleCondnEvaluatorIfRequired(Set notEqualKeys, CompiledValue operand, int operator, Object condnKey, IndexInfo indxInfo) throws TypeMismatchException {
        if (notEqualKeys != null) {
            Iterator itr = notEqualKeys.iterator();
            while (itr.hasNext()) {
                Object neKey = itr.next();
                if (((Boolean)TypeUtils.compare(neKey, condnKey, operator)).booleanValue()) continue;
                itr.remove();
            }
            if (notEqualKeys.isEmpty()) {
                notEqualKeys = null;
            }
        }
        Filter rangeFilter = notEqualKeys != null ? new SingleCondnEvaluator(operator, condnKey, notEqualKeys, indxInfo) : (Filter)((Object)operand);
        return rangeFilter;
    }

    @Override
    public Object evaluate(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        Object r = this._operands[0].evaluate(context);
        if (r instanceof Boolean && !((Boolean)r).booleanValue()) {
            return r;
        }
        if (r == null || r == QueryService.UNDEFINED) {
            r = QueryService.UNDEFINED;
        } else if (!(r instanceof Boolean)) {
            throw new TypeMismatchException("LITERAL_and/LITERAL_or operands must be of type boolean, not type '" + r.getClass().getName() + "'");
        }
        for (int i = 1; i < this._operands.length; ++i) {
            Object ri = this._operands[i].evaluate(context);
            if (ri instanceof Boolean && !((Boolean)ri).booleanValue()) {
                return ri;
            }
            if (ri == null || ri == QueryService.UNDEFINED || r == QueryService.UNDEFINED) {
                r = QueryService.UNDEFINED;
                continue;
            }
            if (!(ri instanceof Boolean)) {
                throw new TypeMismatchException("LITERAL_and/LITERAL_or operands must be of type boolean, not type '" + ri.getClass().getName() + "'");
            }
            r = new Boolean((Boolean)r != false && (Boolean)ri != false);
        }
        return r;
    }

    @Override
    public int getType() {
        return 91;
    }

    @Override
    public void visitNodes(CompiledValue.NodeVisitor visitor) {
        Support.assertionFailed("Should not have come here");
    }

    @Override
    public int getSizeEstimate(ExecutionContext context) {
        return 3;
    }

    static boolean isInstanceOfSingleCondnEvaluator(Object o) {
        return o instanceof SingleCondnEvaluator;
    }

    static boolean isInstanceOfNotEqualConditionEvaluator(Object o) {
        return o instanceof NotEqualConditionEvaluator;
    }

    static boolean isInstanceOfDoubleCondnRangeJunctionEvaluator(Object o) {
        return o instanceof DoubleCondnRangeJunctionEvaluator;
    }

    static Set getKeysToBeRemoved(Object o) {
        if (o instanceof NotEqualConditionEvaluator) {
            if (((NotEqualConditionEvaluator)o).notEqualTypeKeys == null) {
                return null;
            }
            return Collections.unmodifiableSet(((NotEqualConditionEvaluator)o).notEqualTypeKeys);
        }
        throw new IllegalStateException(LocalizedStrings.RangeJunction_THE_OBJECT_IS_NOT_OF_TYPE_NOTEQUALCONDITIONEVALUATOR.toLocalizedString());
    }

    static int getSingleCondnEvaluatorOperator(Object o) {
        if (o instanceof SingleCondnEvaluator) {
            return ((SingleCondnEvaluator)o).condnOp;
        }
        throw new IllegalStateException(LocalizedStrings.RangeJunction_THE_OBJECT_IS_NOT_OF_TYPE_NOTEQUALCONDITIONEVALUATOR.toLocalizedString());
    }

    static Object getSingleCondnEvaluatorKey(Object o) {
        if (o instanceof SingleCondnEvaluator) {
            return ((SingleCondnEvaluator)o).condnKey;
        }
        throw new IllegalStateException(LocalizedStrings.RangeJunction_THE_OBJECT_IS_NOT_OF_TYPE_NOTEQUALCONDITIONEVALUATOR.toLocalizedString());
    }

    static Object getDoubleCondnEvaluatorLESSKey(Object o) {
        if (o instanceof DoubleCondnRangeJunctionEvaluator) {
            return ((DoubleCondnRangeJunctionEvaluator)o).lessCondnKey;
        }
        throw new IllegalStateException(LocalizedStrings.RangeJunction_THE_OBJECT_IS_NOT_OF_TYPE_NOTEQUALCONDITIONEVALUATOR.toLocalizedString());
    }

    static Object getDoubleCondnEvaluatorGreaterKey(Object o) {
        if (o instanceof DoubleCondnRangeJunctionEvaluator) {
            return ((DoubleCondnRangeJunctionEvaluator)o).greaterCondnKey;
        }
        throw new IllegalStateException(LocalizedStrings.RangeJunction_THE_OBJECT_IS_NOT_OF_TYPE_NOTEQUALCONDITIONEVALUATOR.toLocalizedString());
    }

    static int getDoubleCondnEvaluatorOperatorOfLessType(Object o) {
        if (o instanceof DoubleCondnRangeJunctionEvaluator) {
            return ((DoubleCondnRangeJunctionEvaluator)o).lessCondnOp;
        }
        throw new IllegalStateException(LocalizedStrings.RangeJunction_THE_OBJECT_IS_NOT_OF_TYPE_NOTEQUALCONDITIONEVALUATOR.toLocalizedString());
    }

    static int getDoubleCondnEvaluatorOperatorOfGreaterType(Object o) {
        if (o instanceof DoubleCondnRangeJunctionEvaluator) {
            return ((DoubleCondnRangeJunctionEvaluator)o).greaterCondnOp;
        }
        throw new IllegalStateException(LocalizedStrings.RangeJunction_THE_OBJECT_IS_NOT_OF_TYPE_NOTEQUALCONDITIONEVALUATOR.toLocalizedString());
    }

    static Index getIndex(Object o) {
        if (o instanceof NotEqualConditionEvaluator) {
            return ((NotEqualConditionEvaluator)o).indxInfo._index;
        }
        throw new IllegalStateException(LocalizedStrings.RangeJunction_THE_OBJECT_IS_NOT_OF_TYPE_NOTEQUALCONDITIONEVALUATOR.toLocalizedString());
    }

    private static class DoubleCondnRangeJunctionEvaluator
    extends NotEqualConditionEvaluator {
        protected final int lessCondnOp;
        protected final int greaterCondnOp;
        protected final Object lessCondnKey;
        protected final Object greaterCondnKey;

        DoubleCondnRangeJunctionEvaluator(int lessCondnOp, Object lessCondnKey, int greaterCondnOp, Object greaterCondnKey, Set notEqualTypeKeys, IndexInfo indexInfo) {
            super(notEqualTypeKeys, indexInfo);
            this.lessCondnOp = lessCondnOp;
            this.lessCondnKey = lessCondnKey;
            this.greaterCondnOp = greaterCondnOp;
            this.greaterCondnKey = greaterCondnKey;
        }

        @Override
        public SelectResults filterEvaluate(ExecutionContext context, SelectResults iterationLimit) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SelectResults filterEvaluate(ExecutionContext context, SelectResults iterationLimit, boolean completeExpansionNeeded, CompiledValue iterOperands, RuntimeIterator[] indpndntItrs, boolean isIntersection, boolean conditioningNeeded, boolean evalProj) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
            ObjectType resultType = this.indxInfo._index.getResultSetType();
            int indexFieldsSize = -1;
            Collection set = null;
            Boolean orderByClause = (Boolean)context.cacheGet("can_apply_orderby_at_index");
            boolean useLinkedDataStructure = false;
            boolean nullValuesAtStart = true;
            if (orderByClause != null && orderByClause.booleanValue()) {
                List orderByAttrs = (List)context.cacheGet("orderby");
                useLinkedDataStructure = orderByAttrs.size() == 1;
                boolean bl = nullValuesAtStart = !((CompiledSortCriterion)orderByAttrs.get(0)).getCriterion();
            }
            if (resultType instanceof StructType) {
                if (context.getCache().getLogger().fineEnabled()) {
                    context.getCache().getLogger().fine("StructType resultType.class=" + resultType.getClass().getName());
                }
                set = useLinkedDataStructure ? (context.isDistinct() ? new LinkedStructSet((StructTypeImpl)resultType) : new SortedResultsBag((ObjectType)((StructTypeImpl)resultType), nullValuesAtStart)) : QueryUtils.createStructCollection(context, (StructTypeImpl)resultType);
                indexFieldsSize = ((StructTypeImpl)resultType).getFieldNames().length;
            } else {
                if (context.getCache().getLogger().fineEnabled()) {
                    context.getCache().getLogger().fine("non-StructType resultType.class=" + resultType.getClass().getName());
                }
                set = useLinkedDataStructure ? (context.isDistinct() ? new LinkedResultSet(resultType) : new SortedResultsBag(resultType, nullValuesAtStart)) : QueryUtils.createResultCollection(context, resultType);
                indexFieldsSize = 1;
            }
            context.cachePut("can_apply_limit_at_index", Boolean.FALSE);
            QueryObserver observer = QueryObserverHolder.getInstance();
            try {
                observer.beforeIndexLookup(this.indxInfo._index, this.greaterCondnOp, this.greaterCondnKey, this.lessCondnOp, this.lessCondnKey, this.notEqualTypeKeys);
                context.cachePut("index_info", this.indxInfo);
                this.indxInfo._index.query(this.greaterCondnKey, this.greaterCondnOp, this.lessCondnKey, this.lessCondnOp, set, this.notEqualTypeKeys, context);
            }
            finally {
                observer.afterIndexLookup(set);
            }
            return QueryUtils.getConditionedIndexResults(set, this.indxInfo, context, indexFieldsSize, completeExpansionNeeded, iterOperands, indpndntItrs);
        }

        @Override
        public SelectResults auxFilterEvaluate(ExecutionContext context, SelectResults intermediateResults) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object evaluate(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
            Object evaluatedPath = this.indxInfo._path.evaluate(context);
            Boolean result = (Boolean)super.evaluate(context, evaluatedPath);
            if (result.booleanValue()) {
                result = (Boolean)TypeUtils.compare(evaluatedPath, this.lessCondnKey, this.lessCondnOp);
                result = result != false ? (Boolean)TypeUtils.compare(evaluatedPath, this.greaterCondnKey, this.greaterCondnOp) : Boolean.FALSE;
            }
            return result;
        }

        @Override
        public int getType() {
            return -14;
        }

        @Override
        public void visitNodes(CompiledValue.NodeVisitor visitor) {
            Support.assertionFailed("Should not have come here");
        }
    }

    private static class SingleCondnEvaluator
    extends NotEqualConditionEvaluator {
        protected int condnOp = -1;
        protected final Object condnKey;

        @Override
        public SelectResults filterEvaluate(ExecutionContext context, SelectResults iterationLimit) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
            throw new UnsupportedOperationException();
        }

        SingleCondnEvaluator(int operator, Object key, Set notEqualKeys, IndexInfo indxInfo) {
            super(notEqualKeys, indxInfo);
            this.condnOp = operator;
            this.condnKey = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SelectResults filterEvaluate(ExecutionContext context, SelectResults iterationLimit, boolean completeExpansionNeeded, CompiledValue iterOperands, RuntimeIterator[] indpndntItrs, boolean isIntersection, boolean conditioningNeeded, boolean evalProj) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
            ObjectType resultType = this.indxInfo._index.getResultSetType();
            int indexFieldsSize = -1;
            Collection set = null;
            Boolean orderByClause = (Boolean)context.cacheGet("can_apply_orderby_at_index");
            boolean useLinkedDataStructure = false;
            boolean nullValuesAtStart = true;
            if (orderByClause != null && orderByClause.booleanValue()) {
                List orderByAttrs = (List)context.cacheGet("orderby");
                useLinkedDataStructure = orderByAttrs.size() == 1;
                boolean bl = nullValuesAtStart = !((CompiledSortCriterion)orderByAttrs.get(0)).getCriterion();
            }
            if (resultType instanceof StructType) {
                if (context.getCache().getLogger().fineEnabled()) {
                    context.getCache().getLogger().fine("StructType resultType.class=" + resultType.getClass().getName());
                }
                set = useLinkedDataStructure ? (context.isDistinct() ? new LinkedStructSet((StructTypeImpl)resultType) : new SortedResultsBag((ObjectType)((StructTypeImpl)resultType), nullValuesAtStart)) : QueryUtils.createStructCollection(context, (StructTypeImpl)resultType);
                indexFieldsSize = ((StructTypeImpl)resultType).getFieldNames().length;
            } else {
                if (context.getCache().getLogger().fineEnabled()) {
                    context.getCache().getLogger().fine("non-StructType resultType.class=" + resultType.getClass().getName());
                }
                set = useLinkedDataStructure ? (context.isDistinct() ? new LinkedResultSet(resultType) : new SortedResultsBag(resultType, nullValuesAtStart)) : QueryUtils.createResultCollection(context, resultType);
                indexFieldsSize = 1;
            }
            QueryObserver observer = QueryObserverHolder.getInstance();
            try {
                observer.beforeIndexLookup(this.indxInfo._index, this.condnOp, this.condnKey);
                context.cachePut("index_info", this.indxInfo);
                this.indxInfo._index.query(this.condnKey, this.condnOp, set, this.notEqualTypeKeys, context);
            }
            finally {
                observer.afterIndexLookup(set);
            }
            return QueryUtils.getConditionedIndexResults(set, this.indxInfo, context, indexFieldsSize, completeExpansionNeeded, iterOperands, indpndntItrs);
        }

        @Override
        public Object evaluate(ExecutionContext context) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
            Object evaluatedPath = this.indxInfo._path.evaluate(context);
            Boolean result = (Boolean)super.evaluate(context, evaluatedPath);
            if (result.booleanValue()) {
                result = (Boolean)TypeUtils.compare(evaluatedPath, this.condnKey, this.condnOp);
            }
            return result;
        }

        @Override
        public int getType() {
            return -13;
        }

        @Override
        public void visitNodes(CompiledValue.NodeVisitor visitor) {
            Support.assertionFailed("Should not have come here");
        }

        @Override
        public SelectResults auxFilterEvaluate(ExecutionContext context, SelectResults intermediateResults) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
            throw new UnsupportedOperationException();
        }
    }

    private static class NotEqualConditionEvaluator
    extends AbstractCompiledValue
    implements Filter {
        final Set notEqualTypeKeys;
        final IndexInfo indxInfo;

        NotEqualConditionEvaluator(Set notEqualTypeKeys, IndexInfo indxInfo) {
            this.notEqualTypeKeys = notEqualTypeKeys;
            this.indxInfo = indxInfo;
        }

        @Override
        public SelectResults filterEvaluate(ExecutionContext context, SelectResults iterationLimit) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SelectResults filterEvaluate(ExecutionContext context, SelectResults iterationLimit, boolean completeExpansionNeeded, CompiledValue iterOperands, RuntimeIterator[] indpndntItrs, boolean isIntersection, boolean conditioningNeeded, boolean evalProj) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
            ObjectType resultType = this.indxInfo._index.getResultSetType();
            int indexFieldsSize = -1;
            Collection set = null;
            Boolean orderByClause = (Boolean)context.cacheGet("can_apply_orderby_at_index");
            boolean useLinkedDataStructure = false;
            boolean nullValuesAtStart = true;
            if (orderByClause != null && orderByClause.booleanValue()) {
                List orderByAttrs = (List)context.cacheGet("orderby");
                useLinkedDataStructure = orderByAttrs.size() == 1;
                boolean bl = nullValuesAtStart = !((CompiledSortCriterion)orderByAttrs.get(0)).getCriterion();
            }
            if (resultType instanceof StructType) {
                if (context.getCache().getLogger().fineEnabled()) {
                    context.getCache().getLogger().fine("StructType resultType.class=" + resultType.getClass().getName());
                }
                set = useLinkedDataStructure ? (context.isDistinct() ? new LinkedStructSet((StructTypeImpl)resultType) : new SortedResultsBag((ObjectType)((StructTypeImpl)resultType), nullValuesAtStart)) : QueryUtils.createStructCollection(context, (StructTypeImpl)resultType);
                indexFieldsSize = ((StructTypeImpl)resultType).getFieldNames().length;
            } else {
                if (context.getCache().getLogger().fineEnabled()) {
                    context.getCache().getLogger().fine("non-StructType resultType.class=" + resultType.getClass().getName());
                }
                set = useLinkedDataStructure ? (context.isDistinct() ? new LinkedResultSet(resultType) : new SortedResultsBag(resultType, nullValuesAtStart)) : QueryUtils.createResultCollection(context, resultType);
                indexFieldsSize = 1;
            }
            QueryObserver observer = QueryObserverHolder.getInstance();
            try {
                observer.beforeIndexLookup(this.indxInfo._index, 20, this.notEqualTypeKeys);
                context.cachePut("index_info", this.indxInfo);
                this.indxInfo._index.query(set, this.notEqualTypeKeys, context);
            }
            finally {
                observer.afterIndexLookup(set);
            }
            return QueryUtils.getConditionedIndexResults(set, this.indxInfo, context, indexFieldsSize, completeExpansionNeeded, iterOperands, indpndntItrs);
        }

        @Override
        public SelectResults auxFilterEvaluate(ExecutionContext context, SelectResults intermediateResults) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object evaluate(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
            Object evaluatedPath = this.indxInfo._path.evaluate(context);
            return this.evaluate(context, evaluatedPath);
        }

        @Override
        public boolean isConditioningNeededForIndex(RuntimeIterator independentIter, ExecutionContext context, boolean completeExpnsNeeded) throws AmbiguousNameException, TypeMismatchException, NameResolutionException {
            return true;
        }

        public Object evaluate(ExecutionContext context, Object evaluatedPath) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
            for (Object val : this.notEqualTypeKeys) {
                Object result = TypeUtils.compare(evaluatedPath, val, 20);
                if (result instanceof Boolean) {
                    if (((Boolean)result).booleanValue()) continue;
                    return Boolean.FALSE;
                }
                throw new TypeMismatchException("NotEqualConditionEvaluator should evaluate to boolean type");
            }
            return Boolean.TRUE;
        }

        @Override
        public int getType() {
            return -12;
        }

        @Override
        public int getSizeEstimate(ExecutionContext context) {
            return 3;
        }

        @Override
        public void visitNodes(CompiledValue.NodeVisitor visitor) {
            Support.assertionFailed("Should not have come here");
        }

        @Override
        public int getOperator() {
            return 91;
        }

        @Override
        public boolean isBetterFilter(Filter comparedTo, ExecutionContext context, int thisSize) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
            boolean isThisBetter = true;
            int thatOperator = comparedTo.getOperator();
            if (context instanceof QueryExecutionContext && ((QueryExecutionContext)context).hasHints()) {
                return thisSize <= comparedTo.getSizeEstimate(context);
            }
            switch (thatOperator) {
                case 13: {
                    isThisBetter = false;
                    break;
                }
                case 20: 
                case 21: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The operator type =" + thatOperator + " is unknown");
                }
            }
            return isThisBetter;
        }
    }
}

