/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.query.AmbiguousNameException;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.AbstractCompiledValue;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class CompiledUnaryMinus
extends AbstractCompiledValue {
    private CompiledValue _value;

    public CompiledUnaryMinus(CompiledValue value) {
        this._value = value;
    }

    @Override
    public List getChildren() {
        return Collections.singletonList(this._value);
    }

    @Override
    public int getType() {
        return 112;
    }

    @Override
    public Object evaluate(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        return this.minus(this._value.evaluate(context));
    }

    @Override
    public Set computeDependencies(ExecutionContext context) throws TypeMismatchException, AmbiguousNameException, NameResolutionException {
        return context.addDependencies(this, this._value.computeDependencies(context));
    }

    private Object minus(Object obj) throws TypeMismatchException {
        if (obj instanceof Number) {
            if (obj instanceof Integer) {
                return (Integer)obj * -1;
            }
            if (obj instanceof Long) {
                return (Long)obj * -1L;
            }
            if (obj instanceof Double) {
                return (Double)obj * -1.0;
            }
            if (obj instanceof Float) {
                return Float.valueOf(((Float)obj).floatValue() * -1.0f);
            }
            if (obj instanceof Byte) {
                return (byte)((Byte)obj * -1);
            }
            if (obj instanceof Short) {
                return (short)((Short)obj * -1);
            }
        } else if (obj == null || obj == QueryService.UNDEFINED) {
            return QueryService.UNDEFINED;
        }
        throw new TypeMismatchException(LocalizedStrings.CompiledUnaryMinus_0_CANNOT_BE_UNARY_MINUS.toLocalizedString(obj.getClass()));
    }
}

