/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.client.ServerOperationException;
import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.tier.MessageType;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;

public class KeySetOp {
    public static Set execute(ExecutablePool pool, String region) {
        KeySetOpImpl op = new KeySetOpImpl(region);
        return (Set)pool.execute(op);
    }

    private KeySetOp() {
    }

    private static class KeySetOpImpl
    extends AbstractOp {
        public KeySetOpImpl(String region) {
            super(40, 1);
            this.getMessage().addStringPart(region);
        }

        @Override
        protected Message createResponseMessage() {
            return new ChunkedMessage(1, Version.CURRENT);
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            ChunkedMessage keySetResponseMessage = (ChunkedMessage)msg;
            HashSet result = new HashSet();
            Exception[] exceptionRef = new Exception[1];
            keySetResponseMessage.readHeader();
            int msgType = keySetResponseMessage.getMessageType();
            if (msgType == 1) {
                do {
                    keySetResponseMessage.receiveChunk();
                    Part part = keySetResponseMessage.getPart(0);
                    Object o = part.getObject();
                    if (o instanceof Throwable) {
                        String s = "While performing a remote keySet";
                        exceptionRef[0] = new ServerOperationException(s, (Throwable)o);
                        continue;
                    }
                    result.addAll((List)o);
                } while (!keySetResponseMessage.isLastChunk());
            } else {
                if (msgType == 2) {
                    keySetResponseMessage.receiveChunk();
                    Part part = msg.getPart(0);
                    String s = "While performing a remote keySet";
                    throw new ServerOperationException(s, (Throwable)part.getObject());
                }
                if (this.isErrorResponse(msgType)) {
                    keySetResponseMessage.receiveChunk();
                    Part part = msg.getPart(0);
                    throw new ServerOperationException(part.getString());
                }
                throw new InternalGemFireError("Unexpected message type " + MessageType.getString(msgType));
            }
            if (exceptionRef[0] != null) {
                throw exceptionRef[0];
            }
            return result;
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 41;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startKeySet();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endKeySetSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endKeySet(start, this.hasTimedOut(), this.hasFailed());
        }
    }
}

